/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.relationaltags.data;

import com.ibm.etools.sdo.jdbc.ui.internal.data.FilterArgumentsManager;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IRelationalTagData;
import com.ibm.etools.sdo.ui.internal.data.ISDOData;
import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeAdapter;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.adapters.ISDONodeAdapter;
import com.ibm.etools.webtools.relationaltags.data.CBFilterArgumentsManager;
import com.ibm.etools.webtools.relationaltags.ui.wizard.CBSDOUtil;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters.IRelationalWdoNodeAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.IRelationalWebTagData;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CBRelationalWdoNodeAdapter
implements IRelationalWdoNodeAdapter {
    private String fAction;
    private String fMediator;
    private int fTargetPageSize;
    private FilterArgumentsManager fFilterArgumentsManager;
    private Element fMediatorTag;
    private Element fWDOTag;
    String fId;
    String fDataType;
    String fConnId;
    String fInputFile;
    ISDOPageDataNode fWDOPageDataNode;
    private boolean V512Type = false;

    public boolean isAdapterFor(Object key) {
        return ADAPTER_KEY.equals(key);
    }

    public CBRelationalWdoNodeAdapter(Element wdoTag) {
        this.fWDOTag = wdoTag;
        String name = wdoTag.getNodeName();
        if (name.endsWith("useCBDataObject")) {
            this.setDataType("DataObject");
        } else {
            this.setDataType("List");
        }
        NamedNodeMap map = wdoTag.getAttributes();
        Node n = map.getNamedItem("id");
        String id = n.getNodeValue();
        this.parse(id, ((IDOMNode)wdoTag).getModel().getDocument(), (IProgressMonitor)new NullProgressMonitor());
    }

    private void parse(String id, IDOMDocument document, IProgressMonitor monitor) {
        JavaModel model = null;
        try {
            model = CBSDOUtil.getCBModel(document);
            this.fId = id;
            id = JavaTypeUtil.decapitalizePropertyName((String)id);
            IBindingAttribute currentBinding = (IBindingAttribute)this.getSDOPageDataNode().getAdapter(IBindingAttribute.ADAPTER_KEY);
            this.fMediator = String.valueOf(currentBinding.getReferenceString((IPageDataNode)this.getSDOPageDataNode())) + "Mediator";
            this.fInputFile = CBSDOUtil.readMetaDataName(id, model, monitor);
            if (this.fInputFile == null) {
                model.prepareCompilationUnit((IProgressMonitor)new NullProgressMonitor());
                this.fInputFile = CBSDOUtil.readMetaDataName(id, model, monitor);
            }
            this.fConnId = CBSDOUtil.readConnectionName(id, model, monitor);
            if (this.fConnId == null) {
                this.fConnId = CBSDOUtil.readConnectionFromConnectionWrapper(id, model, monitor);
            } else {
                this.V512Type = true;
            }
            this.fTargetPageSize = CBSDOUtil.readTargetPageSize(id, model, monitor);
            this.fAction = CBSDOUtil.readAction(id, model);
        }
        finally {
            if (model != null) {
                model.release();
            }
        }
    }

    public String getConnectionId() {
        return this.fConnId;
    }

    public String getDataType() {
        return this.fDataType;
    }

    public String getId() {
        return this.fId;
    }

    public String getInputFile() {
        return this.fInputFile;
    }

    public Metadata getMetadata() {
        return (Metadata)this.getSDOPageDataNode().getSDODataFactory().getMetaDataModel();
    }

    public ISDOPageDataNode getSDOPageDataNode() {
        if (this.fWDOPageDataNode == null) {
            this.fWDOPageDataNode = this.getWDOPageDataNode((IDOMNode)this.fWDOTag);
        }
        return this.fWDOPageDataNode;
    }

    protected SDOPageDataNode getWDOPageDataNode(IDOMNode node) {
        IPageDataNode pageDataNode;
        SDOPageDataNode wdoPageDataNode = null;
        PageDataNodeAdapter adapter = (PageDataNodeAdapter)node.getAdapterFor((Object)"PageDataNodeAdapterFactorycom.ibm.etools.webtools.pagedataview.WDO");
        if (adapter != null && (pageDataNode = adapter.getPageDataNode()) instanceof SDOPageDataNode) {
            wdoPageDataNode = (SDOPageDataNode)pageDataNode;
        }
        return wdoPageDataNode;
    }

    public void setConnectionId(String string) {
        this.fConnId = string;
    }

    public void setDataType(String string) {
        this.fDataType = string;
    }

    public void setId(String string) {
        this.fId = string;
    }

    public void setInputFile(String inputFile) {
        this.fInputFile = inputFile;
    }

    public int getTargetPageSize() {
        return this.fTargetPageSize;
    }

    public void setTargetPageSize(int size) {
        this.fTargetPageSize = size;
    }

    public void setSDOPageDataNode(ISDOPageDataNode node) {
        this.fWDOPageDataNode = node;
    }

    public void notifySDOPageDataNodeChanged() throws MediatorException {
    }

    public FilterArgumentsManager getFilterArgumentsManager() {
        if (this.fFilterArgumentsManager == null) {
            this.fFilterArgumentsManager = new CBFilterArgumentsManager(true);
        }
        if (this.fMediatorTag != null) {
            this.fFilterArgumentsManager.setMetadata(this.getMetadata());
            this.fFilterArgumentsManager.setNode(this.fMediatorTag);
        } else {
            this.fFilterArgumentsManager.setNode(this.fWDOTag);
        }
        return this.fFilterArgumentsManager;
    }

    public IFile getFile() {
        return this.getSDOPageDataNode().getPageDataModel().getResource();
    }

    public IProject getProject() {
        return this.getSDOPageDataNode().getPageDataModel().getResource().getProject();
    }

    public String getELValuePrefix() {
        return "#{";
    }

    public String getMediator() {
        return this.fMediator;
    }

    public String getAction() {
        return this.fAction;
    }

    public void setAction(String action) {
        this.fAction = action;
    }

    public void fillModel(ISDOData data) {
        IRelationalTagData tagData = (IRelationalTagData)data.getTagData();
        IRelationalWebTagData webTagData = (IRelationalWebTagData)tagData;
        data.setConfigureExistingData(true);
        data.setExistingFilePath(this.fInputFile);
        try {
            webTagData.updateTagRegionData((ISDONodeAdapter)this);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

