/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.wdo;

import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.webtools.codebehind.java.CBModelUtil;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaDocElement;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.JavaCommand;
import com.ibm.etools.webtools.javamodel.commands.UpdateMethodCommand;
import com.ibm.etools.webtools.javamodel.tasks.ExecuteSingleJavaCommandTask;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ui.ExistingSDOConfigureDialog;
import com.ibm.etools.webtools.pagedataview.wdo.ISDODataGetterBodyInterface;
import com.ibm.etools.webtools.pagedataview.wdo.SDOCBModelUtil;
import com.ibm.etools.webtools.pagedataview.wdo.SDODataGetterBodyTemplate;
import com.ibm.etools.webtools.pagedataview.wdo.WDOCBPageDataNode;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class ExistingCBSDOConfigureDialog
extends ExistingSDOConfigureDialog {
    public ExistingCBSDOConfigureDialog(String name, WDOCBPageDataNode nodeToConfigure, Shell parentShell) {
        super(name, (SDOPageDataNode)nodeToConfigure, parentShell);
    }

    protected void okPressed() {
        super.okPressed();
        String path = this.getPath();
        String metadataFile = this.getMetadataFilePath();
        WDOCBPageDataNode node = (WDOCBPageDataNode)this.getNodeToConfigure();
        IMethod method = node.getCodeBehindMethod();
        try {
            JavaDocInfo javadoc = CBModelUtil.readJavaDoc((IMethod)method);
            List list = javadoc.getDocletList();
            if (list != null && list.size() > 0) {
                int i = 0;
                while (i < list.size()) {
                    JavaDocElement element = (JavaDocElement)list.get(i);
                    if (element.getTagName().equals("mediatorProperties")) {
                        this.updateAttributeInJavaDocElement(element, "subPath=", path);
                        this.updateAttributeInJavaDocElement(element, "metadataFileName=", metadataFile);
                    }
                    ++i;
                }
                ISDODataGetterBodyInterface it = new ISDODataGetterBodyInterface(){

                    @Override
                    public String getSDODataFieldName() {
                        return ExistingCBSDOConfigureDialog.this.getName();
                    }

                    @Override
                    public String getSDODataFieldType() {
                        return ExistingCBSDOConfigureDialog.this.getSDOType();
                    }

                    @Override
                    public boolean isExistingSDOFromScope() {
                        return true;
                    }

                    @Override
                    public String getScopeName() {
                        return ExistingCBSDOConfigureDialog.this.getScope();
                    }

                    @Override
                    public String getScopeRetrievalKey() {
                        return ExistingCBSDOConfigureDialog.this.getKey();
                    }
                };
                UpdateMethodCommand cmd = new UpdateMethodCommand();
                cmd.setIdentifier(method.getElementName());
                cmd.setJavadoc(javadoc);
                cmd.setModifier("public");
                cmd.setParameterNames(method.getParameterNames());
                cmd.setParameters(method.getParameterTypes());
                cmd.setReturnType(this.getSDOType());
                cmd.setContents(new SDODataGetterBodyTemplate().generate(it));
                IDOMNode xmlnode = node.getDOMNode();
                IDOMDocument xmldoc = xmlnode instanceof IDOMDocument ? (IDOMDocument)xmlnode : (IDOMDocument)xmlnode.getOwnerDocument();
                JavaModel cbModel = CBModelUtil.getCBModel((IDOMDocument)xmldoc);
                cbModel.runBlockingUIJavaTaskWithBusyIndicatorContext((AbstractJavaModelTask)new ExecuteSingleJavaCommandTask((JavaCommand)cmd));
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.getNodeToConfigure().getSDODataFactory().setSubPath(path);
        this.getNodeToConfigure().getSDODataFactory().setMetadataFileName(metadataFile);
        try {
            this.getNodeToConfigure().setMetaDataModel(null);
            this.getNodeToConfigure().changedMetaDataModel();
        }
        catch (MediatorException e1) {
            e1.printStackTrace();
        }
    }

    protected void updateAttributeInJavaDocElement(JavaDocElement element, String attribute, String newValue) {
        String comment = element.getTagComment();
        int idx = comment.indexOf(attribute);
        if (idx >= 0) {
            int idx2 = comment.indexOf(",", idx + attribute.length());
            if (idx2 >= 0) {
                String seg1 = comment.substring(0, idx + attribute.length());
                String seg2 = comment.substring(idx2);
                StringBuffer buffer = new StringBuffer(seg1);
                buffer.append(newValue);
                buffer.append(seg2);
                element.setTagComment(buffer.toString());
            } else {
                String seg1 = comment.substring(0, idx + attribute.length());
                StringBuffer buffer = new StringBuffer(seg1);
                buffer.append(newValue);
                element.setTagComment(buffer.toString());
            }
        }
    }

    String getSDOType() {
        if (this.getNodeToConfigure().getDataType() == 1) {
            return "DataObject";
        }
        return "List";
    }

    protected Control createDialogArea(Composite parent) {
        Control ret = super.createDialogArea(parent);
        WDOCBPageDataNode node = (WDOCBPageDataNode)this.getNodeToConfigure();
        IMethod method = node.getCodeBehindMethod();
        try {
            JavaDocInfo javadoc = CBModelUtil.readJavaDoc((IMethod)method);
            String path = SDOCBModelUtil.readSDOMetadataFilePath(javadoc);
            if (path != null) {
                this.metadataFileText.setText(path);
            }
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        return ret;
    }
}

