/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.wdo;

import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.DeleteFieldCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteImportConditionallyCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class CBSDOContainerActionDelegateDeleteTask
extends AbstractJavaModelTask {
    private static final String[] imports = new String[]{"com.ibm.websphere.sdo.access.connections.ConnectionManager", "com.ibm.websphere.wdo.access.connections.ConnectionManager", "com.ibm.websphere.sdo.mediator.jdbc.ConnectionWrapperFactory", "com.ibm.websphere.wdo.mediator.rdb.ConnectionWrapperFactoryImpl", "com.ibm.websphere.sdo.mediator.exception.MediatorException", "com.ibm.ws.sdo.mediator.jdbc.JDBCMediatorFactoryImpl", "com.ibm.websphere.sdo.mediator.jdbc.JDBCMediatorFactory", "commonj.sdo.DataObject", "java.sql.Connection", "com.ibm.websphere.wdo.mediator.rdb.ConnectionWrapper", "com.ibm.websphere.sdo.mediator.jdbc.ConnectionWrapper", "com.ibm.websphere.sdo.jdbc.internal.JDBCMediatorAccessBeanImpl", "com.ibm.websphere.sdo.DataGraphAccessBean", "com.ibm.websphere.sdo.DataObjectAccessBean", "com.ibm.websphere.sdo.DataListAccessBean"};
    private String getConnectionWrapperName;
    private String SDOConnectionFieldName;
    private String SDOConnectionWrapperName;
    IMethod method;
    IFile file;
    IPageDataNode node;

    CBSDOContainerActionDelegateDeleteTask(IMethod method, IPageDataNode node, IFile file) {
        this.method = method;
        this.file = file;
        this.node = node;
    }

    public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        monitor.beginTask("", 15);
        String methodName = this.method.getElementName();
        String propName = JavaTypeUtil.getPropertyName((String)this.method.getElementName());
        propName = JavaTypeUtil.decapitalizePropertyName((String)propName);
        this.getConnectionWrapperNames(JavaCodeUtil.capitalizeFirst((String)propName), model, monitor);
        DeleteMethodCommand delMethodCmd = new DeleteMethodCommand();
        delMethodCmd.setIdentifier(methodName);
        delMethodCmd.execute(model, monitor);
        monitor.worked(1);
        DeleteFieldCommand deleteFieldCmd = new DeleteFieldCommand();
        deleteFieldCmd.setIdentifier(propName);
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        delMethodCmd.setIdentifier("get" + JavaCodeUtil.capitalizeFirst((String)propName) + "Mediator");
        delMethodCmd.execute(model, monitor);
        monitor.worked(1);
        delMethodCmd.setIdentifier("get" + JavaCodeUtil.capitalizeFirst((String)propName) + "Parameters");
        delMethodCmd.execute(model, monitor);
        monitor.worked(1);
        deleteFieldCmd.setIdentifier(String.valueOf(propName) + "Mediator");
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        deleteFieldCmd.setIdentifier(String.valueOf(propName) + "_metadataFileName");
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        deleteFieldCmd.setIdentifier(String.valueOf(propName) + "ArgNames");
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        deleteFieldCmd.setIdentifier(String.valueOf(propName) + "ArgValues");
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        deleteFieldCmd.setIdentifier(String.valueOf(propName) + "Parameters");
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        deleteFieldCmd.setIdentifier(String.valueOf(propName) + "TargetPageSize");
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        deleteFieldCmd.setIdentifier(String.valueOf(propName) + "_connectionName");
        deleteFieldCmd.execute(model, monitor);
        monitor.worked(1);
        delMethodCmd.setIdentifier("do" + JavaTypeUtil.getMethodNameSuffix((String)propName) + "UpdateAction");
        delMethodCmd.execute(model, monitor);
        monitor.worked(1);
        delMethodCmd.setIdentifier("do" + JavaTypeUtil.getMethodNameSuffix((String)propName) + "CreateAction");
        delMethodCmd.execute(model, monitor);
        monitor.worked(1);
        delMethodCmd.setIdentifier("do" + JavaTypeUtil.getMethodNameSuffix((String)propName) + "DeleteAction");
        delMethodCmd.execute(model, monitor);
        monitor.worked(1);
        delMethodCmd.setIdentifier("do" + JavaTypeUtil.getMethodNameSuffix((String)propName) + "FetchAction");
        delMethodCmd.execute(model, monitor);
        monitor.worked(1);
        this.deleteConnectionWrapper(propName, model, monitor);
        CBSDOContainerActionDelegateDeleteTask.deleteImportStatements(model, monitor);
        if (this.node.getPageDataModel() instanceof PageDataModel) {
            ((PageDataModel)this.node.getPageDataModel()).getIDOMModel().setDirtyState(true);
        }
        monitor.done();
    }

    private static void deleteImportStatements(JavaModel model, IProgressMonitor monitor) {
        DeleteImportConditionallyCommand deleteImport = new DeleteImportConditionallyCommand();
        int i = 0;
        while (i < imports.length) {
            deleteImport.setTypeSignature(Signature.createTypeSignature((String)imports[i], (boolean)false));
            try {
                deleteImport.execute(model, monitor);
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
    }

    public static boolean doesFieldHaveReferences(String methodName, JavaModel model, IProgressMonitor monitor) {
        IType type = model.getType();
        if (type != null) {
            ICompilationUnit unit = type.getCompilationUnit();
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{type});
            SearchEngine searcher = new SearchEngine(new ICompilationUnit[]{unit});
            SearchPattern pattern = SearchPattern.createPattern((String)methodName, (int)4, (int)2, (int)0);
            JavaCodeUtil.JavaModelSearchRequestor requester = new JavaCodeUtil.JavaModelSearchRequestor();
            try {
                searcher.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requester, monitor);
            }
            catch (CoreException coreException) {}
            if (requester.getMatches().size() > 0) {
                return true;
            }
        }
        return false;
    }

    private void deleteConnectionWrapper(String dataname, JavaModel model, IProgressMonitor monitor) {
        try {
            boolean hasSDOConnectionWrapperReferences;
            DeleteFieldCommand deleteFieldCmd;
            boolean hasSDOConnectionFileReferences;
            boolean hasReferences;
            if (this.getConnectionWrapperName != null && !(hasReferences = JavaCodeUtil.doesMethodHaveReferences((String)this.getConnectionWrapperName, (JavaModel)model, (IProgressMonitor)monitor))) {
                DeleteMethodCommand delMethodCmd = new DeleteMethodCommand();
                delMethodCmd.setIdentifier(this.getConnectionWrapperName);
                delMethodCmd.execute(model, monitor);
                monitor.worked(1);
            }
            if (this.SDOConnectionFieldName != null && !(hasSDOConnectionFileReferences = CBSDOContainerActionDelegateDeleteTask.doesFieldHaveReferences(this.SDOConnectionFieldName, model, monitor))) {
                deleteFieldCmd = new DeleteFieldCommand();
                deleteFieldCmd.setIdentifier(this.SDOConnectionFieldName);
                deleteFieldCmd.execute(model, monitor);
                monitor.worked(1);
            }
            if (this.SDOConnectionWrapperName != null && !(hasSDOConnectionWrapperReferences = CBSDOContainerActionDelegateDeleteTask.doesFieldHaveReferences(this.SDOConnectionWrapperName, model, monitor))) {
                deleteFieldCmd = new DeleteFieldCommand();
                deleteFieldCmd.setIdentifier(this.SDOConnectionWrapperName);
                deleteFieldCmd.execute(model, monitor);
                monitor.worked(1);
            }
        }
        catch (Exception exception) {}
    }

    private void getConnectionWrapperNames(String dataname, JavaModel model, IProgressMonitor monitor) {
        String mediatorFieldName = String.valueOf(dataname) + "Mediator";
        String getterName = "get" + JavaTypeUtil.getMethodNameSuffix((String)mediatorFieldName);
        ReadMethodCommand cmd = new ReadMethodCommand();
        String contents = null;
        try {
            cmd.setIdentifier(getterName);
            cmd.execute(model, monitor);
            contents = cmd.getContents();
        }
        catch (JavaModelException e2) {
            e2.printStackTrace();
        }
        if (contents != null) {
            try {
                int endIndex;
                int index = contents.indexOf("getSDOConnection");
                if (index != -1 && (endIndex = contents.indexOf(40, index)) != -1) {
                    this.getConnectionWrapperName = contents.substring(index, endIndex).trim();
                    this.SDOConnectionWrapperName = this.getConnectionWrapperName.substring("get".length(), this.getConnectionWrapperName.length());
                    this.SDOConnectionFieldName = this.getConnectionWrapperName.substring("get".length(), this.getConnectionWrapperName.length() - "Wrapper".length());
                    this.SDOConnectionFieldName = String.valueOf(this.SDOConnectionFieldName) + "_name";
                }
            }
            catch (Exception exception) {}
        }
    }
}

