/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.validators;

import com.ibm.websphere.sdo.mediator.jdbc.exception.InvalidMetadataException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.sdo.mediator.jdbc.JDBCMediatorResourceImpl;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.impl.MetadataValidatorImpl;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class JDBCMetadataFileValidator
implements IValidatorJob {
    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        if (helper == null) {
            return OK_STATUS;
        }
        if (reporter != null && reporter.isCancelled()) {
            return OK_STATUS;
        }
        String[] fileUris = helper.getURIs();
        if (fileUris == null || fileUris.length == 0) {
            IProject project;
            if (helper instanceof IWorkbenchContext && (project = ((IWorkbenchContext)helper).getProject()) != null) {
                this.validateFull(helper, reporter);
            }
        } else {
            int i = 0;
            while (i < fileUris.length && !reporter.isCancelled()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileUris[i]));
                this.validateFile(reporter, file);
                ++i;
            }
        }
        return OK_STATUS;
    }

    private void validateFull(IValidationContext helper, IReporter reporter) {
        IProject project;
        if (helper instanceof IWorkbenchContext && (project = ((IWorkbenchContext)helper).getProject()) != null) {
            this.validateContainer(reporter, (IContainer)project);
        }
    }

    private void validateContainer(IReporter reporter, IContainer container) {
        try {
            IResource[] resourceArray = container.members(false);
            int i = 0;
            while (i < resourceArray.length) {
                IResource resource = resourceArray[i];
                if (resource != null) {
                    if (resource instanceof IFile && resource.getName().endsWith(".xml")) {
                        this.validateFile(reporter, (IFile)resource);
                    } else if (resource instanceof IContainer) {
                        this.validateContainer(reporter, (IContainer)resource);
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateFile(IReporter reporter, IFile file) {
        if (file.getProjectRelativePath().toString().indexOf("wdo") == -1) {
            return;
        }
        reporter.removeAllMessages((IValidator)this, (Object)file);
        try {
            URI uri = URI.createFileURI((String)file.getLocation().toString());
            JDBCMediatorResourceImpl xmlResource = new JDBCMediatorResourceImpl();
            xmlResource.setURI(uri);
            try {
                xmlResource.load(xmlResource.getDefaultLoadOptions());
            }
            catch (IOException iOException) {
                return;
            }
            Object metadata = null;
            if (!xmlResource.getContents().isEmpty()) {
                metadata = xmlResource.getContents().get(0);
            }
            MetadataValidatorImpl val = new MetadataValidatorImpl((Metadata)metadata);
            try {
                val.validate();
                List errors = val.getValidationErrors();
                int i = 0;
                while (i < errors.size()) {
                    LocalizedMessage message = new LocalizedMessage(2, (String)errors.get(i), (IResource)file);
                    reporter.addMessage((IValidator)this, (IMessage)message);
                    ++i;
                }
            }
            catch (InvalidMetadataException e) {
                LocalizedMessage message = new LocalizedMessage(2, e.getLocalizedMessage(), (IResource)file);
                reporter.addMessage((IValidator)this, (IMessage)message);
            }
        }
        catch (Exception exception) {}
    }
}

