/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.vct;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IDataListTagData;
import com.ibm.etools.sdo.jdbc.ui.internal.nls.ResourceHandler;
import com.ibm.etools.sdo.jdbc.ui.internal.util.DialogUtil;
import com.ibm.etools.sdo.ui.internal.consts.SDOConstants;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.vct.PropertiesPage;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.vct.RelationalFolder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DataListPropertiesPage
extends PropertiesPage
implements Listener {
    private static final String USE_DATA_LIST = ResourceHandler.DataListPropertiesPage_Properties_1;
    private Button fUsePaginationButton;
    private Text fTargetPageSizeText;
    private static final int DEFAULT_PAGE_SIZE = 5;
    private static final String PAGINATION_LABEL = ResourceHandler.DataListPropertiesPage_Paginate_results__2;
    private static final String PAGE_SIZE_LABEL = ResourceHandler.DataListPropertiesPage_Target_page_size__3;
    private Label fPageSizeLabel;

    public DataListPropertiesPage() {
        this.setTitle(USE_DATA_LIST);
    }

    public DataListPropertiesPage(String title) {
        super(title);
    }

    public DataListPropertiesPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public IDataListTagData getDataListTagData() {
        return (IDataListTagData)((RelationalFolder)this.fAttributeViewFolder).getRelationalWebTagData();
    }

    @Override
    public void handleEvent(Event event) {
        super.handleEvent(event);
        Widget w = event.widget;
        if (w == this.fUsePaginationButton) {
            this.fTargetPageSizeText.setEnabled(this.fUsePaginationButton.getSelection());
            this.fPageSizeLabel.setEnabled(this.fUsePaginationButton.getSelection());
            this.getDataListTagData().setPagination(this.fUsePaginationButton.getSelection());
        } else if (w == this.fTargetPageSizeText) {
            try {
                int myInt = 0;
                if (this.fTargetPageSizeText.getText() != null && !this.fTargetPageSizeText.getText().trim().equals("")) {
                    myInt = Integer.parseInt(this.fTargetPageSizeText.getText());
                }
                this.getDataListTagData().setTargetPageSize(myInt);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void updateCustomAttributeView() {
        super.updateCustomAttributeView();
        if (this.fTargetPageSizeText != null && !this.fTargetPageSizeText.isDisposed()) {
            this.fTargetPageSizeText.setText("" + this.getDataListTagData().getTargetPageSize());
        }
        if (this.fUsePaginationButton != null && !this.fUsePaginationButton.isDisposed()) {
            this.fUsePaginationButton.setSelection(this.getDataListTagData().isPagination());
            this.fTargetPageSizeText.setEnabled(this.getDataListTagData().isPagination());
            this.fPageSizeLabel.setEnabled(this.getDataListTagData().isPagination());
        }
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        Composite base = (Composite)this.getControl();
        Composite paginationComposite = DialogUtil.createComposite((Composite)base, (int)3);
        ((GridLayout)paginationComposite.getLayout()).marginWidth = 0;
        ((GridLayout)paginationComposite.getLayout()).marginHeight = 0;
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        paginationComposite.setLayoutData((Object)data);
        this.fUsePaginationButton = DialogUtil.createCheckBox((Composite)paginationComposite, (String)PAGINATION_LABEL);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fUsePaginationButton.setLayoutData((Object)data);
        this.fUsePaginationButton.addListener(13, (Listener)this);
        this.fPageSizeLabel = DialogUtil.createLabel((Composite)paginationComposite, (String)PAGE_SIZE_LABEL);
        data = new GridData();
        data.horizontalIndent = 10;
        this.fPageSizeLabel.setLayoutData((Object)data);
        this.fPageSizeLabel.setEnabled(false);
        this.fTargetPageSizeText = DialogUtil.createTextField((Composite)paginationComposite);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.fTargetPageSizeText.setLayoutData((Object)data);
        this.fTargetPageSizeText.setEnabled(false);
        this.fTargetPageSizeText.setText("5");
        this.fTargetPageSizeText.addListener(24, (Listener)this);
    }

    @Override
    protected void setActionStrings() {
        this.actionStrings = new String[]{SDOConstants.DATA_LIST_FILL_ACTION_STRING, SDOConstants.DATA_LIST_CREATE_ACTION_STRING, SDOConstants.DATA_LIST_NO_ACTION_STRING};
    }
}

