/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui;

import com.ibm.etools.sdo.jdbc.ui.provisional.datahandlers.SDORelationalDataFactory;
import com.ibm.etools.webtools.sdo.ui.internal.plugin.SDOWebPlugin;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class JDBCMediatorMetadataViewerFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean ret = false;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            ret = this.isJDBCMediatorMetadata(file);
        } else if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            try {
                IResource[] resources = container.members();
                int i = 0;
                while (i < resources.length) {
                    ret = this.select(viewer, parentElement, resources[i]);
                    if (!ret) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {}
        } else {
            ret = true;
        }
        return ret;
    }

    private boolean isJDBCMediatorMetadata(IFile file) {
        boolean ret = false;
        if (file.getFileExtension().endsWith("xml")) {
            String WDO_FILE_KEY = String.valueOf(SDOWebPlugin.getPluginID()) + "WDO_FILE";
            String OTHER_FILE_KEY = String.valueOf(SDOWebPlugin.getPluginID()) + "OTHER_FILE";
            QualifiedName wdoQName = new QualifiedName(WDO_FILE_KEY, WDO_FILE_KEY);
            QualifiedName otherQName = new QualifiedName(OTHER_FILE_KEY, OTHER_FILE_KEY);
            try {
                if (file.getPersistentProperty(wdoQName) != null && file.getPersistentProperty(wdoQName).equals(Long.toString(file.getModificationStamp()))) {
                    ret = true;
                    return ret;
                }
                if (file.getPersistentProperty(otherQName) != null && file.getPersistentProperty(otherQName).equals(Long.toString(file.getModificationStamp()))) {
                    ret = false;
                    return ret;
                }
            }
            catch (CoreException coreException) {}
            ret = this.loadMetadata(ret, file, wdoQName);
            if (!ret) {
                try {
                    file.setPersistentProperty(otherQName, Long.toString(file.getModificationStamp()));
                }
                catch (CoreException e2) {
                    e2.printStackTrace();
                }
            }
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    private boolean loadMetadata(boolean ret, IFile file, QualifiedName wdoQName) {
        block20: {
            InputStreamReader reader;
            block19: {
                reader = null;
                reader = new InputStreamReader(file.getContents());
                char[] buf = new char[200];
                int length = reader.read(buf);
                String s = new String(buf, 0, length);
                if (s.indexOf("<com.ibm.websphere") != -1) break block19;
                boolean bl = ret;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return bl;
                catch (Throwable throwable) {
                    try {}
                    catch (Throwable throwable2) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException) {}
                    break block20;
                }
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        SDORelationalDataFactory toolsFactory = new SDORelationalDataFactory();
        toolsFactory.setMetadataFileName(file.getProjectRelativePath().toString());
        toolsFactory.setProject(file.getProject());
        try {
            Metadata retMetaData = (Metadata)toolsFactory.getMetaDataModel();
            if (retMetaData.getRootTable().getPrimaryKey() != null) {
                ret = true;
                file.setPersistentProperty(wdoQName, Long.toString(file.getModificationStamp()));
            }
        }
        catch (Throwable throwable) {}
        return ret;
    }
}

