/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IRelationalTagData;
import com.ibm.etools.webtools.customtag.support.common.CustomTagSupportPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedataview.ui.SelectPageDataDialog;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.FilterArgument;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeanValueCellEditor
extends DialogCellEditor {
    private Text text;
    private Button result;
    private IPageDataModel model = null;
    private Composite parent = null;
    private String fELValuePrefix;
    private final TableViewer filterValuesViewer;
    private FilterArgument filterArgument;
    private final IRelationalTagData relationalTagData;

    public BeanValueCellEditor(Composite parent, IPageDataModel model, TableViewer filterValuesViewer, IRelationalTagData relationalTagData) {
        super(parent);
        this.parent = parent;
        this.model = model;
        this.filterValuesViewer = filterValuesViewer;
        this.relationalTagData = relationalTagData;
    }

    protected Button createButton(Composite parent) {
        this.result = new Button(parent, 0x800400);
        this.result.setText("...");
        Image img = CustomTagSupportPlugin.getDefault().getImage("obj16/compute");
        this.result.setImage(img);
        this.result.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BeanValueCellEditor.this.handleCancelEditor();
                    e.doit = false;
                }
                if (e.detail == 16) {
                    Event event = new Event();
                    event.detail = e.detail;
                    BeanValueCellEditor.this.getControl().notifyListeners(31, event);
                    e.doit = false;
                }
                if (e.detail == 8) {
                    BeanValueCellEditor.this.text.setFocus();
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BeanValueCellEditor.this.handleFocusLost(e);
            }

            public void focusGained(FocusEvent e) {
                if (!SWT.getPlatform().equalsIgnoreCase("win32")) {
                    BeanValueCellEditor.this.handleFocusGained(e);
                }
            }
        });
        return this.result;
    }

    protected Control createContents(Composite cell) {
        this.text = new Text(cell, 4);
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BeanValueCellEditor.this.handleCancelEditor();
                    e.doit = false;
                }
                if (e.detail == 4) {
                    BeanValueCellEditor.this.handleApplyEditorValue();
                    e.doit = false;
                }
                if (e.detail == 16) {
                    BeanValueCellEditor.this.result.setFocus();
                    e.doit = false;
                }
                if (e.detail == 8) {
                    Event event = new Event();
                    event.detail = e.detail;
                    BeanValueCellEditor.this.getControl().notifyListeners(31, event);
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BeanValueCellEditor.this.handleFocusLost(e);
            }

            public void focusGained(FocusEvent e) {
                if (!SWT.getPlatform().equalsIgnoreCase("win32")) {
                    BeanValueCellEditor.this.handleFocusGained(e);
                }
            }
        });
        return this.text;
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
        }
    }

    private void handleApplyEditorValue() {
        this.fireApplyEditorValue();
    }

    private void handleCancelEditor() {
        this.fireCancelEditor();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Object ret = this.getValue();
        if (this.openBeanPropertyDialog()) {
            this.fireApplyEditorValue();
            ret = this.getValue();
        }
        return ret;
    }

    protected void updateContents(Object value) {
        if (this.text != null) {
            if (value != null) {
                this.text.setText(value.toString());
            } else {
                this.text.setText("");
            }
        }
    }

    private String getELValuePrefix() {
        return this.fELValuePrefix;
    }

    boolean openBeanPropertyDialog() {
        String modelreference;
        SelectPageDataDialog dialog = new SelectPageDataDialog(this.parent.getShell(), this.model);
        dialog.setELValuePrefix(this.getELValuePrefix());
        if (dialog.open() == 0 && (modelreference = dialog.getReferenceString()) != null && modelreference.length() > 0) {
            this.text.setText(modelreference);
            if (this.filterArgument != null) {
                this.relationalTagData.setFilterValue(this.filterArgument, modelreference);
            }
            this.filterValuesViewer.refresh();
        }
        return true;
    }

    public void setModel(IPageDataModel model) {
        this.model = model;
    }

    public void setELValuePrefix(String elValuePrefix) {
        this.fELValuePrefix = elValuePrefix;
    }

    private void handleFocusLost(FocusEvent e) {
        if (e.widget == this.text && this.result.isFocusControl() || e.widget == this.result) {
            return;
        }
        this.focusLost();
    }

    private void handleFocusGained(FocusEvent e) {
        Widget cfr_ignored_0 = e.widget;
    }

    public void setFilterArgument(FilterArgument element) {
        this.filterArgument = element;
    }
}

