/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.operations;

import com.ibm.etools.sdo.jdbc.ui.internal.data.IDataListTagData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetDescription;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters.RelationalWdoNodeAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.DataListWebTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.PDDataListTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.operations.DataListOperation;
import com.ibm.etools.webtools.sdo.ui.internal.codegen.WDOCodeGenOperation;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebData;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebDataListData;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Element;

public class PDDataListOperation
extends DataListOperation {
    private DataListWebTagData fDataListTagData;
    private ISDOPageDataNode fWDOPageDataNode;

    public PDDataListOperation(ISDOPageDataNode topLevelWdoNode, ICodeGenModel model, DropTargetDescription target, HTMLEditDomain editDomain) {
        super(editDomain);
        this.fWDOPageDataNode = topLevelWdoNode;
        this.fSDOData = this.createSDOData(topLevelWdoNode, model);
    }

    @Override
    protected void doExecutions(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.worked(1);
        this.generateCode((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        monitor.done();
    }

    @Override
    protected void generateCode(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            WDOCodeGenOperation op = new WDOCodeGenOperation(this.getSDOData().getFieldsDataModel());
            op.setInsertionTargetHelper(this.getInsertionTargetHelper());
            try {
                op.run(monitor);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable ce) {
            ce.printStackTrace();
        }
    }

    @Override
    protected int getProcessCount() {
        return 2;
    }

    @Override
    public IDataListTagData getDataListTagData() {
        if (this.fDataListTagData == null) {
            this.fDataListTagData = new PDDataListTagData(this.getSDOData());
            this.fDataListTagData.updateTagRegionData(new RelationalWdoNodeAdapter((Element)this.fWDOPageDataNode.getDOMNode()));
        }
        return this.fDataListTagData;
    }

    private SDOWebData createSDOData(ISDOPageDataNode topLevelWdoNode, final ICodeGenModel model) {
        SDOWebDataListData ret = new SDOWebDataListData(){

            public ICodeGenModel getFieldsDataModel() {
                return model;
            }
        };
        ret.setId(topLevelWdoNode.getName());
        ret.setGenerateDefaultUI(true);
        ret.setDestinationFolder(topLevelWdoNode.getPageDataModel().getResource().getParent());
        return ret;
    }
}

