/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.operations;

import com.ibm.etools.sdo.jdbc.ui.internal.consts.IRdbTagConstants;
import com.ibm.etools.sdo.ui.internal.consts.SDOConstants;
import com.ibm.etools.sdo.ui.internal.data.ITagRegionData;
import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataView;
import com.ibm.etools.webtools.sdo.ui.internal.actions.HeadElementFilter;
import com.ibm.etools.webtools.sdo.ui.internal.actions.InsertionTargetHelper;
import com.ibm.etools.webtools.sdo.ui.internal.codegen.WDOCodeGenOperation;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebData;
import com.ibm.etools.webtools.sdo.ui.internal.util.SourceEditorUtil;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.FilterArgument;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;

public abstract class AbstractSDODataOperation
implements IRunnableWithProgress,
SDOConstants,
IRdbTagConstants {
    private InsertionTargetHelper fInsertionTargetHelper;
    protected HTMLEditDomain fHTMLEditDomain;

    public AbstractSDODataOperation(HTMLEditDomain editDomain) {
        this.fHTMLEditDomain = editDomain;
    }

    protected abstract void importResources(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    protected abstract void doExecutions(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    protected abstract String getDataType();

    protected void addSpecificPropertiesToList(List attributeNames, List attributeValues) {
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.execute(monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    protected HeadElementFilter createFactory(String tagName, String[] attributeNames, String[] attributeValues) {
        return this.createFactory(tagName, attributeNames, attributeValues, false);
    }

    protected HeadElementFilter createFactory(String tagName, String[] attributeNames, String[] attributeValues, boolean isComment) {
        HeadElementFilter factory = new HeadElementFilter(tagName);
        int i = 0;
        while (i < attributeNames.length) {
            factory.pushAttribute(attributeNames[i], attributeValues[i]);
            ++i;
        }
        factory.setInsertionTargetHelper(this.getInsertionTargetHelper());
        return factory;
    }

    protected InsertionTargetHelper getInsertionTargetHelper() {
        if (this.fInsertionTargetHelper == null) {
            this.fInsertionTargetHelper = new InsertionTargetHelper(this.fHTMLEditDomain);
        }
        return this.fInsertionTargetHelper;
    }

    protected void selectNodeInPageDataView(IProgressMonitor monitor) {
        PageDataView.bringToTop((String)this.getSDOData().getId());
    }

    protected void generateCode(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.getSDOData().getFieldsDataModel().addCustomProperty((Object)"mediator", (Object)this.getMediatorID());
            WDOCodeGenOperation op = new WDOCodeGenOperation(this.getSDOData().getFieldsDataModel());
            op.setInsertionTargetHelper(this.getInsertionTargetHelper());
            try {
                op.run(monitor);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable ce) {
            ce.printStackTrace();
        }
    }

    protected void updateMetadataInPageDataNode(String idName, Metadata rdbMetadata) {
        if (rdbMetadata != null) {
            Metadata metaData = null;
            metaData = rdbMetadata;
            ISDOPageDataNode iWDOPageDataNode = SourceEditorUtil.getPageDataNode((String)idName, (HTMLEditDomain)this.fHTMLEditDomain);
            if (iWDOPageDataNode != null) {
                ((SDOPageDataNode)iWDOPageDataNode).setMetaDataModel((Object)metaData);
                try {
                    ((SDOPageDataNode)iWDOPageDataNode).saveMetaDataModel();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    iWDOPageDataNode.changedMetaDataModel();
                }
                catch (MediatorException e1) {
                    e1.printStackTrace();
                }
                ICodeGenNode rootnode = this.getSDOData().getFieldsDataModel().getRoot();
                if (rootnode != null && rootnode.getEnclosedNode() instanceof ISSEPageDataNode) {
                    ((ISSEPageDataNode)rootnode.getEnclosedNode()).setDOMNode(iWDOPageDataNode.getDOMNode());
                }
            }
        }
    }

    protected Shell getShell() {
        return null;
    }

    protected void addFilterParameters(HeadElementFilter headFilter) {
        EList tablesList = this.getTagData().getMetadata().getTables();
        HashSet<String> nameSet = new HashSet<String>();
        for (Table table : tablesList) {
            if (table.getFilter() == null) continue;
            for (FilterArgument filterArg : table.getFilter().getFilterArguments()) {
                String argName = filterArg.getName();
                if (nameSet.contains(argName)) continue;
                String argValue = this.getTagData().getFilterValue(filterArg);
                Element filterParameterElement = this.getHTMLEditDomain().getActiveModel().getDocument().createElement("wdo:setFilterParameter");
                filterParameterElement.setAttribute("id", this.getSDOData().getId());
                filterParameterElement.setAttribute("name", argName);
                filterParameterElement.setAttribute("value", argValue);
                headFilter.addFilterParameterElement(filterParameterElement);
                nameSet.add(argName);
            }
        }
    }

    protected String getMediatorTagName() {
        return "wdo:useMediator";
    }

    protected abstract String getCommentTagName();

    protected void execute(IProgressMonitor monitor) throws OperationCanceledException, InvocationTargetException, InterruptedException {
        monitor.beginTask("Inserting Data", this.getProcessCount());
        this.doExecutions(monitor);
        monitor.done();
    }

    protected int getProcessCount() {
        return 5;
    }

    public HTMLEditDomain getHTMLEditDomain() {
        return this.fHTMLEditDomain;
    }

    public abstract ITagRegionData getTagData();

    public abstract SDOWebData getSDOData();

    protected HeadElementFilter createCommentHeadElementFilter() {
        HeadElementFilter headElementFilter = null;
        ArrayList<String> attributeNames = new ArrayList<String>();
        ArrayList<String> attributeValues = new ArrayList<String>();
        attributeNames.add("id");
        attributeValues.add(this.getSDOData().getId());
        attributeNames.add("mediator");
        attributeValues.add(this.getMediatorID());
        attributeNames.add("input");
        if (this.getTagData().getInputFile() == null) {
            this.getTagData().setInputFile(SourceEditorUtil.getUniqueMetaFileFromName((String)this.getSDOData().getId(), (String)".xml", (HTMLEditDomain)this.fHTMLEditDomain), false);
        }
        attributeValues.add(this.getTagData().getInputFile());
        attributeNames.add("datatype");
        attributeValues.add(this.getDataType());
        if (this.getSDOData().getAction() == 0) {
            attributeNames.add("action");
            attributeValues.add("FILL");
        } else if (this.getSDOData().getAction() == 1) {
            attributeNames.add("action");
            attributeValues.add("CREATE");
        }
        headElementFilter = this.createFactory(this.getCommentTagName(), attributeNames.toArray(new String[attributeNames.size()]), attributeValues.toArray(new String[attributeValues.size()]));
        headElementFilter.setComment(true);
        headElementFilter.setAddToHead(true);
        return headElementFilter;
    }

    protected abstract HeadElementFilter createActionHeadElementFilter();

    protected HeadElementFilter createMediatorHeadElementFilter() {
        HeadElementFilter headElementFilter = null;
        ArrayList<String> attributeNames = new ArrayList<String>();
        ArrayList<String> attributeValues = new ArrayList<String>();
        attributeNames.add("id");
        attributeValues.add(this.getMediatorID());
        attributeNames.add("input");
        if (this.getTagData().getInputFile() == null) {
            this.getTagData().setInputFile(SourceEditorUtil.getUniqueMetaFileFromName((String)this.getSDOData().getId(), (String)".xml"), false);
        }
        attributeValues.add(this.getTagData().getInputFile());
        this.addSpecificPropertiesToList(attributeNames, attributeValues);
        attributeNames.add("datatype");
        attributeValues.add(this.getDataType());
        headElementFilter = this.createFactory(this.getMediatorTagName(), attributeNames.toArray(new String[attributeNames.size()]), attributeValues.toArray(new String[attributeValues.size()]));
        headElementFilter.setComment(false);
        headElementFilter.setAddToHead(true);
        this.addFilterParameters(headElementFilter);
        return headElementFilter;
    }

    public String getMediatorID() {
        return String.valueOf(this.getSDOData().getId()) + "Mediator";
    }
}

