/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.operations;

import com.ibm.etools.sdo.jdbc.ui.internal.Logger;
import com.ibm.etools.sdo.jdbc.ui.internal.nls.ResourceHandler;
import com.ibm.etools.sdo.ui.internal.data.ITagRegionData;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.customtag.jstl.common.JSTLUtil;
import com.ibm.etools.webtools.model.util.ActionUtilProxy;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ValidateEditException;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters.IRelationalWdoNodeAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.IRelationalWebTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.RelationalWebTagData;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.feature.JDBCMediatorFacetUtil;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.operations.AbstractSDODataOperation;
import com.ibm.etools.webtools.sdo.ui.internal.actions.HeadElementFilter;
import com.ibm.etools.webtools.sdo.ui.internal.actions.InsertVctAndTaglibCommand;
import com.ibm.etools.webtools.sdo.ui.internal.data.SDOWebData;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.FilterArgument;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Table;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractRelationalSDODataOperation
extends AbstractSDODataOperation {
    protected SDOWebData fSDOData;

    public AbstractRelationalSDODataOperation(SDOWebData data, HTMLEditDomain editDomain) {
        super(editDomain);
        this.fSDOData = data;
    }

    public AbstractRelationalSDODataOperation(HTMLEditDomain editDomain) {
        super(editDomain);
    }

    public void setSDOData(SDOWebData data) {
        this.fSDOData = data;
    }

    public void setEditDomain(HTMLEditDomain edit) {
        this.fHTMLEditDomain = edit;
    }

    public static String getSDOTaglibURI(IProject project) {
        if (JSTLUtil.getJSTLLevel((IProject)project) == 0) {
            return "http://www.ibm.com/websphere/wdo/core";
        }
        return "http://www.ibm.com/websphere/sdo/core";
    }

    @Override
    protected void importResources(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        JDBCMediatorFacetUtil.installJDBCMediatorFacet(this.getRelationalWebTagData().getSDOData().getProject(), monitor);
    }

    protected InsertVctAndTaglibCommand getCommand() {
        HeadElementFilter actionFactory;
        HeadElementFilter mediatorFactory;
        ArrayList<HeadElementFilter> headElementFactoryList = new ArrayList<HeadElementFilter>();
        HeadElementFilter commentFactory = this.createCommentHeadElementFilter();
        if (commentFactory != null) {
            headElementFactoryList.add(commentFactory);
            commentFactory.setDocument((Document)this.getHTMLEditDomain().getActiveModel().getDocument());
        }
        if ((mediatorFactory = this.createMediatorHeadElementFilter()) != null) {
            headElementFactoryList.add(mediatorFactory);
            mediatorFactory.setDocument((Document)this.getHTMLEditDomain().getActiveModel().getDocument());
        }
        if ((actionFactory = this.createActionHeadElementFilter()) != null) {
            headElementFactoryList.add(actionFactory);
            actionFactory.setDocument((Document)this.getHTMLEditDomain().getActiveModel().getDocument());
        }
        HashMap<String, String> taglibMap = new HashMap<String, String>();
        taglibMap.put("wdo", AbstractRelationalSDODataOperation.getSDOTaglibURI(this.getSDOData().getProject()));
        InsertVctAndTaglibCommand cmd = new InsertVctAndTaglibCommand("Compound Command", this.getHTMLEditDomain(), taglibMap, null, headElementFactoryList.toArray(new CustomTagFactory[headElementFactoryList.size()]));
        return cmd;
    }

    @Override
    protected void addSpecificPropertiesToList(List attributeNames, List attributeValues) {
        attributeNames.add("connection");
        attributeValues.add(this.getRelationalWebTagData().getConnectionData().getConnectionId());
    }

    @Override
    protected String getDataType() {
        return "RDB";
    }

    @Override
    protected void addFilterParameters(HeadElementFilter headFilter) {
        EList tablesList = this.getTagData().getMetadata().getTables();
        HashSet<String> nameSet = new HashSet<String>();
        for (Table table : tablesList) {
            if (table.getFilter() == null) continue;
            for (FilterArgument filterArg : table.getFilter().getFilterArguments()) {
                String argName = filterArg.getName();
                if (nameSet.contains(argName)) continue;
                String argValue = this.getRelationalWebTagData().getFilterValue(filterArg);
                Element filterParameterElement = this.getHTMLEditDomain().getActiveModel().getDocument().createElement("wdo:setFilterParameter");
                filterParameterElement.setAttribute("id", this.getMediatorID());
                filterParameterElement.setAttribute("name", argName);
                filterParameterElement.setAttribute("value", argValue);
                headFilter.addFilterParameterElement(filterParameterElement);
                nameSet.add(argName);
            }
        }
    }

    @Override
    public SDOWebData getSDOData() {
        return this.fSDOData;
    }

    public IRelationalWebTagData getRelationalWebTagData() {
        return (IRelationalWebTagData)this.getTagData();
    }

    @Override
    public ITagRegionData getTagData() {
        return (ITagRegionData)this.getSDOData().getCurrentCodeGenModel().getRegion_data_contrib();
    }

    protected void updateExistingData(IProgressMonitor monitor) {
    }

    @Override
    protected void doExecutions(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.getSDOData().isConfigureExistingData()) {
            ISDOPageDataNode iWDOPageDataNode;
            this.updateExistingData(monitor);
            IRelationalWdoNodeAdapter adapter = ((RelationalWebTagData)this.getSDOData().getTagData()).getWDONodeAdapter();
            if (adapter != null && (iWDOPageDataNode = adapter.getSDOPageDataNode()) != null) {
                try {
                    ((SDOPageDataNode)iWDOPageDataNode).setMetaDataModel((Object)this.getTagData().getMetadata());
                    iWDOPageDataNode.changedMetaDataModel();
                    try {
                        iWDOPageDataNode.saveMetaDataModel();
                    }
                    catch (ValidateEditException e) {
                        IStatus validateEditStatus = e.getValidateEditStatus();
                        if (validateEditStatus.getSeverity() != 8) {
                            final String errorMessage = String.valueOf(ResourceHandler.Failed_Validate_Edit) + " - " + iWDOPageDataNode.getFilename() + ": " + validateEditStatus.getMessage();
                            Shell shell = null;
                            Display d = Display.getCurrent();
                            if (d != null) {
                                shell = d.getActiveShell();
                            }
                            if (shell != null) {
                                final Shell nestedShell = shell;
                                shell.getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.openError((Shell)nestedShell, (String)ResourceHandler.SDOJDBCMediatorWizard_4, (String)errorMessage);
                                    }
                                });
                            } else {
                                Logger.logException((String)errorMessage, (Throwable)validateEditStatus.getException());
                            }
                        }
                        ((SDOPageDataNode)iWDOPageDataNode).setMetaDataModel(null);
                        iWDOPageDataNode.changedMetaDataModel();
                        iWDOPageDataNode.getSDODataFactory().setMetaDataModel(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        this.importResources((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        this.insertTag((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        if (this.getSDOData().isGenerateDefaultUI()) {
            this.generateCode((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.worked(1);
        this.selectNodeInPageDataView((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        monitor.done();
    }

    protected void insertTag(IProgressMonitor monitor) {
        InsertVctAndTaglibCommand cmd = this.getCommand();
        cmd.setCommandTarget((HTMLCommandTarget)ActionUtilProxy.getActiveHTMLEditDomain());
        this.fHTMLEditDomain.execCommand((Command)cmd);
        this.updateMetadataInPageDataNode(this.getSDOData().getId(), this.getTagData().getMetadata());
    }
}

