/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.feature;

import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.j2ee.web.WebSettings;
import com.ibm.etools.sdo.jdbc.ui.internal.nls.ResourceHandler;
import com.ibm.etools.sdo.jdbc.ui.internal.propertypages.JDBCConnectionsPropertyPage;
import com.ibm.etools.sdo.runtime.internal.SDOClasspathUtil;
import com.ibm.etools.webtools.customtag.lib.TaglibFeaturePlugin;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.feature.JDBCMediatorFacetConstants;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.plugin.JDBCMediatorUIPlugin;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.ui.SDOonPortalMessageDialog;
import com.ibm.etools.webtools.sdo.ui.internal.feature.SDODataFeatureOperation;
import com.ibm.etools.webtools.webproject.features.taglibs.internal.util.ClasspathUtil;
import com.ibm.etools.webtools.webproject.features.taglibs.internal.util.RuntimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class RelationalDataFeatureOperation
extends SDODataFeatureOperation {
    boolean canceled = false;

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.isAdd()) {
            this.addFeatureOperation(monitor);
        } else {
            this.removeFeatureOperation(monitor);
        }
    }

    protected void cleanupOldJars(IProgressMonitor monitor, IPath relativePath) {
        try {
            this.removeWDOWEB(relativePath, false, monitor);
            this.removeRelationalAccess(relativePath, false, monitor);
            this.removeV6ClassPath(monitor, relativePath);
            this.removeV61ClassPath(monitor, relativePath);
            Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
            this.removePortalSDOAccess((IPath)sdoRuntimePath, relativePath, false, monitor);
            this.removePortalSDOWEB((IPath)sdoRuntimePath, relativePath, false, monitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CoreException coreException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    protected void removeFeatureOperation(IProgressMonitor monitor) {
        try {
            try {
                IProject project = this.getSDOFeatureDataModel().getTargetProject();
                if (project != null && MigrationPlugin.getDefault().getPluginPreferences().getBoolean("backward_compatible")) {
                    try {
                        WebSettings webSettings = new WebSettings(project);
                        webSettings.removeFeatureId("RelationalDataFeature");
                        webSettings.write();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                IPath relativePath = this.createRelativePath();
                IRuntime runtime = this.getSDOFeatureDataModel().getServerTarget();
                this.removeV51ClassPath(monitor, relativePath, runtime);
                this.removeV6ClassPath(monitor, relativePath);
                this.removeV61ClassPath(monitor, relativePath);
                this.removeDefaultV6ClassPath(monitor, relativePath);
                this.removePortalWASV51ClassPath(monitor, relativePath);
                this.setProjectClassPathEntries(monitor);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                monitor.done();
            }
            catch (CoreException e) {
                e.printStackTrace();
                monitor.done();
            }
            catch (Throwable e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Loose catch block
     */
    public void addFeatureOperation(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, OperationCanceledException {
        IRuntime runtime;
        IProject project = this.getSDOFeatureDataModel().getTargetProject();
        if (project != null && MigrationPlugin.getDefault().getPluginPreferences().getBoolean("backward_compatible")) {
            try {
                String[] loadedFeatures;
                WebSettings webSettings = new WebSettings(project);
                boolean featureExists = false;
                String[] stringArray = loadedFeatures = webSettings.getFeatureIds();
                int n = loadedFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    if (element.equals("RelationalDataFeature")) {
                        featureExists = true;
                        break;
                    }
                    ++n2;
                }
                if (!featureExists) {
                    String[] newFeatures = new String[]{"RelationalDataFeature"};
                    webSettings.setFeatureIds(newFeatures);
                    webSettings.write();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getSDOFeatureDataModel().getTargetProject() != null) {
            try {
                JDBCConnectionsPropertyPage.addSDOBuilderToBuildSpec(null, (IProject)this.getSDOFeatureDataModel().getTargetProject());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ProjectUtilities.addToBuildSpec((String)"org.eclipse.wst.validation.validationbuilder", (IProject)this.getSDOFeatureDataModel().getTargetProject());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (RuntimeUtil.isTargetedAtPortalV51((IRuntime)(runtime = this.getSDOFeatureDataModel().getServerTarget()))) {
            String MEDIATOR_LABEL = "\"The SDO JDBC Mediator for Portal 5.1\"";
            final String title = ResourceHandler.WDOPortalWarningComposite_ADD_SDO_RUNTIME;
            final String warning = NLS.bind((String)ResourceHandler.WDOPortalWarningComposite_V51x_PORTAL_WARNING, (Object)MEDIATOR_LABEL);
            final String HELP_CONTEXT_ID_SDO_WP51 = String.valueOf(JDBCMediatorUIPlugin.getDefault().getBundle().getSymbolicName()) + ".sdojdbc";
            if (this.fShell == null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean okPressed;
                        SDOonPortalMessageDialog dialog = new SDOonPortalMessageDialog(title, warning, HELP_CONTEXT_ID_SDO_WP51, "/com.ibm.etools.portal.doc/topics/tcfgJDBCmed.html", RelationalDataFeatureOperation.this.getShell());
                        int retVal = dialog.open();
                        boolean bl = okPressed = retVal == 0;
                        if (!okPressed) {
                            RelationalDataFeatureOperation.this.canceled = true;
                        }
                    }
                });
                if (this.canceled) {
                    throw new InterruptedException(ResourceHandler.WDOPortalWarningComposite_ADD_SDO_FEATURE_CANCELED);
                }
            } else {
                boolean okPressed;
                SDOonPortalMessageDialog dialog = new SDOonPortalMessageDialog(title, warning, HELP_CONTEXT_ID_SDO_WP51, "/com.ibm.etools.portal.doc/topics/tcfgJDBCmed.html", this.getShell());
                int retVal = dialog.open();
                boolean bl = okPressed = retVal == 0;
                if (!okPressed) {
                    throw new InterruptedException(ResourceHandler.WDOPortalWarningComposite_ADD_SDO_FEATURE_CANCELED);
                }
            }
        }
        monitor.beginTask(MAIN_TASK_LABEL, 9);
        try {
            try {
                IPath relativePath = this.createRelativePath();
                this.cleanupOldJars(monitor, relativePath);
                if (RuntimeUtil.isTargetedAtWASV60((IRuntime)runtime)) {
                    this.setUpWASV6ClassPath(monitor, relativePath);
                } else if (RuntimeUtil.isTargetedAtWASV61((IRuntime)runtime) || RuntimeUtil.isTargetedAtWASV70((IRuntime)runtime) || RuntimeUtil.isTargetedAtPortalV61((IRuntime)runtime) || RuntimeUtil.isTargetedAtPortalV61OnWAS70((IRuntime)runtime)) {
                    this.setUpWASV61ClassPath(monitor, relativePath);
                } else if (RuntimeUtil.isTargetedAtPortalV51((IRuntime)runtime)) {
                    this.setUpPortalV51ClassPath(monitor, relativePath);
                } else if (RuntimeUtil.isTargetedAtPortalV60((IRuntime)runtime)) {
                    this.setUpWASV6ClassPath(monitor, relativePath);
                } else {
                    this.setUpDefaultV6ClassPath(monitor, relativePath);
                }
                this.setProjectClassPathEntries(monitor);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                monitor.done();
            }
            catch (CoreException e) {
                e.printStackTrace();
                monitor.done();
            }
            catch (Throwable e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void setUpDefaultV6ClassPath(IProgressMonitor monitor, IPath relativePath) throws FileNotFoundException, CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.getSDOFeatureDataModel().getTargetProject());
        if (javaProject != null) {
            IClasspathEntry[] rawEntries = javaProject.getRawClasspath();
            boolean hasEntry = false;
            IClasspathEntry[] iClasspathEntryArray = rawEntries;
            int n = rawEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry element = iClasspathEntryArray[n2];
                if (JDBCMediatorFacetConstants.JDBCMEDIATOR_CLASS_PATH_CONTAINER_PATH.equals((Object)element.getPath())) {
                    hasEntry = true;
                }
                ++n2;
            }
            if (!hasEntry) {
                IClasspathEntry entry = JavaCore.newContainerEntry((IPath)JDBCMediatorFacetConstants.JDBCMEDIATOR_CLASS_PATH_CONTAINER_PATH, (boolean)false);
                IClasspathEntry[] entries = new IClasspathEntry[rawEntries.length + 1];
                System.arraycopy(rawEntries, 0, entries, 0, rawEntries.length);
                entries[rawEntries.length] = entry;
                javaProject.setRawClasspath(entries, monitor);
            }
        }
        Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
        this.createSDOAccess61((IPath)sdoRuntimePath, relativePath, false, monitor);
        this.createSDOWEB61((IPath)sdoRuntimePath, relativePath, false, monitor);
    }

    private void removeDefaultV6ClassPath(IProgressMonitor monitor, IPath relativePath) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.getSDOFeatureDataModel().getTargetProject());
        if (javaProject != null) {
            IClasspathEntry[] rawEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < rawEntries.length) {
                if (JDBCMediatorFacetConstants.JDBCMEDIATOR_CLASS_PATH_CONTAINER_PATH.equals((Object)rawEntries[i].getPath())) {
                    IClasspathEntry[] newentries = new IClasspathEntry[rawEntries.length - 1];
                    System.arraycopy(rawEntries, 0, newentries, 0, i);
                    if (i + 1 < rawEntries.length) {
                        System.arraycopy(rawEntries, i + 1, newentries, i, rawEntries.length - 1 - i);
                    }
                    javaProject.setRawClasspath(newentries, monitor);
                }
                ++i;
            }
        }
    }

    private void setUpWASV6ClassPath(IProgressMonitor monitor, IPath relativePath) throws FileNotFoundException, CoreException {
        Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
        this.createSDOAccess((IPath)sdoRuntimePath, relativePath, false, monitor);
        this.createSDOWEB((IPath)sdoRuntimePath, relativePath, false, monitor);
    }

    private void setUpWASV61ClassPath(IProgressMonitor monitor, IPath relativePath) throws FileNotFoundException, CoreException {
        Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
        this.createSDOAccess61((IPath)sdoRuntimePath, relativePath, false, monitor);
        this.createSDOWEB61((IPath)sdoRuntimePath, relativePath, false, monitor);
    }

    private void setUpPortalV51ClassPath(IProgressMonitor monitor, IPath relativePath) throws FileNotFoundException, CoreException {
        Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
        IPath serverSDORuntimePath = SDOClasspathUtil.getSDOEMFRuntimePath();
        this.createPortalSDOJDBCMediatorRuntime(serverSDORuntimePath, relativePath, true, monitor);
        this.createPortalSDOAccess((IPath)sdoRuntimePath, relativePath, false, monitor);
        this.createPortalSDOWEB((IPath)sdoRuntimePath, relativePath, false, monitor);
    }

    private void removeV6ClassPath(IProgressMonitor monitor, IPath relativePath) throws FileNotFoundException, CoreException {
        Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
        try {
            this.removeSDOAccess((IPath)sdoRuntimePath, relativePath, false, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.removeSDOWEB((IPath)sdoRuntimePath, relativePath, false, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void removeV61ClassPath(IProgressMonitor monitor, IPath relativePath) throws FileNotFoundException, CoreException {
        Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
        try {
            this.removeSDOAccess61((IPath)sdoRuntimePath, relativePath, false, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.removeSDOWEB61((IPath)sdoRuntimePath, relativePath, false, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void removePortalWASV51ClassPath(IProgressMonitor monitor, IPath relativePath) throws FileNotFoundException, CoreException {
        Path sdoRuntimePath = SDOClasspathUtil.getSDORuntimePath();
        try {
            this.removePortalSDOAccess((IPath)sdoRuntimePath, relativePath, false, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.removePortalSDOWEB((IPath)sdoRuntimePath, relativePath, false, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.removePortalSDOJDBCMediatorRuntime((IPath)sdoRuntimePath, relativePath, true, monitor);
    }

    private void removeV51ClassPath(IProgressMonitor monitor, IPath relativePath, IRuntime runtime) throws FileNotFoundException, CoreException {
        IPath wdoRuntimePath = null;
        IPath emfRuntimePath = null;
        this.removeFeatureClassPathEntry("WDO_EMF_JARS_PATH", wdoRuntimePath, new IPath[]{new Path("emf-event.jar")}, true, monitor);
        this.removeFeatureClassPathEntry("WDO_EMF_JARS_PATH", emfRuntimePath, new IPath[]{new Path("emf-runtime.jar")}, true, monitor);
        this.removeFeatureClassPathEntry("WDO_EMF_JARS_PATH", wdoRuntimePath, new IPath[]{new Path("wdo-interface.jar")}, true, monitor);
        this.removeFeatureClassPathEntry("WDO_EMF_JARS_PATH", wdoRuntimePath, new IPath[]{new Path("wdo.jar")}, true, monitor);
        this.removeFeatureClassPathEntry("WDO_EMF_JARS_PATH", wdoRuntimePath, new IPath[]{new Path("jdbcmediator.jar")}, true, monitor);
        this.removeFeatureClassPathEntry("WDO_EMF_JARS_PATH", wdoRuntimePath, new IPath[]{new Path("jdbcmediator.jar")}, true, monitor);
        this.removeFeatureClassPathEntry("WDO_EMF_JARS_PATH", wdoRuntimePath, new IPath[]{new Path("wdo.xmlmediator.jar")}, true, monitor);
        try {
            this.removeWDOWEB(relativePath, false, monitor);
            this.removeRelationalAccess(relativePath, false, monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void createPortalSDOJDBCMediatorRuntime(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            boolean backwardCompatible = MigrationPlugin.getDefault().getPluginPreferences().getBoolean("backward_compatible");
            if (backwardCompatible) {
                this.addFeatureClassPathEntry("SDO_EMF_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("jdbcmediator.jar")}, spm);
            } else {
                this.addFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/jdbcmediatorv51.jar")}, spm);
            }
        } else {
            File currentFile = new File(sdoRuntimePath.append("lib/jdbcmediatorv51.jar").toOSString());
            FileInputStream contentStream = new FileInputStream(currentFile);
            IPath destinationPath = relativePath.append("jdbcmediatorv51.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (!outputFile.exists()) {
                outputFile.create((InputStream)contentStream, true, (IProgressMonitor)spm);
            }
        }
    }

    protected void removePortalSDOJDBCMediatorRuntime(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            this.removeFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/jdbcmediatorv51.jar")}, false, (IProgressMonitor)spm);
            this.removeFeatureClassPathEntry("SDO_EMF_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("jdbcmediator.jar")}, false, (IProgressMonitor)spm);
        } else {
            IPath destinationPath = relativePath.append("jdbcmediatorv51.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (outputFile.exists()) {
                this.deleteFile(outputFile, (IProgressMonitor)spm);
            }
        }
    }

    protected void deleteFile(IFile outputFile, IProgressMonitor myMonitor) {
        ClasspathUtil.deleteFile((IFile)outputFile, (Shell)this.fShell, (IProgressMonitor)myMonitor);
        this.removeJarFromClasspath(outputFile, myMonitor);
    }

    private void createPortalSDOAccess(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            this.addFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/sdo_access_beans_p5.1.0.jar")}, spm);
        } else {
            File currentFile = new File(sdoRuntimePath.append("lib/sdo_access_beans_p5.1.0.jar").toOSString());
            FileInputStream contentStream = new FileInputStream(currentFile);
            IPath destinationPath = relativePath.append("sdo_access_beans_p5.1.0.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (!outputFile.exists()) {
                outputFile.create((InputStream)contentStream, true, (IProgressMonitor)spm);
            }
        }
    }

    private void removePortalSDOAccess(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            this.removeFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/sdo_access_beans_p5.1.0.jar")}, false, (IProgressMonitor)spm);
        } else {
            IPath destinationPath = relativePath.append("sdo_access_beans_p5.1.0.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (outputFile.exists()) {
                this.deleteFile(outputFile, (IProgressMonitor)spm);
            }
        }
    }

    private void createSDOAccess(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            this.addFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/sdo_access_beans.jar")}, spm);
        } else {
            File currentFile = new File(sdoRuntimePath.append("lib/sdo_access_beans.jar").toOSString());
            FileInputStream contentStream = new FileInputStream(currentFile);
            IPath destinationPath = relativePath.append("sdo_access_beans.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (!outputFile.exists()) {
                outputFile.create((InputStream)contentStream, true, (IProgressMonitor)spm);
            }
        }
    }

    private void createSDOAccess61(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            this.addFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/sdo_access_beans_6.1.0.jar")}, spm);
        } else {
            File currentFile = new File(sdoRuntimePath.append("lib/sdo_access_beans_6.1.0.jar").toOSString());
            FileInputStream contentStream = new FileInputStream(currentFile);
            IPath destinationPath = relativePath.append("sdo_access_beans_6.1.0.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (!outputFile.exists()) {
                outputFile.create((InputStream)contentStream, true, (IProgressMonitor)spm);
            }
        }
    }

    private void removeSDOAccess(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            this.removeFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/sdo_access_beans.jar")}, false, (IProgressMonitor)spm);
        } else {
            IPath destinationPath = relativePath.append("sdo_access_beans.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (outputFile.exists()) {
                this.deleteFile(outputFile, (IProgressMonitor)spm);
            }
        }
    }

    private void removeSDOAccess61(IPath sdoRuntimePath, IPath relativePath, boolean isProjectReference, IProgressMonitor myMonitor) throws FileNotFoundException, CoreException {
        SubProgressMonitor spm = new SubProgressMonitor(myMonitor, 1);
        if (isProjectReference) {
            this.removeFeatureClassPathEntry("SDO_JARS_PATH", sdoRuntimePath, new IPath[]{new Path("lib/sdo_access_beans_6.1.0.jar")}, false, (IProgressMonitor)spm);
        } else {
            IPath destinationPath = relativePath.append("sdo_access_beans_6.1.0.jar");
            IFile outputFile = TaglibFeaturePlugin.getWorkspace().getRoot().getFile(destinationPath.makeRelative());
            if (outputFile.exists()) {
                this.deleteFile(outputFile, (IProgressMonitor)spm);
            }
        }
    }

    public String getFeatureID() {
        return RelationalDataFeatureOperation.getWDORelationFeatureID();
    }

    public static String getWDORelationFeatureID() {
        return "RelationalDataFeature";
    }
}

