/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters;

import com.ibm.etools.sdo.jdbc.ui.internal.data.FilterArgumentsManager;
import com.ibm.etools.sdo.jdbc.ui.internal.data.IRelationalTagData;
import com.ibm.etools.sdo.ui.internal.consts.SDOConstants;
import com.ibm.etools.sdo.ui.internal.data.ISDOData;
import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webtools.customtag.support.commands.ChangeAttributeCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeAdapter;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.adapters.IRelationalWdoNodeAdapter;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.FilterArgumentsManagerWeb;
import com.ibm.etools.webtools.sdo.jdbc.ui.internal.data.IRelationalWebTagData;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelationalWdoNodeAdapter
implements IRelationalWdoNodeAdapter,
SDOConstants {
    private String fAction;
    private String fMediator;
    private int fTargetPageSize;
    private FilterArgumentsManager fFilterArgumentsManager;
    private Element fMediatorTag;
    private Element fWDOTag;
    String fId;
    String fDataType;
    String fConnId;
    String fInputFile;
    ISDOPageDataNode fSDOPageDataNode;

    public boolean isAdapterFor(Object key) {
        return ADAPTER_KEY.equals(key);
    }

    @Override
    public void fillModel(ISDOData data) {
        IRelationalTagData tagData = (IRelationalTagData)data.getTagData();
        IRelationalWebTagData webTagData = (IRelationalWebTagData)tagData;
        data.setConfigureExistingData(true);
        data.setExistingFilePath(this.fInputFile);
        try {
            webTagData.updateTagRegionData(this);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public RelationalWdoNodeAdapter(Element wdoTag) {
        this.fWDOTag = wdoTag;
        this.parse(wdoTag, ((IDOMNode)wdoTag).getModel().getDocument());
    }

    private void parse(Element wdoCommentTag, IDOMDocument document) {
        this.fMediatorTag = this.parseMediatorTag(wdoCommentTag, document);
        this.fId = this.fWDOTag.getAttribute("id");
        this.fMediator = this.fMediatorTag.getAttribute("id");
        this.fConnId = this.fMediatorTag.getAttribute("connection");
        this.fInputFile = this.fMediatorTag.getAttribute("input");
        this.fDataType = this.fMediatorTag.getAttribute("datatype");
        if (wdoCommentTag != null) {
            this.fAction = wdoCommentTag.getAttribute("action");
            if (this.fAction == null) {
                this.fAction = "NONE";
            }
        }
        if (this.fMediatorTag.getAttribute("pageSize") != null) {
            String sizeString = this.fMediatorTag.getAttribute("pageSize");
            try {
                int size;
                this.fTargetPageSize = size = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private Element parseMediatorTag(Element wdoCommentTag, IDOMDocument document) {
        Node nextNode = wdoCommentTag;
        while (nextNode != null) {
            Element nextElement;
            if (nextNode instanceof Element && (nextElement = nextNode).getTagName().equals("wdo:useMediator") && nextElement.getAttribute("id") != null && nextElement.getAttribute("id").equals(wdoCommentTag.getAttribute("mediator"))) {
                return nextElement;
            }
            nextNode = nextNode.getNextSibling();
        }
        return null;
    }

    @Override
    public String getConnectionId() {
        return this.fConnId;
    }

    public String getDataType() {
        return this.fDataType;
    }

    public String getId() {
        return this.fId;
    }

    public String getInputFile() {
        return this.fInputFile;
    }

    @Override
    public Metadata getMetadata() {
        return (Metadata)this.getSDOPageDataNode().getSDODataFactory().getMetaDataModel();
    }

    public ISDOPageDataNode getSDOPageDataNode() {
        if (this.fSDOPageDataNode == null) {
            this.fSDOPageDataNode = this.getSDOPageDataNode((IDOMNode)this.fWDOTag);
        }
        return this.fSDOPageDataNode;
    }

    protected ISDOPageDataNode getSDOPageDataNode(IDOMNode node) {
        IPageDataNode pageDataNode;
        ISDOPageDataNode fWDOPageDataNode = null;
        PageDataNodeAdapter adapter = (PageDataNodeAdapter)node.getAdapterFor((Object)"PageDataNodeAdapterFactorycom.ibm.etools.webtools.pagedataview.WDO");
        if (adapter != null && (pageDataNode = adapter.getPageDataNode()) instanceof ISDOPageDataNode) {
            fWDOPageDataNode = (ISDOPageDataNode)pageDataNode;
        }
        return fWDOPageDataNode;
    }

    @Override
    public void setConnectionId(String string) {
        this.fConnId = string;
        this.fMediatorTag.setAttribute("connection", string);
    }

    public void setDataType(String string) {
        this.fDataType = string;
    }

    public void setId(String string) {
        String oldId = this.fId;
        this.fId = string;
        if (!oldId.equals(this.fId)) {
            ChangeAttributeCommand cmd = new ChangeAttributeCommand("attr", (Node)this.fWDOTag, "id", this.getId());
            ActionUtil.getActiveHTMLEditDomain().execCommand((Command)cmd);
            NodeList childList = this.fMediatorTag.getParentNode().getChildNodes();
            int i = 0;
            while (i < childList.getLength()) {
                Element childElement;
                Node node = childList.item(i);
                if (node instanceof Element && ((childElement = (Element)node).getTagName().equals("wdo:find") || childElement.getTagName().equals("wdo:create") || childElement.getTagName().equals("wdo:execute")) && childElement.getAttribute("id") != null && childElement.getAttribute("id").equals(oldId)) {
                    childElement.setAttribute("id", this.fId);
                }
                ++i;
            }
        }
    }

    @Override
    public void setInputFile(String string) {
        this.fInputFile = string;
        this.fWDOTag.setAttribute("input", string);
        this.fMediatorTag.setAttribute("input", string);
    }

    @Override
    public int getTargetPageSize() {
        return this.fTargetPageSize;
    }

    @Override
    public void setTargetPageSize(int size) {
        if (this.fTargetPageSize != size && size > 0) {
            this.fMediatorTag.setAttribute("pageSize", Integer.toString(size));
        } else if (size <= 0) {
            this.fMediatorTag.removeAttribute("pageSize");
        }
        this.fTargetPageSize = size;
    }

    public void setSDOPageDataNode(ISDOPageDataNode node) {
        this.fSDOPageDataNode = node;
    }

    public void notifySDOPageDataNodeChanged() throws MediatorException {
        if (this.getSDOPageDataNode() != null) {
            this.getSDOPageDataNode().changedMetaDataModel();
        }
    }

    @Override
    public FilterArgumentsManager getFilterArgumentsManager() {
        if (this.fFilterArgumentsManager == null) {
            this.fFilterArgumentsManager = new FilterArgumentsManagerWeb(true);
        }
        this.fFilterArgumentsManager.setMetadata(this.getMetadata());
        this.fFilterArgumentsManager.setNode(this.fMediatorTag);
        return this.fFilterArgumentsManager;
    }

    public IProject getProject() {
        return this.getSDOPageDataNode().getPageDataModel().getResource().getProject();
    }

    public IFile getFile() {
        return this.getSDOPageDataNode().getPageDataModel().getResource();
    }

    @Override
    public String getELValuePrefix() {
        return "${";
    }

    public String getMediator() {
        return this.fMediator;
    }

    public String getAction() {
        return this.fAction;
    }

    public void setAction(String action) {
        this.fAction = action;
    }
}

