package com.ibm.faces.sdo;

import java.io.File;
import java.net.URL;

import javax.faces.context.FacesContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ibm.websphere.sdo.mediator.domino.DominoConnection;
import com.ibm.websphere.sdo.mediator.domino.DominoConnectionFactoryImpl;
import com.ibm.misc.BASE64Decoder;

public class DominoConnectionManager {
	private static DominoConnection dominoConnection = null;
	private static String lastConnectionID = null;
	private static String CONFIG_FILE = "/WEB-INF/wdo/.dominoConnections";
	
	public static DominoConnection getConnection(String connectionID) {
		try {
			if(lastConnectionID != null && lastConnectionID.equals(connectionID)) {
		    	if(dominoConnection != null) {
		    		if(dominoConnection.getSession() != null && dominoConnection.getSession().isValid()) {
		    			return dominoConnection;
		    		}
		    	}
			}
		    DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		    DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
		    BASE64Decoder theCode = new BASE64Decoder();
		    URL url = FacesContext.getCurrentInstance().getExternalContext().getResource(CONFIG_FILE);
		    Document doc = docBuilder.parse(new File(url.getPath()));
		    doc.getDocumentElement().normalize();
		    NodeList listOfConnections = doc.getElementsByTagName("connection");
		    for (int i = 0; i < listOfConnections.getLength(); i++) {
				Node connection = listOfConnections.item(0);
				String id = connection.getAttributes().getNamedItem("id").getNodeValue();
				if(id.equals(connectionID)) {
					NodeList runtimeList = ((Element)connection).getElementsByTagName("runtime");
					Element runtime = (Element) runtimeList.item(0);
			        String server = runtime.getAttribute("server");
			        server = resolveExpression(server);
			        String user = runtime.getAttribute("user");
			        user = resolveExpression(user);
			        String pass = runtime.getAttribute("password");
			        if(pass.startsWith("{code}")) {
			        	pass = pass.substring(6);
			    		pass = new String(theCode.decodeBuffer(pass));
			        }
			        pass = resolveExpression(pass);
			        dominoConnection = DominoConnectionFactoryImpl.INSTANCE.createConnection(server, user, pass);
			        lastConnectionID = connectionID;
			        break;
				}
			}
		} catch (Throwable e) {
			System.out.println(e.getMessage());
		}
		
	    return dominoConnection;
	}
	
	public static void closeConnection() {
		try {
	    	if(dominoConnection != null) {
	    		if(dominoConnection.getSession() != null && dominoConnection.getSession().isValid()) {
	    			dominoConnection.getSession().recycle();
	    		}
	    		dominoConnection = null;
	    		lastConnectionID = null;
	    	}
		}
		catch (Throwable e) {
			System.out.println(e.getMessage());
		}
	}
	
	private static String resolveExpression(String expression) {
		String value = null;
		try {
			if ((expression.indexOf("#{") != -1)
				&& (expression.indexOf("#{") < expression.indexOf('}'))) {
				value = (String)
					FacesContext.getCurrentInstance().getApplication().createValueBinding(
						expression).getValue(FacesContext.getCurrentInstance());
			} else {
				value = expression;
			}
		}
		catch (Throwable e) {
			System.out.println(e.getMessage());
		}
		return value;
	}
}
