/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.websphere.internal.facets.datamodel;

import com.ibm.etools.webtools.rpcadapter.core.internal.util.FacetUtil;
import com.ibm.etools.webtools.rpcadapter.websphere.internal.facets.Web2FeaturePackFacetUtil;
import com.ibm.etools.webtools.rpcadapter.websphere.internal.facets.datamodel.IWeb2FeaturePackModelProperties;
import com.ibm.etools.webtools.rpcadapter.websphere.internal.nls.Messages;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class Web2FeaturePackInstallActionConfig
extends FacetInstallDataModelProvider
implements IWeb2FeaturePackModelProperties {
    private static final String WEB2_FP_ID = "web2featurepack";

    public Object create() {
        IDataModel model = (IDataModel)super.create();
        return model;
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("web2.fp.version");
        names.add("SHARED_LIBRARY_ID");
        names.add("ADD_RPCADAPTER_SERVLET");
        names.add("RPC_ADAPTER_SERVLET_MAPPING");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return WEB2_FP_ID;
        }
        if (propertyName.equals("web2.fp.version")) {
            return this.getVersionOfWeb2FeaturePack();
        }
        if ("SHARED_LIBRARY_ID".equals(propertyName)) {
            return Messages.Web2FeaturePackInstallActionConfig_feature_pack_library_name;
        }
        if ("RPC_ADAPTER_SERVLET_MAPPING".equals(propertyName)) {
            return "/RPCAdapter/*";
        }
        if ("ADD_RPCADAPTER_SERVLET".equals(propertyName)) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("RPC_ADAPTER_SERVLET_MAPPING".equals(propertyName)) {
            return this.getBooleanProperty("ADD_RPCADAPTER_SERVLET");
        }
        return super.isPropertyEnabled(propertyName);
    }

    public IStatus validate(String name) {
        String value;
        if (name.equals("web2.fp.version")) {
            String fpVersion = this.model.getStringProperty("web2.fp.version");
            String facetVersion = this.model.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
            if (fpVersion != null && facetVersion != null && !Web2FeaturePackFacetUtil.isFacetVersionCompatibleWithWeb2FPVersion(facetVersion, fpVersion)) {
                return new Status(2, "com.ibm.etools.webtools.rpcadapter.websphere", Messages.Web2FeaturePackInstallActionConfig_0);
            }
        } else if ("SHARED_LIBRARY_ID".equals(name)) {
            String value2 = this.model.getStringProperty("SHARED_LIBRARY_ID");
            if (value2 == null || value2.trim().equals("")) {
                return new Status(4, "com.ibm.etools.webtools.rpcadapter.websphere", Messages.Web2FeaturePackInstallActionConfig_must_specify_shared_library_name);
            }
        } else if ("RPC_ADAPTER_SERVLET_MAPPING".equals(name) && this.model.getBooleanProperty("ADD_RPCADAPTER_SERVLET") && ((value = this.model.getStringProperty("RPC_ADAPTER_SERVLET_MAPPING")) == null || value.trim().equals(""))) {
            return new Status(4, "com.ibm.etools.webtools.rpcadapter.websphere", Messages.Web2FeaturePackInstallActionConfig_must_specify_servlet_mapping);
        }
        return super.validate(name);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("ADD_RPCADAPTER_SERVLET".equals(propertyName)) {
            this.model.notifyPropertyChange("RPC_ADAPTER_SERVLET_MAPPING", 3);
            this.model.notifyPropertyChange("RPC_ADAPTER_SERVLET_MAPPING", 1);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private String getVersionOfWeb2FeaturePack() {
        org.eclipse.wst.server.core.IRuntime wasRuntime;
        String version = "1.0.0.1";
        IFacetedProjectWorkingCopy workingCopy = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        IRuntime targetedRuntime = workingCopy.getPrimaryRuntime();
        if (targetedRuntime != null && (wasRuntime = org.eclipse.wst.server.core.internal.facets.FacetUtil.getRuntime((IRuntime)targetedRuntime)) != null) {
            version = FacetUtil.determineVersionOfFeaturePackFromRuntime((org.eclipse.wst.server.core.IRuntime)wasRuntime);
        }
        return version;
    }
}

