/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.websphere.internal.facets;

import com.ibm.etools.webtools.rpcadapter.websphere.internal.nls.Messages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetInstallPage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Web2FeaturePackFacetInstallPage
extends DataModelFacetInstallPage
implements IFacetWizardPage {
    private static final String VERSION_ELEMENT = "version";
    private static final String PRODUCT_FILE_PATH = "/properties/version/WEB2FEP.product";
    private Composite helpMessageComposite;

    public Web2FeaturePackFacetInstallPage() {
        super("web2featurepack.install.page");
        this.setTitle(Messages.Web2ServerSideTech);
        this.setDescription(Messages.Web2ServerSideTechDesc);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createRpcAdapterControls(composite);
        this.createVersionControls(composite);
        return composite;
    }

    private void createVersionControls(Composite composite) {
        String facetVersion = (String)this.model.getProperty("IFacetDataModelProperties.FACET_VERSION_STR");
        String web2FPVersion = this.getVersionOfWeb2FeaturePack();
        Label facetVersionLabel = new Label(composite, 0);
        facetVersionLabel.setLayoutData((Object)new GridData(768));
        facetVersionLabel.setText(String.valueOf(Messages.FacetVersion) + facetVersion);
        Label fpVersionLabel = new Label(composite, 0);
        fpVersionLabel.setLayoutData((Object)new GridData(768));
        fpVersionLabel.setText(String.valueOf(Messages.Web2FPVersion) + web2FPVersion);
        this.helpMessageComposite = new Composite(composite, 0);
        this.helpMessageComposite.setLayoutData((Object)new GridData(768));
        this.helpMessageComposite.setLayout((Layout)new GridLayout(2, false));
        Label helpMessageIconLabel = new Label(this.helpMessageComposite, 0);
        helpMessageIconLabel.setImage(PlatformUI.getWorkbench().getDisplay().getSystemImage(2));
        Label helpMessageLabel = new Label(this.helpMessageComposite, 64);
        helpMessageLabel.setLayoutData((Object)new GridData(1808));
        helpMessageLabel.setText(Messages.ToFixHelp);
        helpMessageLabel.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(2));
        this.helpMessageComposite.setVisible(false);
        this.model.setProperty("web2.fp.version", (Object)web2FPVersion);
    }

    private void createRpcAdapterControls(Composite composite) {
        Group rpcAdapterGroup = new Group(composite, 0);
        rpcAdapterGroup.setText(Messages.Web2FeaturePackFacetInstallPage_RPC_Adapter);
        rpcAdapterGroup.setLayoutData((Object)new GridData(768));
        rpcAdapterGroup.setLayout((Layout)new GridLayout(2, false));
        Button generateServletMappingButton = new Button((Composite)rpcAdapterGroup, 32);
        generateServletMappingButton.setText(Messages.Web2FeaturePackFacetInstallPage_add_servlet_to_DD);
        GridData gData = new GridData(768);
        gData.horizontalSpan = 2;
        generateServletMappingButton.setLayoutData((Object)gData);
        Label urlMappingLabel = new Label((Composite)rpcAdapterGroup, 0);
        urlMappingLabel.setText(Messages.Web2FeaturePackFacetInstallPage_Servlet_mapping);
        Text urlMappingText = new Text((Composite)rpcAdapterGroup, 2048);
        urlMappingText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(urlMappingText, "RPC_ADAPTER_SERVLET_MAPPING", null);
        this.synchHelper.synchCheckbox(generateServletMappingButton, "ADD_RPCADAPTER_SERVLET", null);
    }

    private String getVersionOfWeb2FeaturePack() {
        IRuntime wasRuntime;
        String version = "1.0.0.1";
        IFacetedProjectWorkingCopy workingCopy = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime targetedRuntime = workingCopy.getPrimaryRuntime();
        if (targetedRuntime != null && (wasRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)targetedRuntime)) != null) {
            String productFilePath;
            File productFile;
            if (wasRuntime.isStub()) {
                return "1.0.0.1";
            }
            IPath location = wasRuntime.getLocation();
            if (location != null && (productFile = new File(productFilePath = String.valueOf(location.toString()) + PRODUCT_FILE_PATH)).exists()) {
                version = this.parseProductXMLFile(productFile);
            }
        }
        return version;
    }

    private String parseProductXMLFile(File productFile) {
        String version = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.endsWith("product.dtd")) {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                    return null;
                }
            });
            Document doc = docBuilder.parse(productFile);
            NodeList childNodes = doc.getElementsByTagName(VERSION_ELEMENT);
            int i = 0;
            if (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                version = child.getTextContent();
            }
        }
        catch (Exception exception) {
            version = "1.0.0.1";
            return version;
        }
        return version;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"SHARED_LIBRARY_ID", "RPC_ADAPTER_SERVLET_MAPPING", "web2.fp.version"};
    }

    public void transferStateToConfig() {
    }

    public void setWizardContext(IWizardContext context) {
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName = event.getPropertyName();
        if (this.helpMessageComposite != null && "web2.fp.version".equals(propertyName) && event.getFlag() == 1) {
            boolean isValid = this.model.validateProperty("web2.fp.version").isOK();
            if (!isValid) {
                this.helpMessageComposite.setVisible(true);
            } else {
                this.helpMessageComposite.setVisible(false);
            }
        }
        super.propertyChanged(event);
    }
}

