/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.websphere.internal.facets;

import com.ibm.etools.webtools.rpcadapter.core.internal.util.JavaUtil;
import com.ibm.etools.webtools.rpcadapter.websphere.internal.facets.Web2FeaturePackFacetUtil;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.models.config.libraries.impl.LibrariesFactoryImpl;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import com.ibm.ws.ast.st.enhanced.ear.internal.command.SharedLibraryConfiguratorCommand;
import com.ibm.ws.ast.st.enhanced.ear.internal.config.ApplicationConfiguratorModel;
import com.ibm.ws.ast.st.enhanced.ear.internal.config.SharedLibraryConfigurationModel;
import com.ibm.ws.ast.st.enhanced.ear.model.IApplicationConfiguratorModel;
import com.ibm.ws.ast.st.enhanced.ear.util.ApplicationConfiguratorModelFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.activities.WTPActivityBridge;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class Web2FeaturePackFacetInstallDelegate
implements IDelegate {
    static final byte[] RUNTIME_STUBS = new byte[]{1};
    private static final String SERVICE_DEVELOPER_ACTIVITY_ID = "com.ibm.wtp.services";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IDataModel dataModel = (IDataModel)config;
        this.setupSharedLibrary(project, dataModel);
        WASRuntimeUtil.addFeaturePackLibraries((IProject)project, (IProjectFacetVersion)fv);
        if (dataModel.getBooleanProperty("ADD_RPCADAPTER_SERVLET")) {
            String urlPattern = dataModel.getStringProperty("RPC_ADAPTER_SERVLET_MAPPING");
            JavaUtil.registerRPCAdapterServlet((IProject)project, (String)urlPattern);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WTPActivityBridge.getInstance().enableActivity(Web2FeaturePackFacetInstallDelegate.SERVICE_DEVELOPER_ACTIVITY_ID, true);
            }
        });
    }

    private void setupSharedLibrary(IProject project, IDataModel model) {
        block13: {
            IVirtualComponent component = Web2FeaturePackFacetUtil.getAppComponet(project);
            if (component != null) {
                String[] serverRelativePaths;
                String id = model.getStringProperty("SHARED_LIBRARY_ID");
                ArrayList<String> fullPaths = new ArrayList<String>();
                String serverPath = "${WAS_INSTALL_ROOT}";
                String[] stringArray = serverRelativePaths = Web2FeaturePackFacetUtil.searchOptionalLibraries(project, model);
                int n = serverRelativePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    Path p = new Path(s);
                    String converted = p.makeAbsolute().toString();
                    fullPaths.add(String.valueOf(serverPath) + "/" + "web2fep" + converted);
                    ++n2;
                }
                IApplicationConfiguratorModel appConfigModel = null;
                try {
                    appConfigModel = ApplicationConfiguratorModelFactory.createModel((IVirtualComponent)component);
                    if (appConfigModel == null) break block13;
                    ApplicationConfiguratorModel appConfigImpl = (ApplicationConfiguratorModel)appConfigModel;
                    SharedLibraryConfigurationModel sharedLibConfigModel = appConfigImpl.getSharedLibraryConfigModel();
                    if (sharedLibConfigModel == null) {
                        return;
                    }
                    try {
                        List libs = sharedLibConfigModel.getLibraryLst();
                        boolean match = false;
                        Library library = null;
                        for (Library lib : libs) {
                            if (!id.equals(lib.getName())) continue;
                            match = true;
                            library = lib;
                        }
                        if (match) {
                            EList list = library.getClassPath();
                            list.clear();
                            list.addAll(fullPaths);
                        } else {
                            LibrariesFactoryImpl factory = new LibrariesFactoryImpl();
                            library = factory.createLibrary();
                            library.setName(id);
                            library.getClassPath().addAll(fullPaths);
                            SharedLibraryConfiguratorCommand command = new SharedLibraryConfiguratorCommand();
                            command.setLibraryConfigModel(sharedLibConfigModel);
                            command.addLibraryEntry(library, appConfigImpl.getApplDeploymentConfigurationModel());
                        }
                        appConfigImpl.getApplicationDeployment().setWarClassLoaderPolicy(ClassLoaderPolicy.SINGLE_LITERAL);
                        appConfigImpl.save();
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
                finally {
                    if (appConfigModel != null) {
                        appConfigModel.cleanup();
                    }
                }
            }
        }
    }
}

