/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.ui.internal.wizard.slick.controls;

import com.ibm.etools.webtools.rpcadapter.core.internal.util.ServiceUtil;
import com.ibm.etools.webtools.rpcadapter.core.model.Service;
import com.ibm.etools.webtools.rpcadapter.core.model.ServiceMethod;
import com.ibm.etools.webtools.rpcadapter.ui.internal.ServicesUtil;
import com.ibm.etools.webtools.rpcadapter.ui.internal.nls.Messages;
import com.ibm.etools.webtools.slickui.SlickControlProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MethodControlProvider
extends SlickControlProvider
implements ModifyListener,
SelectionListener {
    private ServiceMethod method;
    private Text descriptionText;
    private Combo httpMethodCombo;
    private Text urlText;
    private Text aliasText;

    public MethodControlProvider(ServiceMethod method) {
        this.method = method;
    }

    public Composite getContents(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        baseComposite.setLayout((Layout)layout);
        baseComposite.setLayoutData((Object)new GridData(768));
        if ("http://www.ibm.com/xmlns/prod/websphere/featurepack/v6.1/RpcAdapterConfig/1.1".equals(ServiceUtil.getNamespace((IProject)this.method.getService().getProject()))) {
            Label aliasLabel = new Label(baseComposite, 0);
            aliasLabel.setText(Messages.MethodControlProvider_Alias);
            this.aliasText = new Text(baseComposite, 2048);
            this.aliasText.setLayoutData((Object)new GridData(768));
            this.aliasText.addModifyListener((ModifyListener)this);
            this.aliasText.setText(this.method.getServiceName());
        }
        Label descriptionLabel = new Label(baseComposite, 0);
        descriptionLabel.setText(Messages.MethodControlProvider_description);
        descriptionLabel.setLayoutData((Object)new GridData(2));
        this.descriptionText = new Text(baseComposite, 2624);
        GridData gData = new GridData(768);
        gData.widthHint = 220;
        gData.heightHint = 75;
        this.descriptionText.setLayoutData((Object)gData);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.descriptionText.setText(this.method.getDescription());
        Label httpMethodLabel = new Label(baseComposite, 0);
        httpMethodLabel.setText(Messages.MethodControlProvider_http_method);
        this.httpMethodCombo = new Combo(baseComposite, 8);
        this.httpMethodCombo.setItems(new String[]{"GET", "POST"});
        this.httpMethodCombo.addSelectionListener((SelectionListener)this);
        if (this.method.getHttpMethod().equals("GET")) {
            this.httpMethodCombo.select(0);
        } else {
            this.httpMethodCombo.select(1);
        }
        this.creatUrlLabelControl(baseComposite);
        this.updateValidationState();
        return baseComposite;
    }

    private void creatUrlLabelControl(Composite baseComposite) {
        Label urlLabel = new Label(baseComposite, 0);
        urlLabel.setText(Messages.MethodControlProvider_url);
        urlLabel.setLayoutData((Object)new GridData(2));
        this.urlText = new Text(baseComposite, 2120);
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.heightHint = 35;
        this.urlText.setLayoutData((Object)gData);
        this.updateUrlText();
    }

    private void updateUrlText() {
        Service service = (Service)this.modelObject;
        String httpMethod = this.method.getHttpMethod();
        this.urlText.setText(String.valueOf(httpMethod) + " " + ServicesUtil.constructURL(service, this.method));
    }

    public boolean shouldShow(Object model) {
        return true;
    }

    public IStatus getValidationState() {
        return this.method.validate();
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (source == this.descriptionText) {
            String newDescription = this.descriptionText.getText();
            this.method.setDescription(newDescription);
            this.updateValidationState();
        } else if (source == this.aliasText) {
            this.method.setServiceName(this.aliasText.getText());
            this.updateValidationState();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.httpMethodCombo) {
            this.method.setHttpMethod(this.httpMethodCombo.getText());
            this.updateUrlText();
        }
    }
}

