/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.ui.internal.wizard;

import com.ibm.etools.webtools.rpcadapter.core.model.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SupertypeMethodViewerFilter
extends ViewerFilter {
    private boolean showSuperTypeMethods = false;
    private List<IMethod> filteredItems = new ArrayList<IMethod>();
    private Service model;

    public SupertypeMethodViewerFilter(Service model) {
        this.model = model;
    }

    public boolean isShowSuperTypeMethods() {
        return this.showSuperTypeMethods;
    }

    public void setShowSuperTypeMethods(boolean showSuperTypeMethods) {
        this.showSuperTypeMethods = showSuperTypeMethods;
        if (showSuperTypeMethods) {
            this.filteredItems.clear();
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean select = true;
        if (!this.showSuperTypeMethods && element instanceof IMethod) {
            IMethod method = (IMethod)element;
            IType serviceType = this.model.getImplementation();
            try {
                IMethod[] baseTypeMethods = serviceType.getMethods();
                List<IMethod> baseTypeMethodList = Arrays.asList(baseTypeMethods);
                if (!baseTypeMethodList.contains(method)) {
                    select = false;
                    this.filteredItems.add(method);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return select;
    }

    public List<IMethod> getFilteredMethods() {
        return this.filteredItems;
    }
}

