/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.rpcadapter.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.CategoryChangeNotifier;
import com.ibm.etools.webtools.rpcadapter.core.IServiceCollectorListener;
import com.ibm.etools.webtools.rpcadapter.core.ServiceCollector;
import com.ibm.etools.webtools.rpcadapter.core.ServiceCollectorEvent;
import com.ibm.etools.webtools.rpcadapter.core.model.Service;
import com.ibm.etools.webtools.rpcadapter.ui.internal.pagedataview.PageDataModelUpdater;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ServicesListener
implements IPageDataModelLifeCycleListener,
IServiceCollectorListener {
    private List<IPageDataNode> pageDataRootNodes = new ArrayList<IPageDataNode>();

    public void pageDataModelInitialized(IPageDataModel model) {
        if (this.pageDataRootNodes.isEmpty()) {
            ServiceCollector.getInstance().addServiceCollectorListener((IServiceCollectorListener)this);
        }
        this.pageDataRootNodes.add(model.getRoot());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] allProjects = root.getProjects();
        ArrayList<Service> services = new ArrayList<Service>();
        int i = 0;
        while (i < allProjects.length) {
            IProject proj = allProjects[i];
            if (proj.isOpen() && this.isWebProject(proj)) {
                services.addAll(ServiceCollector.getInstance().getServices(proj));
            }
            ++i;
        }
        PageDataModelUpdater.updatePageDataModel(model, services);
    }

    private boolean isWebProject(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)"jst.web")) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        this.pageDataRootNodes.remove(model.getRoot());
        if (this.pageDataRootNodes.isEmpty()) {
            ServiceCollector.getInstance().removeServiceCollectorListener((IServiceCollectorListener)this);
        }
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    public void pageDataModelReleased() {
    }

    public void serviceChanged(ServiceCollectorEvent event) {
        int i = 0;
        while (i < this.pageDataRootNodes.size()) {
            IPageDataModel model = this.pageDataRootNodes.get(i).getPageDataModel();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] allProjects = root.getProjects();
            ArrayList<Service> services = new ArrayList<Service>();
            int j = 0;
            while (j < allProjects.length) {
                IProject proj = allProjects[j];
                if (proj.isOpen() && this.isWebProject(proj)) {
                    services.addAll(ServiceCollector.getInstance().getServices(proj));
                }
                ++j;
            }
            PageDataModelUpdater.updatePageDataModel(model, services);
            ++i;
        }
        if (this.pageDataRootNodes.size() > 0) {
            CategoryChangeNotifier.getSingleton().fireCategoryChanged("AJAXRPC", true);
        }
    }
}

