/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.util;

import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TagUtil {
    public static String getTagName(Node node) {
        String nodeName = node.getNodeName();
        int index = nodeName.lastIndexOf(58);
        if (index > 0) {
            nodeName = nodeName.substring(index + 1);
        }
        return nodeName;
    }

    public static Attr getAttribute(Node node, String attName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && attrs.getLength() > 0) {
            return (Attr)attrs.getNamedItem(attName);
        }
        return null;
    }

    public static Node findNode(Node start, String tagName) {
        Node ret = null;
        Node child = start.getFirstChild();
        while (child != null) {
            if (TagUtil.getTagName(child).equalsIgnoreCase(tagName)) {
                ret = child;
                break;
            }
            child = child.getNextSibling();
        }
        return ret;
    }

    public static Attr findAttribute(Node start, String tagName, String attributeName) {
        Attr ret = null;
        Node child = start.getFirstChild();
        while (child != null) {
            if (TagUtil.getTagName(child).equalsIgnoreCase(tagName)) {
                Attr attr = TagUtil.getAttribute(child, attributeName);
                if (attr == null || attr.getValue() == null) break;
                ret = attr;
                break;
            }
            child = child.getNextSibling();
        }
        return ret;
    }
}

