/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedataview.ui.internal.VisibilityRule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class VisibilityRulesUtil {
    private static final String ATT_FACET_EXISTS = "exists";
    private static final String ATT_FACET_VERSION = "version";
    private static final String ELEM_FACET = "facet";

    public static boolean processOrList(List orList, IProject proj) {
        boolean satisfied = false;
        int i = 0;
        while (i < orList.size()) {
            VisibilityRule rule = (VisibilityRule)orList.get(i);
            boolean shouldExist = rule.isShouldExist();
            String facetID = rule.getFacetID();
            String facetVersion = rule.getFacetVersion();
            if (facetVersion == "") {
                facetVersion = null;
            }
            if (VisibilityRulesUtil.projectHasFacet(proj, facetID, facetVersion) == shouldExist) {
                satisfied = true;
                break;
            }
            ++i;
        }
        return satisfied;
    }

    public static boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }

    public static VisibilityRule createVisibilityRule(IConfigurationElement facet) {
        VisibilityRule rule = new VisibilityRule();
        rule.setFacetID(facet.getAttribute("id"));
        rule.setFacetVersion(facet.getAttribute(ATT_FACET_VERSION));
        if (facet.getAttribute(ATT_FACET_EXISTS) == null) {
            rule.setShouldExist(true);
        } else {
            rule.setShouldExist(Boolean.valueOf(facet.getAttribute(ATT_FACET_EXISTS)));
        }
        return rule;
    }

    public static void addOrGroups(List visibilityRules, IConfigurationElement[] orGroups) {
        ArrayList<VisibilityRule> orGroupList = new ArrayList<VisibilityRule>();
        int i = 0;
        while (i < orGroups.length) {
            IConfigurationElement orGroup = orGroups[i];
            IConfigurationElement[] facets = orGroup.getChildren(ELEM_FACET);
            int j = 0;
            while (j < facets.length) {
                VisibilityRule rule = VisibilityRulesUtil.createVisibilityRule(facets[j]);
                orGroupList.add(rule);
                ++j;
            }
            ++i;
        }
        visibilityRules.add(orGroupList);
    }
}

