/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PageDataViewLabelProvider
extends LabelProvider {
    private Map categoryImages = new HashMap();

    public Image getImage(Object element) {
        if (element instanceof IPageDataNode) {
            IPageDataNode node = (IPageDataNode)element;
            IPageDataNodeUIAttribute adapter = (IPageDataNodeUIAttribute)node.getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY);
            if (adapter != null) {
                return adapter.getIcon(node);
            }
        } else if (element instanceof CategoryDefinition) {
            CategoryDefinition cd = (CategoryDefinition)element;
            Image categoryImage = (Image)this.categoryImages.get(cd.getIconFilePath());
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)cd.getExtendingPluginID(), (String)cd.getIconFilePath());
            if (categoryImage == null) {
                try {
                    if (imageDescriptor == null && cd.getIconFilePath() != null && cd.getIconFilePath() != "") {
                        throw new Exception("Icon: " + cd.getIconFilePath() + " not found.");
                    }
                    if (cd.getIconFilePath().equals("") || cd.getIconFilePath() == null) {
                        categoryImage = PageDataViewPlugin.getDefault().getImage("full/obj16/fldr_obj");
                    } else {
                        categoryImage = imageDescriptor.createImage();
                        this.categoryImages.put(cd.getIconFilePath(), categoryImage);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return categoryImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IPageDataNode) {
            IPageDataNode node = (IPageDataNode)element;
            IPageDataNodeUIAttribute adapter = (IPageDataNodeUIAttribute)node.getAdapter(IPageDataNodeUIAttribute.ADAPTER_KEY);
            if (adapter != null) {
                return adapter.getLabel(node);
            }
            return ResourceHandler.UI_defaultLabel;
        }
        if (element instanceof IWorkbenchAdapter) {
            return ResourceHandler.UI_Introspecting;
        }
        if (element instanceof CategoryDefinition) {
            CategoryDefinition cd = (CategoryDefinition)element;
            return cd.getName();
        }
        return super.getText(element);
    }

    public void dispose() {
        super.dispose();
        Collection collection = this.categoryImages.values();
        if (collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
        }
        this.categoryImages = null;
    }
}

