/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewLabelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class PageDataViewDeferredNodeFetcher
implements IDeferredWorkbenchAdapter {
    private Object node;
    private ITreeContentProvider contentProvider;
    private PageDataViewLabelProvider labelProvider;

    public PageDataViewDeferredNodeFetcher(Object node, ITreeContentProvider contentProvider) {
        this.node = node;
        this.contentProvider = contentProvider;
        this.labelProvider = new PageDataViewLabelProvider();
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 2);
            if (object instanceof PageDataNode || object instanceof CategoryDefinition) {
                Object[] children = this.contentProvider.getChildren(object);
                monitor.worked(1);
                collector.add(children, monitor);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isContainer() {
        boolean isContainer = false;
        if (this.node instanceof CategoryDefinition) {
            isContainer = true;
        } else if (this.node instanceof IPageDataNode) {
            isContainer = ((IPageDataNode)this.node).hasChildren();
        }
        return isContainer;
    }

    public ISchedulingRule getRule(Object object) {
        if (this.node instanceof PageDataNode) {
            return ((PageDataNode)this.node).getChildrenRule();
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.labelProvider.getText(o);
    }

    public Object getParent(Object o) {
        return this.contentProvider.getParent(o);
    }
}

