/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryRegistryReader;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.osgi.framework.Bundle;

public class NewActionsRegistryReader
extends RegistryReader {
    private static NewActionsRegistryReader singleton;
    public static final String NA_EXTPNT_ID = "newActions";
    public static final String NA_ELMNT_NAME = "action";
    public static final String ATTR_ID = "id";
    public static final String ATTR_PT = "pageType";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_GROUP = "group";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_CNTXT_NODE = "contextNode";
    public static final String ATTR_CATEGORY = "category";
    private Map newActionsForPageTypes = new HashMap(1);
    private Map newActionsForCategory = new HashMap(1);
    private List actionContextNodeNamePairs;
    private boolean actionsParsed = false;

    protected NewActionsRegistryReader() {
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(NA_ELMNT_NAME)) {
            return this.parseNewActionElement(element);
        }
        return false;
    }

    private boolean parseNewActionElement(IConfigurationElement element) {
        String categoryID;
        String contextNodeName;
        String classAttribute = element.getAttribute(ATTR_CLASS);
        if (classAttribute == null) {
            return false;
        }
        String pageTypesString = element.getAttribute(ATTR_PT);
        HashSet<String> pageTypes = new HashSet<String>(1);
        if (pageTypesString == null) {
            pageTypes.add("JSP");
            PageDataViewPlugin.getDefault().write(NLS.bind((String)ResourceHandler._WARN_noPageType, (Object[])new Object[]{element}));
        } else {
            StringTokenizer tkzr = new StringTokenizer(pageTypesString, ",");
            while (tkzr != null && tkzr.hasMoreTokens()) {
                String oneType = tkzr.nextToken().trim();
                if (oneType == null) continue;
                pageTypes.add(oneType);
            }
        }
        if (pageTypes != null && pageTypes.size() > 0) {
            for (String oneType : pageTypes) {
                ArrayList<IConfigurationElement> actions = (ArrayList<IConfigurationElement>)this.newActionsForPageTypes.get(oneType);
                if (actions == null) {
                    actions = new ArrayList<IConfigurationElement>(1);
                }
                if (!actions.contains(element)) {
                    actions.add(element);
                }
                this.newActionsForPageTypes.put(oneType, actions);
            }
        }
        if ((contextNodeName = element.getAttribute(ATTR_CNTXT_NODE)) != null) {
            ActionContextNodePair pair = new ActionContextNodePair(element, contextNodeName);
            if (this.actionContextNodeNamePairs == null) {
                this.actionContextNodeNamePairs = new ArrayList();
            }
            this.actionContextNodeNamePairs.add(pair);
        }
        if ((categoryID = element.getAttribute(ATTR_CATEGORY)) == null) {
            Object otherCategory = this.newActionsForCategory.get("Other");
            if (otherCategory == null) {
                otherCategory = new ArrayList();
                this.newActionsForCategory.put("Other", otherCategory);
            }
            ((List)otherCategory).add(element);
        } else {
            Object category = this.newActionsForCategory.get(categoryID);
            if (category == null) {
                category = new ArrayList();
                this.newActionsForCategory.put(categoryID, category);
            }
            ((List)category).add(element);
        }
        return true;
    }

    private void parseActions() {
        this.readRegistry(Platform.getPluginRegistry(), PageDataViewPlugin.getDefault().getBundle().getSymbolicName(), NA_EXTPNT_ID);
    }

    public static Map getNewActions(String[] pageTypes) {
        NewActionsRegistryReader singleton = NewActionsRegistryReader.getSingleton();
        if (!singleton.actionsParsed) {
            singleton.parseActions();
            singleton.actionsParsed = true;
        }
        if (pageTypes != null) {
            HashMap<String, List> ret = null;
            int i = 0;
            while (i < pageTypes.length) {
                List actions = (List)singleton.newActionsForPageTypes.get(pageTypes[i]);
                if (actions != null && actions.size() > 0) {
                    if (ret == null) {
                        ret = new HashMap<String, List>(1);
                    }
                    ret.put(pageTypes[i], actions);
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    protected static NewActionsRegistryReader getSingleton() {
        if (singleton == null) {
            singleton = new NewActionsRegistryReader();
        }
        return singleton;
    }

    public List getActionsForNode(String nodeClassName) {
        NewActionsRegistryReader singleton = NewActionsRegistryReader.getSingleton();
        if (!singleton.actionsParsed) {
            singleton.parseActions();
            singleton.actionsParsed = true;
        }
        ArrayList<Object> actions = null;
        int i = 0;
        while (i < this.actionContextNodeNamePairs.size()) {
            ActionContextNodePair pair = (ActionContextNodePair)this.actionContextNodeNamePairs.get(i);
            if (pair.contextNodeName.equals(nodeClassName)) {
                if (actions == null) {
                    actions = new ArrayList<Object>();
                }
                actions.add(pair.action);
            }
            ++i;
        }
        return actions;
    }

    public static List getActionsForCategory(String categoryID) {
        NewActionsRegistryReader singleton = NewActionsRegistryReader.getSingleton();
        if (!singleton.actionsParsed) {
            singleton.parseActions();
            singleton.actionsParsed = true;
        }
        List actions = null;
        if (singleton.newActionsForCategory.containsKey(categoryID)) {
            actions = (List)singleton.newActionsForCategory.get(categoryID);
        } else {
            CategoryDefinition cd = CategoryRegistryReader.getSingleton().getCategory(categoryID);
            if (cd.getChildren() != null) {
                List recursiveActions;
                actions = recursiveActions = singleton.buildSubCategoryActions(cd.getChildren());
            }
        }
        return actions;
    }

    private List buildSubCategoryActions(List children) {
        ArrayList childActions = new ArrayList();
        int i = 0;
        while (i < children.size()) {
            CategoryDefinition child = (CategoryDefinition)children.get(i);
            childActions.addAll((List)NewActionsRegistryReader.singleton.newActionsForCategory.get(child.getCategoryID()));
            if (child.getChildren() != null) {
                childActions.addAll(this.buildSubCategoryActions(child.getChildren()));
            }
            ++i;
        }
        return childActions;
    }

    public boolean isContextSensitive(String nodeClassName) {
        NewActionsRegistryReader singleton = NewActionsRegistryReader.getSingleton();
        if (!singleton.actionsParsed) {
            singleton.parseActions();
            singleton.actionsParsed = true;
        }
        boolean isContextSensitive = false;
        int i = 0;
        while (i < this.actionContextNodeNamePairs.size()) {
            ActionContextNodePair pair = (ActionContextNodePair)this.actionContextNodeNamePairs.get(i);
            if (pair.contextNodeName.equals(nodeClassName)) {
                isContextSensitive = true;
                break;
            }
            ++i;
        }
        return isContextSensitive;
    }

    public static void createClass(final IConfigurationElement element, final Object[] ret) {
        Bundle plugin = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
        if (plugin.getState() == 32) {
            try {
                ret[0] = element.createExecutableExtension(ATTR_CLASS);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = element.createExecutableExtension(NewActionsRegistryReader.ATTR_CLASS);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private class ActionContextNodePair {
        public Object action;
        public String contextNodeName;

        public ActionContextNodePair(Object action, String contextNodeName) {
            this.action = action;
            this.contextNodeName = contextNodeName;
        }
    }
}

