/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditPartTipHelper {
    private Shell shell;
    private Text text;
    private Label icon;
    private boolean tipShowing;
    private Control control;
    private MouseMoveListener mouseMoveListener;
    private MouseTrackListener mouseTrackListener;
    private MouseListener mouseListener;
    int X_SHIFT = 10;
    int Y_SHIFT = 20;

    public EditPartTipHelper(Control c) {
        this.control = c;
        this.mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point eventPoint = EditPartTipHelper.this.getControl().toDisplay(new Point(e.x + EditPartTipHelper.this.X_SHIFT + 1, e.y + EditPartTipHelper.this.Y_SHIFT + 1));
                if (!EditPartTipHelper.this.getShell().getBounds().contains(eventPoint)) {
                    if (EditPartTipHelper.this.isShowing()) {
                        EditPartTipHelper.this.getControl().setCapture(false);
                    }
                    EditPartTipHelper.this.hide();
                }
            }
        };
        this.mouseTrackListener = new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (EditPartTipHelper.this.isShowing()) {
                    EditPartTipHelper.this.getControl().setCapture(false);
                }
                EditPartTipHelper.this.hide();
            }
        };
        this.mouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
                if (EditPartTipHelper.this.isShowing()) {
                    EditPartTipHelper.this.getControl().setCapture(false);
                }
                EditPartTipHelper.this.hide();
            }
        };
    }

    protected Shell createShell() {
        Shell s = new Shell(this.control.getShell(), 542728);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        s.setLayout((Layout)layout);
        return s;
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.removeShellListeners();
    }

    protected Shell getShell() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.shell = this.createShell();
            this.hookShellListeners();
        }
        return this.shell;
    }

    protected void hide() {
        if (this.isShowing()) {
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.setVisible(false);
            }
            this.tipShowing = false;
        }
    }

    public boolean isShowing() {
        return this.tipShowing;
    }

    public void setBackgroundColor(Color c) {
        this.getShell().setBackground(c);
    }

    public void setForegroundColor(Color c) {
        this.getShell().setForeground(c);
    }

    protected void setShellBounds(int x, int y, int width, int height) {
        this.getShell().setBounds(x, y, width, height);
    }

    public void showTip(String label, Image image, int x, int y) {
        this.getText().setText(label);
        this.icon.setImage(image);
        Point size = this.getText().computeSize(150, -1);
        int imageWidth = image.getBounds().width;
        this.setShellBounds(x + this.X_SHIFT, y + this.Y_SHIFT, size.x + 10 + imageWidth, size.y + 10);
        Point txtSize = this.getText().getSize();
        if (size.x > txtSize.x || size.y > txtSize.y) {
            size.x = size.x + size.x - txtSize.x;
            size.y = size.y + size.y - txtSize.y;
            this.setShellBounds(x + this.X_SHIFT, y + this.Y_SHIFT, size.x + 10 + imageWidth, size.y + 10);
        }
        this.show();
    }

    protected void show() {
        this.getShell().setVisible(true);
        this.tipShowing = true;
    }

    public void hideToolTip() {
        this.hide();
    }

    public Text getText() {
        if (this.text == null || this.text.isDisposed()) {
            this.text = null;
            GridData layoutdata = new GridData();
            this.icon = new Label((Composite)this.getShell(), 0);
            layoutdata.verticalAlignment = 1;
            layoutdata.horizontalAlignment = 1;
            this.icon.setLayoutData((Object)layoutdata);
            this.text = new Text((Composite)this.getShell(), 66);
            layoutdata = new GridData(1808);
            this.text.setLayoutData((Object)layoutdata);
        }
        return this.text;
    }

    protected void hookShellListeners() {
        this.getControl().addMouseMoveListener(this.mouseMoveListener);
        this.getControl().addMouseTrackListener(this.mouseTrackListener);
        this.getControl().addMouseListener(this.mouseListener);
    }

    protected void removeShellListeners() {
        this.getControl().removeMouseMoveListener(this.mouseMoveListener);
        this.getControl().removeMouseTrackListener(this.mouseTrackListener);
        this.getControl().removeMouseListener(this.mouseListener);
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }
}

