/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelListenersDispatcher;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.ui.internal.CategoryNode;
import com.ibm.etools.webtools.pagedataview.ui.internal.IActionDelegateAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class DeleteActionDelegate
implements IActionDelegate,
IPageDataModelLifeCycleListener {
    private Object[] selectedObjects;

    public void run(IAction action) {
        if (this.selectedObjects != null) {
            int i = 0;
            while (i < this.selectedObjects.length) {
                boolean executed = false;
                IPageDataNode selectedObject = (IPageDataNode)this.selectedObjects[i];
                IActionDelegateAdapter adapter = (IActionDelegateAdapter)selectedObject.getAdapter(IActionDelegateAdapter.ADAPTER_KEY);
                if (adapter != null) {
                    executed = adapter.handleAction(selectedObject, 0);
                }
                if (!executed && selectedObject instanceof ISSEPageDataNode) {
                    PageDataModelUtil.deletePageData((ISSEPageDataNode)((ISSEPageDataNode)selectedObject));
                }
                ++i;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            PageDataModelListenersDispatcher.addPageDataModelListener((IPageDataModelLifeCycleListener)this);
            this.selectedObjects = ((IStructuredSelection)selection).toArray();
            enabled = DeleteActionDelegate.selectedItemsCanBeDeleted(this.selectedObjects);
            if (!enabled) {
                this.selectedObjects = null;
                PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
            }
            action.setEnabled(enabled);
        }
    }

    public void pageDataModelInitialized(IPageDataModel model) {
    }

    public void pageDataModelReleased() {
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        if (this.selectedObjects != null) {
            int i = 0;
            while (i < this.selectedObjects.length) {
                if (((IPageDataNode)this.selectedObjects[i]).getPageDataModel() == model) {
                    this.selectedObjects = null;
                    PageDataModelListenersDispatcher.removePageDataModelListener((IPageDataModelLifeCycleListener)this);
                    break;
                }
                ++i;
            }
        }
    }

    public static boolean selectedItemsCanBeDeleted(Object[] selectedNodes) {
        boolean enabled = true;
        int i = 0;
        while (i < selectedNodes.length) {
            Object selectedObject = selectedNodes[i];
            if (!(selectedObject instanceof IPageDataNode) || selectedObject instanceof CategoryNode) {
                return false;
            }
            IActionDelegateAdapter adapter = (IActionDelegateAdapter)((IPageDataNode)selectedObject).getAdapter(IActionDelegateAdapter.ADAPTER_KEY);
            if (adapter != null) {
                enabled = adapter.canHandleAction((IPageDataNode)selectedObject, 0);
                if (!enabled) {
                    break;
                }
            } else if (!PageDataModelUtil.isComponentNode((IPageDataNode)((IPageDataNode)selectedObject))) {
                enabled = false;
                break;
            }
            ++i;
        }
        return enabled;
    }

    public void setSelectedObjects(Object[] selectedObjects) {
        this.selectedObjects = selectedObjects;
    }
}

