/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webedit.attributes.IAttributeViewFolder;
import com.ibm.etools.webedit.attributes.view.IAttributeViewProvider;
import com.ibm.etools.webedit.taglib.design.DesignTimeTagAdapter;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.ConfigureDialog;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class AttributeDialog
extends ConfigureDialog {
    private static final String EMPTY_MESSAGE = com.ibm.etools.webtools.pagedataview.nls.ResourceHandler.NO_ATTR;
    private IAttributeViewFolder folder;

    public AttributeDialog(Shell parentShell, IPageDataNode node) {
        super(parentShell, node);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        clientArea.setLayoutData((Object)gridData);
        new Label(clientArea, 0);
        Composite root = new Composite(clientArea, 0);
        gridData = new GridData(1808);
        root.setLayoutData((Object)gridData);
        root.setLayout((Layout)new GridLayout());
        IAttributeViewProvider prov = this.getAVProvider();
        if (prov != null) {
            this.folder = prov.getCustomAttributeView(root);
            if (this.folder != null && this.getDOMNode().isDataEditable()) {
                prov.updateCustomAttributeView((Node)this.getDOMNode());
                this.folder.setVisible(true);
                this.updateTitleAndIcon();
                root.layout();
                return root;
            }
        }
        this.showEmptyMessage(root);
        this.updateTitleAndIcon();
        return root;
    }

    private void updateTitleAndIcon() {
        IBindingAttribute binding = (IBindingAttribute)this.nodeToConfigure.getAdapter(IBindingAttribute.ADAPTER_KEY);
        this.getShell().setText(NLS.bind((String)ResourceHandler.UI_Cfg, (Object[])new String[]{binding.getTypeAsString(this.nodeToConfigure), binding.getName(this.nodeToConfigure)}));
        this.getShell().setImage(PageDataViewPlugin.getDefault().getImage("full/eview16/pagedata_view"));
    }

    private void showEmptyMessage(Composite parent) {
        new Label(parent, 0);
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        Label icon = new Label(group, 0);
        icon.setImage(PageDataViewPlugin.getDefault().getImage("full/obj16/warning"));
        Label message = new Label(group, 0);
        message.setText(EMPTY_MESSAGE);
        new Label(parent, 0);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
    }

    public IAttributeViewProvider getAVProvider() {
        IDOMNode domNode = this.getDOMNode();
        if (domNode != null) {
            DesignTimeTagAdapter adapter = (DesignTimeTagAdapter)domNode.getAdapterFor(DesignTimeTagAdapter.class);
            return adapter;
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Shell shell = this.getShell();
        shell.setSize(560, 510);
        return super.createContents(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

