/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.internal.IPageDataViewActionBarContributor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ActionBarContributorRegistryReader {
    private static ActionBarContributorRegistryReader singleton;
    private boolean parsed = false;
    private Map contributorCache;
    private List contributors;
    private static final String ACTION_BAR_EXT_PT_ID = "PageDataViewActionBarContributor";
    private static final String ELEM_CONTRIBUTOR = "contributor";
    private static final String ELEM_FACET = "facet";
    private static final String ATT_CLASS = "class";
    private static final String ATT_EXISTS = "exists";
    private static final String ATT_ID = "id";
    private static final String ATT_VERSION = "version";

    public static ActionBarContributorRegistryReader getSingleton() {
        if (singleton == null) {
            singleton = new ActionBarContributorRegistryReader();
        }
        return singleton;
    }

    public List getContributors(IPageDataModel model) {
        if (!this.parsed) {
            ActionBarContributorRegistryReader.getSingleton().parseContributors();
        }
        return this.determineVisibleContributors(model);
    }

    private void parseContributors() {
        String pluginId = PageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pluginId, ACTION_BAR_EXT_PT_ID);
        IExtension[] extensions = point.getExtensions();
        this.contributors = new ArrayList();
        int i = 0;
        while (i < extensions.length) {
            String extensionID;
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            ContributorDefinition cd = new ContributorDefinition();
            cd.id = extensionID = extensions[i].getUniqueIdentifier();
            int j = 0;
            while (j < configElements.length) {
                String name = configElements[j].getName();
                if (ELEM_CONTRIBUTOR.equals(name)) {
                    cd.contributorClassElement = configElements[j];
                } else if (ELEM_FACET.equals(name)) {
                    if (cd.facets == null) {
                        cd.facets = new ArrayList();
                    }
                    cd.facets.add(configElements[j]);
                }
                ++j;
            }
            this.contributors.add(cd);
            ++i;
        }
        this.parsed = true;
    }

    private List determineVisibleContributors(IPageDataModel model) {
        ArrayList<Object> visibleContributors = null;
        if (this.contributors != null) {
            int i = 0;
            while (i < this.contributors.size()) {
                ContributorDefinition cd = (ContributorDefinition)this.contributors.get(i);
                boolean isVisible = true;
                if (cd.facets != null) {
                    int j = 0;
                    while (j < cd.facets.size()) {
                        IConfigurationElement facetElement = (IConfigurationElement)cd.facets.get(j);
                        String facetID = facetElement.getAttribute(ATT_ID);
                        String facetVersion = facetElement.getAttribute(ATT_VERSION);
                        boolean shouldExist = facetElement.getAttribute(ATT_EXISTS) == null ? true : Boolean.valueOf(facetElement.getAttribute(ATT_EXISTS));
                        if (ActionBarContributorRegistryReader.projectHasFacet(model.getResource().getProject(), facetID, facetVersion) != shouldExist) {
                            isVisible = false;
                            break;
                        }
                        ++j;
                    }
                }
                if (isVisible) {
                    if (visibleContributors == null) {
                        visibleContributors = new ArrayList<Object>();
                    }
                    if (this.getContributorCache().get(cd.id) != null) {
                        visibleContributors.add(this.contributorCache.get(cd.id));
                    } else {
                        try {
                            IPageDataViewActionBarContributor contributor = (IPageDataViewActionBarContributor)cd.contributorClassElement.createExecutableExtension(ATT_CLASS);
                            this.contributorCache.put(cd.id, contributor);
                            visibleContributors.add(contributor);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
        return visibleContributors;
    }

    private Map getContributorCache() {
        if (this.contributorCache == null) {
            this.contributorCache = new HashMap();
        }
        return this.contributorCache;
    }

    private static boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }

    private class ContributorDefinition {
        String id;
        List facets;
        IConfigurationElement contributorClassElement;

        private ContributorDefinition() {
        }
    }
}

