/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.dnd;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webedit.extension.IExtendedVisualEditor;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.PageDataViewRegistryReader;
import com.ibm.etools.webtools.pagedataview.commands.ChangeAttributeCommand;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropActionConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropActionHelper;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetDescription;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropActionMediator;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropColleague;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.DropActionMediatorElement;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.WorkUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class InsertHelper
implements IDropColleague {
    public void performInsert(IPageDataNode[] insertObjects, IEditorPart arg1) {
        this.doDrop(insertObjects, arg1);
    }

    public final boolean doDrop(IPageDataNode[] insertObjects, IEditorPart arg1) {
        boolean ret = false;
        try {
            DropTargetDescription target = this.newDropTargetDescription(arg1);
            List workUnits = PageDataViewPlugin.getDefault().getWorkUnits();
            if (workUnits == null) {
                this.getDropTargetObject(insertObjects, arg1);
                workUnits = PageDataViewPlugin.getDefault().getWorkUnits();
            }
            if (workUnits != null) {
                int i = 0;
                while (i < workUnits.size()) {
                    short type;
                    WorkUnit oneUnit = (WorkUnit)workUnits.get(i);
                    if (oneUnit != null && oneUnit.isConfigured() && (type = oneUnit.getConfig().dropOperation) != 3) {
                        IPageDataNode[] dropObjects = oneUnit.getSubUnits();
                        DropActionConfig config = oneUnit.getMediator().getDropActionConfig(this, dropObjects, target, type);
                        ret = this.doDropAction(config, type, arg1);
                    }
                    ++i;
                }
            }
        }
        finally {
            PageDataViewPlugin.getDefault().setWorkUnits(null);
            ret = false;
        }
        return ret;
    }

    protected boolean doDropAction(DropActionConfig config, short type, IEditorPart editor) {
        if (type == 2) {
            Node targetNode = this.getTargetRange(editor).getStartContainer();
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_BEFORE_ACTION);
            this.populateAttributes(config.getValueMap(), targetNode);
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_AFTER_ACTION);
        } else if (type == 1) {
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_BEFORE_ACTION);
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_AFTER_ACTION);
        } else {
            return false;
        }
        return true;
    }

    public final DropTargetObject getDropTargetObject(IPageDataNode[] insertObjects, IEditorPart arg1) {
        DropTargetObject ret = null;
        Range range = this.getTargetRange(arg1);
        if (range != null) {
            int startOffSet = this.findSmallestStartOffset(insertObjects);
            int currentOffSet = SelectionUtil.calcFlatModelOffset((IDOMNode)((IDOMNode)range.getStartContainer()), (int)range.getStartOffset());
            boolean bodyExists = DropActionHelper.findBody(range);
            if (currentOffSet <= startOffSet && bodyExists) {
                ret = null;
            } else {
                Collection plainWorkUnits = DropActionHelper.splitDataComponents(insertObjects);
                IProject proj = null;
                if (insertObjects[0] != null) {
                    proj = insertObjects[0].getPageDataModel().getResource().getProject();
                }
                List mediators = PageDataViewRegistryReader.getDropActionMediators(proj);
                DropTargetDescription target = this.newDropTargetDescription(arg1);
                if (mediators != null && mediators.size() > 0) {
                    boolean allConfigured = true;
                    ArrayList<WorkUnit> configuredUnits = null;
                    ArrayList<WorkUnit> nonconfiguredUnits = null;
                    for (WorkUnit oneUnit : plainWorkUnits) {
                        this.setupWorkUnit(oneUnit, mediators, target, (short)0);
                        if (!oneUnit.isConfigured()) {
                            if (nonconfiguredUnits == null) {
                                nonconfiguredUnits = new ArrayList<WorkUnit>(1);
                            }
                            nonconfiguredUnits.add(oneUnit);
                            allConfigured = false;
                            continue;
                        }
                        if (configuredUnits == null) {
                            configuredUnits = new ArrayList<WorkUnit>(1);
                        }
                        configuredUnits.add(oneUnit);
                    }
                    if (!allConfigured) {
                        ArrayList newUnits = new ArrayList(1);
                        int i = 0;
                        while (i < nonconfiguredUnits.size()) {
                            WorkUnit one = (WorkUnit)nonconfiguredUnits.get(i);
                            if (!one.isConfigured()) {
                                List workUnits = DropActionHelper.organizeForSmartGrouping(one.getSubUnits());
                                if (workUnits.size() > 1) {
                                    int j = 0;
                                    while (j < workUnits.size()) {
                                        this.setupWorkUnit((WorkUnit)workUnits.get(j), mediators, target, (short)1);
                                        newUnits.add(workUnits.get(j));
                                        ++j;
                                    }
                                } else {
                                    this.setupWorkUnit((WorkUnit)workUnits.get(0), mediators, target, (short)0);
                                    newUnits.add(workUnits.get(0));
                                }
                            }
                            ++i;
                        }
                        if (configuredUnits == null) {
                            configuredUnits = new ArrayList(1);
                        }
                        configuredUnits.addAll(newUnits);
                    }
                    if (!DropActionHelper.validateWorkUnits(configuredUnits)) {
                        ret = null;
                    } else {
                        PageDataViewPlugin.getDefault().setWorkUnits(configuredUnits);
                        WorkUnit firstUnit = (WorkUnit)configuredUnits.get(0);
                        ret = firstUnit.getConfig() == null ? null : firstUnit.getConfig().dropTarget;
                    }
                }
            }
        }
        return ret;
    }

    protected int findSmallestStartOffset(IPageDataNode[] dropObjects) {
        int startOffSet = 0;
        int i = 0;
        while (i < dropObjects.length) {
            IDOMNode domNode;
            if (dropObjects[i] instanceof ISSEPageDataNode && (domNode = ((ISSEPageDataNode)dropObjects[i]).getDOMNode()) != null) {
                startOffSet = i == 0 ? domNode.getStartOffset() : Math.min(startOffSet, domNode.getStartOffset());
            }
            ++i;
        }
        return startOffSet;
    }

    private DropTargetDescription newDropTargetDescription(IEditorPart editor) throws DOMException {
        DropTargetDescription target = new DropTargetDescription();
        Range range = this.getTargetRange(editor);
        target.setTargetNode(range.getStartContainer());
        target.setRange(range);
        target.setVisualRange(this.getTargetVisualRange(editor));
        return target;
    }

    protected void populateAttributes(Map valueMap, Node targetNode) {
        CompoundHTMLCommand cmd = new CompoundHTMLCommand("Change attr");
        NamedNodeMap attributes = targetNode.getAttributes();
        if (attributes != null && valueMap != null && valueMap.size() > 0) {
            Set keys = valueMap.keySet();
            String[] keyArray = keys.toArray(new String[0]);
            int i = 0;
            while (i < keyArray.length) {
                Object value = valueMap.get(keyArray[i]);
                cmd.append((HTMLCommand)new ChangeAttributeCommand("Attr Value", (Element)targetNode, keyArray[i], (String)value));
                ++i;
            }
        }
        if (!cmd.isEmpty()) {
            cmd.execute();
        }
    }

    private InsertConfigUnit prioritize(InsertConfigUnit currentConfig, DropActionMediatorElement tempACMElement, DropTargetConfig tempDTConfig) {
        if (currentConfig == null) {
            currentConfig = new InsertConfigUnit();
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        } else if (currentConfig.config.dropOperation == 1 && tempDTConfig.dropOperation == 2) {
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        } else if (currentConfig.config.dropOperation != 3 && tempDTConfig.dropOperation == 3) {
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        } else if (tempACMElement.priority < currentConfig.mediator.priority && currentConfig.config.dropOperation == tempDTConfig.dropOperation) {
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        }
        return currentConfig;
    }

    private void setupWorkUnit(WorkUnit oneUnit, List mediators, DropTargetDescription target, short useSmartGrouping) {
        IPageDataNode[] nodes = oneUnit.getSubUnits();
        InsertConfigUnit currentConfig = null;
        int size = mediators.size();
        int i = 0;
        while (i < size) {
            DropActionMediatorElement element = (DropActionMediatorElement)mediators.get(i);
            if (useSmartGrouping == 0 || element.smartGrouping == (useSmartGrouping == 1)) {
                IDropActionMediator mediator = (IDropActionMediator)element.mediator;
                DropTargetConfig temp = null;
                try {
                    temp = mediator.getDropTargetConfig(this, nodes, target);
                }
                catch (Throwable t) {
                    PageDataViewPlugin.getDefault().write(t.getMessage());
                }
                if (temp != null && temp.dropOperation != 0) {
                    currentConfig = this.prioritize(currentConfig, element, temp);
                }
            }
            ++i;
        }
        if (currentConfig != null && currentConfig.config.dropOperation != 3) {
            oneUnit.setMediator((IDropActionMediator)currentConfig.mediator.mediator);
            oneUnit.setConfig(currentConfig.config);
        }
    }

    protected IBindingAttribute getBindingAttribute(IPageDataNode object) {
        Object binding = object.getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (binding != null) {
            return (IBindingAttribute)binding;
        }
        return null;
    }

    protected IPageDataNode[] getDropObjectFromTransfer(TransferData data) {
        return null;
    }

    @Override
    public String getDropObjectTypeAsString(IPageDataNode dropObject) {
        IBindingAttribute bindingAttribute;
        if (dropObject != null && (bindingAttribute = this.getBindingAttribute(dropObject)) != null) {
            return bindingAttribute.getTypeAsString(dropObject);
        }
        return null;
    }

    @Override
    public String getDropObjectFullName(IPageDataNode dropObject, short type) {
        IBindingAttribute bindingAttribute;
        if (dropObject != null && (bindingAttribute = this.getBindingAttribute(dropObject)) != null) {
            return bindingAttribute.getReferenceString(dropObject);
        }
        return null;
    }

    @Override
    public String getDropObjectName(IPageDataNode dropObject) {
        IBindingAttribute bindingAttribute;
        if (dropObject != null && (bindingAttribute = this.getBindingAttribute(dropObject)) != null) {
            return bindingAttribute.getName(dropObject);
        }
        return null;
    }

    @Override
    public String getDropObjectRuntimeType(IPageDataNode dropObject) {
        if (dropObject != null) {
            return this.getBindingAttribute(dropObject).getRuntimeType(dropObject);
        }
        return null;
    }

    protected Range getTargetRange(IEditorPart targetEditor) {
        if (!(targetEditor instanceof IExtendedVisualEditor)) {
            return null;
        }
        IExtendedVisualEditor visualEditor = (IExtendedVisualEditor)targetEditor;
        return visualEditor.getRange();
    }

    protected Range getTargetVisualRange(IEditorPart targetEditor) {
        if (!(targetEditor instanceof IExtendedVisualEditor)) {
            return null;
        }
        IExtendedVisualEditor visualEditor = (IExtendedVisualEditor)targetEditor;
        return visualEditor.getVisualRange();
    }

    private class InsertConfigUnit {
        DropActionMediatorElement mediator;
        DropTargetConfig config;

        private InsertConfigUnit() {
        }
    }
}

