/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui.dnd;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webedit.extension.AbstractEventDropAction;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.NoAdapterFoundException;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.NoGeneratorFoundException;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.PageDataViewRegistryReader;
import com.ibm.etools.webtools.pagedataview.commands.ChangeAttributeCommand;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropActionConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropActionHelper;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropHint;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetDescription;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropActionMediator;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropColleague;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.DropActionMediatorElement;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.DropHintDisplay;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.WorkUnit;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public abstract class AbstractDropAction
extends AbstractEventDropAction
implements IDropColleague {
    public DropTargetObject getDropTargetObject(DropTargetEvent arg0, IEditorPart arg1, EditPartViewer arg2) {
        DropHint hint = null;
        DropTargetObject ret = null;
        Range range = this.getTargetRange(arg1);
        if (range != null) {
            IPageDataNode[] dropObjects = this.getDropObjectFromTransfer(arg0.currentDataType);
            int startOffSet = this.findSmallestStartOffset(dropObjects);
            int currentOffSet = SelectionUtil.calcFlatModelOffset((IDOMNode)((IDOMNode)range.getStartContainer()), (int)range.getStartOffset());
            boolean bodyExists = DropActionHelper.findBody(range);
            if (currentOffSet <= startOffSet && bodyExists) {
                hint = new DropHint(DropHint.DEFAULT_NOOP_IMAGE, ResourceHandler.UI_DND_Loc);
                ret = null;
            } else {
                Collection plainWorkUnits = this.splitDataComponents(dropObjects);
                IProject proj = null;
                if (dropObjects[0] != null) {
                    proj = dropObjects[0].getPageDataModel().getResource().getProject();
                }
                List mediators = PageDataViewRegistryReader.getDropActionMediators(proj);
                DropTargetDescription target = this.newDropTargetDescription(arg1);
                if (mediators != null && mediators.size() > 0) {
                    boolean allConfigured = true;
                    ArrayList<WorkUnit> configuredUnits = null;
                    ArrayList<WorkUnit> nonconfiguredUnits = null;
                    for (WorkUnit oneUnit : plainWorkUnits) {
                        this.setupWorkUnit(oneUnit, mediators, target, (short)0);
                        if (!oneUnit.isConfigured()) {
                            if (nonconfiguredUnits == null) {
                                nonconfiguredUnits = new ArrayList<WorkUnit>(1);
                            }
                            nonconfiguredUnits.add(oneUnit);
                            allConfigured = false;
                            continue;
                        }
                        if (configuredUnits == null) {
                            configuredUnits = new ArrayList<WorkUnit>(1);
                        }
                        configuredUnits.add(oneUnit);
                    }
                    if (!allConfigured) {
                        ArrayList newUnits = new ArrayList(1);
                        int i = 0;
                        while (i < nonconfiguredUnits.size()) {
                            WorkUnit one = (WorkUnit)nonconfiguredUnits.get(i);
                            if (!one.isConfigured()) {
                                List workUnits = DropActionHelper.organizeForSmartGrouping(one.getSubUnits());
                                if (workUnits.size() > 1) {
                                    int j = 0;
                                    while (j < workUnits.size()) {
                                        this.setupWorkUnit((WorkUnit)workUnits.get(j), mediators, target, (short)1);
                                        newUnits.add(workUnits.get(j));
                                        ++j;
                                    }
                                } else {
                                    this.setupWorkUnit((WorkUnit)workUnits.get(0), mediators, target, (short)0);
                                    newUnits.add(workUnits.get(0));
                                }
                            }
                            ++i;
                        }
                        if (configuredUnits == null) {
                            configuredUnits = new ArrayList(1);
                        }
                        configuredUnits.addAll(newUnits);
                    }
                    if (!DropActionHelper.validateWorkUnits(configuredUnits)) {
                        hint = new DropHint(DropHint.DEFAULT_NOOP_IMAGE, ResourceHandler.UI_DND_MixOp);
                        ret = null;
                    } else if (DropActionHelper.containsProhibitWorkUnit(configuredUnits)) {
                        ret = null;
                    } else {
                        PageDataViewPlugin.getDefault().setWorkUnits(configuredUnits);
                        hint = this.assembleDropHint(configuredUnits, target);
                        WorkUnit firstUnit = (WorkUnit)configuredUnits.get(0);
                        ret = firstUnit.getConfig().dropTarget;
                        short op = firstUnit.getConfig().dropOperation;
                        if (op == 1) {
                            ret = super.getDropTargetObject(arg0, arg1, arg2);
                        }
                    }
                }
            }
        }
        if (hint != null && arg2 != null && arg2.getControl() != null) {
            if (!SWT.getPlatform().equals("gtk") && !SWT.getPlatform().equals("motif")) {
                DropHintDisplay.createHoverHelp(arg2.getControl(), arg0.x, arg0.y, hint);
            }
        } else {
            DropHintDisplay.disposeHoverHelp();
        }
        return ret;
    }

    private DropHint assembleDropHint(List workUnits, DropTargetDescription target) {
        DropHint dropHint = null;
        int i = 0;
        while (i < workUnits.size()) {
            StringBuffer buf;
            WorkUnit oneUnit = (WorkUnit)workUnits.get(i);
            if (oneUnit != null && oneUnit.isConfigured()) {
                DropHint temp = this.getDropHint(oneUnit, target, oneUnit.getConfig().dropOperation);
                if (dropHint == null) {
                    dropHint = temp;
                } else {
                    if (dropHint.getImage() == null) {
                        dropHint.setImage(temp.getImage());
                    }
                    buf = new StringBuffer(dropHint.getText());
                    buf.append("\n\n");
                    buf.append(temp.getText());
                    dropHint.setText(buf.toString());
                }
            } else {
                String message = ResourceHandler.UI_DND_Skip;
                if (dropHint == null) {
                    dropHint = new DropHint(null, message);
                } else {
                    buf = new StringBuffer(dropHint.getText());
                    buf.append("\n\n");
                    buf.append(message);
                    dropHint.setText(buf.toString());
                }
            }
            ++i;
        }
        return dropHint;
    }

    protected void setupWorkUnit(WorkUnit oneUnit, List mediators, DropTargetDescription target, short useSmartGrouping) {
        IPageDataNode[] nodes = oneUnit.getSubUnits();
        ConfigUnit currentConfig = null;
        int size = mediators.size();
        int i = 0;
        while (i < size) {
            DropActionMediatorElement element = (DropActionMediatorElement)mediators.get(i);
            if (useSmartGrouping == 0 || element.smartGrouping == (useSmartGrouping == 1)) {
                IDropActionMediator mediator = (IDropActionMediator)element.mediator;
                DropTargetConfig temp = null;
                try {
                    temp = mediator.getDropTargetConfig(this, nodes, target);
                }
                catch (Throwable t) {
                    PageDataViewPlugin.getDefault().write(t);
                }
                if (temp != null && temp.dropOperation != 0) {
                    currentConfig = this.prioritize(currentConfig, element, temp);
                }
            }
            ++i;
        }
        if (currentConfig != null) {
            oneUnit.setMediator((IDropActionMediator)currentConfig.mediator.mediator);
            oneUnit.setConfig(currentConfig.config);
        }
    }

    protected ConfigUnit prioritize(ConfigUnit currentConfig, DropActionMediatorElement tempACMElement, DropTargetConfig tempDTConfig) {
        if (currentConfig == null) {
            currentConfig = new ConfigUnit();
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        } else if (currentConfig.config.dropOperation == 1 && tempDTConfig.dropOperation == 2) {
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        } else if (currentConfig.config.dropOperation != 3 && tempDTConfig.dropOperation == 3) {
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        } else if (tempACMElement.priority < currentConfig.mediator.priority && currentConfig.config.dropOperation == tempDTConfig.dropOperation) {
            currentConfig.mediator = tempACMElement;
            currentConfig.config = tempDTConfig;
        }
        return currentConfig;
    }

    protected int findSmallestStartOffset(IPageDataNode[] dropObjects) {
        int startOffSet = 0;
        if (dropObjects != null) {
            int i = 0;
            while (i < dropObjects.length) {
                IDOMNode domNode;
                if (dropObjects[i] instanceof ISSEPageDataNode && (domNode = ((ISSEPageDataNode)dropObjects[i]).getDOMNode()) != null) {
                    startOffSet = i == 0 ? domNode.getStartOffset() : Math.min(startOffSet, domNode.getStartOffset());
                }
                ++i;
            }
        }
        return startOffSet;
    }

    public final boolean doDrop(DropTargetEvent event, IEditorPart editor) {
        DropHintDisplay.disposeHoverHelp();
        boolean ret = false;
        try {
            try {
                DropTargetDescription target = this.newDropTargetDescription(editor);
                List workUnits = PageDataViewPlugin.getDefault().getWorkUnits();
                if (workUnits == null) {
                    this.getDropTargetObject(event, editor, null);
                    workUnits = PageDataViewPlugin.getDefault().getWorkUnits();
                }
                if (workUnits != null) {
                    int i = 0;
                    while (i < workUnits.size()) {
                        short type;
                        WorkUnit oneUnit = (WorkUnit)workUnits.get(i);
                        if (oneUnit != null && oneUnit.isConfigured() && (type = oneUnit.getConfig().dropOperation) != 3) {
                            Range targetRange;
                            HTMLEditDomain activeDomain;
                            IPageDataNode[] dropObjects = oneUnit.getSubUnits();
                            DropActionConfig config = oneUnit.getMediator().getDropActionConfig(this, dropObjects, target, type);
                            ret = this.doDropAction(event, editor, config, type);
                            if (workUnits.size() > 1 && i < workUnits.size() - 1 && (activeDomain = AbstractDropAction.getActiveHTMLEditDomain()) != null && (targetRange = target.getRange()) != null) {
                                activeDomain.getSelectionMediator().setRange(targetRange);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                String pluginID = PageDataViewPlugin.getDefault().getBundle().getSymbolicName();
                IStatus statusObj = null;
                if (e instanceof CoreException) {
                    statusObj = ((CoreException)((Object)e)).getStatus();
                } else {
                    Throwable cause = null;
                    cause = e.getCause() != null ? e.getCause() : e;
                    String message = ResourceHandler.ExceptionWhileHandlingPDVDropAction;
                    if (cause instanceof NoGeneratorFoundException) {
                        message = ResourceHandler.CouldNotFindCodeGenerator;
                    } else if (cause instanceof NoAdapterFoundException) {
                        message = ResourceHandler.CouldNotFindAdapter;
                    }
                    statusObj = new Status(4, pluginID, 4, message, cause);
                }
                Status originalStatus = new Status(4, pluginID, 4, ResourceHandler.PageDataViewDropActionWasUnsuccessful, (Throwable)e);
                PageDataViewPlugin.getDefault().getLog().log((IStatus)originalStatus);
                ErrorDialog.openError((Shell)editor.getSite().getShell(), (String)ResourceHandler.Error, (String)ResourceHandler.PageDataViewDropActionWasUnsuccessful, (IStatus)statusObj);
                PageDataViewPlugin.getDefault().setWorkUnits(null);
                ret = false;
            }
        }
        finally {
            PageDataViewPlugin.getDefault().setWorkUnits(null);
            ret = false;
        }
        return ret;
    }

    private DropTargetDescription newDropTargetDescription(IEditorPart editor) throws DOMException {
        DropTargetDescription target = new DropTargetDescription();
        Range range = this.getTargetRange(editor);
        if (range != null) {
            target.setTargetNode(range.getStartContainer());
        } else {
            target.setTargetNode(this.getTargetNodeList(editor).item(0));
        }
        target.setRange(range);
        target.setVisualRange(this.getTargetVisualRange(editor));
        return target;
    }

    protected void populateAttributes(Map valueMap, Node targetNode) {
        CompoundHTMLCommand cmd = new CompoundHTMLCommand("Change attr");
        NamedNodeMap attributes = targetNode.getAttributes();
        if (attributes != null && valueMap != null && valueMap.size() > 0) {
            Set keys = valueMap.keySet();
            String[] keyArray = keys.toArray(new String[0]);
            int i = 0;
            while (i < keyArray.length) {
                Object value = valueMap.get(keyArray[i]);
                cmd.append((HTMLCommand)new ChangeAttributeCommand("Attr Value", (Element)targetNode, keyArray[i], (String)value));
                ++i;
            }
        }
        if (!cmd.isEmpty()) {
            cmd.execute();
        }
    }

    protected final DropHint getDropHint(WorkUnit workUnit, DropTargetDescription target, short type) {
        IPageDataNode[] dropData = workUnit.getSubUnits();
        IDropActionMediator mediator = workUnit.getMediator();
        DropHint hint = null;
        if (type == 2) {
            hint = mediator.getDropHint(this, dropData, target, type);
        } else if (type == 1) {
            hint = mediator.getDropHint(this, dropData, null, type);
        }
        return hint;
    }

    protected boolean doDropAction(DropTargetEvent event, IEditorPart editor, DropActionConfig config, short type) {
        if (type == 2) {
            Node targetNode = null;
            NodeList targetNodeList = this.getTargetNodeList(editor);
            if (targetNodeList != null) {
                targetNode = this.getTargetNodeList(editor).item(0);
            }
            if (targetNode == null) {
                targetNode = this.getTargetRange(editor).getStartContainer();
            }
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_BEFORE_ACTION);
            this.populateAttributes(config.getValueMap(), targetNode);
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_AFTER_ACTION);
        } else if (type == 1) {
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_BEFORE_ACTION);
            DropActionHelper.executeCommand(config, DropActionConfig.COMMAND_AFTER_ACTION);
        } else {
            return false;
        }
        return true;
    }

    protected abstract IPageDataNode[] getDropObjectFromTransfer(TransferData var1);

    protected IBindingAttribute getBindingAttribute(IPageDataNode object) {
        Object binding = object.getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (binding != null) {
            return (IBindingAttribute)binding;
        }
        return null;
    }

    protected Collection splitDataComponents(IPageDataNode[] dropObjects) {
        return DropActionHelper.splitDataComponents(dropObjects);
    }

    private class ConfigUnit {
        DropActionMediatorElement mediator;
        DropTargetConfig config;

        private ConfigUnit() {
        }
    }
}

