/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataChangeListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.RootPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.data.IBindingPreviewer;
import com.ibm.etools.webtools.pagedataview.ui.ELEditorControl;
import com.ibm.etools.webtools.pagedataview.ui.PropertiesFileReader;
import com.ibm.etools.webtools.pagedataview.ui.StringResourceControl;
import com.ibm.etools.webtools.pagedataview.ui.internal.BeanPropertySelection;
import com.ibm.etools.webtools.pagedataview.ui.internal.NewPageDataAction;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageTypeHelper;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class SelectPageDataDialog
extends Dialog
implements Listener {
    public static final String DEFAULT_EL_VALUE_PREFIX = "#{";
    private String fELValuePrefix = "#{";
    private String fELValueSuffix = "}";
    private String dialogTitle = ResourceHandler.UI_PD_Title;
    private String emptyListMessage = ResourceHandler.UI_No_Selections;
    private static final String LABEL_PROPERTIES = ResourceHandler.UI_PD_DataObj;
    private static final String LABEL_PROPERTYNAME = ResourceHandler.UI_PD_PropName;
    private static final String LABEL_PROPERTYTYPE = ResourceHandler.UI_PD_Type;
    private static final String LABEL_RUNTIMETYPE = ResourceHandler.UI_PD_RtType;
    private static final String LABEL_REFERENCE_STRING = ResourceHandler.UI_PD_RefStr;
    private static final String LABEL_DATAOBJECTS_SERVER = ResourceHandler.UI_Data_Objects_ServerSide;
    private static final String LABEL_DATAOBJECTS_CLIENT = ResourceHandler.UI_Data_Objects_ClientSide;
    private static final String LABEL_DATAOBJECTS_ALL = ResourceHandler.UI_Data_Objects_All;
    public static final int DATAOBJECTTAB = 0;
    public static final int EXPRESSIONTAB = 1;
    public static final int STRRESOURCETAB = 2;
    private Tree propertiesTree;
    private Text propertyNameText;
    private Text propertyTypeText;
    private Text referenceStringText;
    private Text runtimeTypeText;
    private Label errorMessage;
    private TabFolder folder = null;
    private ELEditorControl elControl = null;
    private StringResourceControl stringControl = null;
    private String propertyName = null;
    private String propertyType = null;
    private String referenceString = null;
    private String runtimeType = null;
    private BeanPropertySelection bps;
    private IPageDataModel model;
    private IPageDataNode selectedNode;
    private String elEditorResult = null;
    private String stringResourceId = null;
    private int selectedTab = 0;
    private TabItem item1 = null;
    private TabItem item2 = null;
    private TabItem item3 = null;
    private StackLayout stack = null;
    private Composite leftParent = null;
    private Composite stackableParent = null;
    private boolean showTabs = false;
    private String currentValue = null;
    protected String title;
    private String[] dataCategories;
    private boolean bindToList = false;
    private IBindingPreviewer bindingPreviewer = null;

    public SelectPageDataDialog(Shell parentShell, IPageDataModel model) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.model = model;
        this.title = this.dialogTitle;
    }

    public SelectPageDataDialog(Shell parentShell, IPageDataModel model, String[] categories) {
        this(parentShell, model);
        this.dataCategories = categories;
    }

    public SelectPageDataDialog(Shell parentShell, IPageDataModel model, String[] categories, boolean showTabs) {
        this(parentShell, model, categories);
        this.showTabs = showTabs;
    }

    public SelectPageDataDialog(Shell parentShell, IPageDataModel model, String[] categories, boolean showTabs, String currValue) {
        this(parentShell, model, categories);
        this.showTabs = showTabs;
        this.currentValue = currValue;
    }

    protected Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.showTabs) {
            super.createButtonsForButtonBar(parent);
        } else {
            ((GridLayout)parent.getLayout()).numColumns = 2;
            ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
            ((GridData)parent.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)parent.getLayoutData()).horizontalAlignment = 4;
            this.stackableParent = new Composite(parent, 0);
            this.stack = new StackLayout();
            this.stack.marginHeight = 0;
            this.stack.marginWidth = 0;
            this.stack.topControl = null;
            this.stackableParent.setLayout((Layout)this.stack);
            this.stackableParent.setLayoutData((Object)new GridData(36));
            this.leftParent = new Composite(this.stackableParent, 0);
            GridLayout leftLayout = new GridLayout();
            leftLayout.makeColumnsEqualWidth = true;
            leftLayout.numColumns = 3;
            leftLayout.marginHeight = 0;
            leftLayout.marginWidth = 0;
            leftLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            leftLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            this.leftParent.setLayoutData((Object)new GridData(36));
            this.leftParent.setLayout((Layout)leftLayout);
            this.stringControl.createButtonBar(this.leftParent);
            Composite rightParent = new Composite(parent, 0);
            GridLayout rightLayout = new GridLayout();
            rightLayout.numColumns = 0;
            rightLayout.makeColumnsEqualWidth = true;
            rightLayout.marginWidth = 0;
            rightLayout.marginHeight = 0;
            rightLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            rightLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            rightParent.setLayout((Layout)rightLayout);
            GridData data = new GridData(644);
            rightParent.setLayoutData((Object)data);
            rightParent.setFont(parent.getFont());
            super.createButtonsForButtonBar(rightParent);
            if (this.getSelectedTab() == 0 && ((ITreeContentProvider)this.bps.getTreeViewer().getContentProvider()).getElements((Object)this.model).length == 0) {
                this.errorMessage.setText(this.emptyListMessage);
                this.getButton(0).setEnabled(false);
            }
            if (this.elControl != null) {
                this.elControl.setOkButton(this.getButton(0));
            }
            if (this.stringControl != null) {
                this.stringControl.setOkButton(this.getButton(0));
            }
            this.stackableParent.layout();
        }
    }

    private void createNewDataButton(Composite parent) {
        Button newDataButton = new Button(parent, 8);
        newDataButton.setText(ResourceHandler.SelectPageDataDialog_3);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        newDataButton.setLayoutData((Object)gridData);
        newDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewPageDataAction newPageDataAction = new NewPageDataAction(new PageTypeHelper(SelectPageDataDialog.this.model));
                if (SelectPageDataDialog.this.selectedNode != null) {
                    newPageDataAction.setSelectionHint(SelectPageDataDialog.this.selectedNode);
                }
                newPageDataAction.run();
            }
        });
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.currentValue != null) {
            this.setDefaultSelection();
        }
        if (this.showTabs) {
            this.refreshButtonBar();
        }
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        int numBaseCols = 5;
        Composite composite = null;
        if (this.showTabs) {
            this.folder = new TabFolder(parent, 128);
            this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelectPageDataDialog.this.refreshButtonBar();
                }
            });
            this.folder.setLayoutData((Object)new GridData(1808));
            this.item1 = new TabItem(this.folder, 0, 0);
            composite = this.createBaseComposite((Composite)this.folder, numBaseCols, false);
            this.item1.setControl((Control)composite);
            this.item1.setText(ResourceHandler.SelectPageDataDialog_0);
        } else {
            composite = this.createBaseComposite(parent, numBaseCols, false);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.webedit.editor.ins0360");
        Label label = new Label(composite, 0);
        label.setText(LABEL_PROPERTIES);
        GridData gridData = new GridData();
        gridData.horizontalSpan = this.dataCategories != null && this.dataCategories.length > 1 ? 1 : numBaseCols;
        label.setLayoutData((Object)gridData);
        if (this.dataCategories != null && this.dataCategories.length > 1) {
            Button allRadioButton = new Button(composite, 16);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            allRadioButton.setLayoutData((Object)gridData);
            allRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button && ((Button)e.widget).getSelection()) {
                        SelectPageDataDialog.this.refreshTree(new String[]{"Server Side", "Client Side", "Scripting"});
                    }
                }
            });
            allRadioButton.setText(LABEL_DATAOBJECTS_ALL);
            allRadioButton.setSelection(true);
            Button serverRadioButton = new Button(composite, 16);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            serverRadioButton.setLayoutData((Object)gridData);
            serverRadioButton.setText(LABEL_DATAOBJECTS_SERVER);
            serverRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button && ((Button)e.widget).getSelection()) {
                        SelectPageDataDialog.this.refreshTree(new String[]{"Server Side", "Scripting"});
                    }
                }
            });
            Button clientRadioButton = new Button(composite, 16);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            clientRadioButton.setLayoutData((Object)gridData);
            clientRadioButton.setText(LABEL_DATAOBJECTS_CLIENT);
            clientRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button && ((Button)e.widget).getSelection()) {
                        SelectPageDataDialog.this.refreshTree(new String[]{"Client Side"});
                    }
                }
            });
            if (!this.clientDataIsPresent()) {
                allRadioButton.setVisible(false);
                serverRadioButton.setVisible(false);
                clientRadioButton.setVisible(false);
            }
        }
        this.createNewDataButton(composite);
        this.bps = new BeanPropertySelection(composite, this.model, this.dataCategories);
        this.propertiesTree = this.bps.getTree();
        if (this.showTabs) {
            this.item2 = new TabItem(this.folder, 0, 1);
            this.item2.setText(ResourceHandler.SelectPageDataDialog_1);
            this.elControl = new ELEditorControl((Composite)this.item2.getParent(), this.model, this.bindingPreviewer);
            this.item2.setControl((Control)this.elControl.getComposite());
            this.item3 = new TabItem(this.folder, 0, 2);
            this.item3.setText(ResourceHandler.SelectPageDataDialog_2);
            this.stringControl = this.getStringResourceControl((Composite)this.item3.getParent());
            this.item3.setControl((Control)this.stringControl.getComposite());
        }
        gridData = (GridData)this.propertiesTree.getLayoutData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = numBaseCols;
        gridData.heightHint = 100;
        this.propertiesTree.setLayoutData((Object)gridData);
        this.bps.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectPageDataDialog.this.treeItemSelected(event);
            }
        });
        this.bps.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectPageDataDialog.this.treeDoubleClicked(event);
            }
        });
        this.bps.getTree().setFocus();
        this.model.getPageDataNotifier().addPageDataChangedListener((IPageDataChangeListener)this.bps);
        label = new Label(composite, 0);
        label.setText(LABEL_PROPERTYNAME);
        this.propertyNameText = new Text(composite, 2048);
        this.propertyNameText.setEditable(false);
        gridData = new GridData();
        gridData.horizontalSpan = numBaseCols - 1;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = this.convertHorizontalDLUsToPixels(160);
        this.propertyNameText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(LABEL_PROPERTYTYPE);
        this.propertyTypeText = new Text(composite, 2048);
        this.propertyTypeText.setEditable(false);
        gridData = new GridData();
        gridData.horizontalSpan = numBaseCols - 1;
        gridData.horizontalAlignment = 4;
        this.propertyTypeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(LABEL_REFERENCE_STRING);
        this.referenceStringText = new Text(composite, 2048);
        this.referenceStringText.setEditable(false);
        gridData = new GridData();
        gridData.horizontalSpan = numBaseCols - 1;
        gridData.horizontalAlignment = 4;
        this.referenceStringText.setLayoutData((Object)gridData);
        this.referenceStringText.addListener(24, (Listener)this);
        label = new Label(composite, 0);
        label.setText(LABEL_RUNTIMETYPE);
        this.runtimeTypeText = new Text(composite, 2048);
        this.runtimeTypeText.setEditable(false);
        gridData = new GridData();
        gridData.horizontalSpan = numBaseCols - 1;
        gridData.horizontalAlignment = 4;
        this.runtimeTypeText.setLayoutData((Object)gridData);
        this.errorMessage = new Label(composite, 0);
        GridData data = new GridData(256);
        data.horizontalSpan = numBaseCols;
        this.errorMessage.setLayoutData((Object)data);
        this.errorMessage.setForeground(ColorConstants.red);
        this.getShell().setText(this.title);
        return composite;
    }

    private boolean clientDataIsPresent() {
        boolean hasClientData = false;
        EList children = this.model.getRoot().getChildrenByDataCatagory("Client Side");
        if (!children.isEmpty()) {
            hasClientData = true;
        }
        return hasClientData;
    }

    void treeItemSelected(SelectionChangedEvent e) {
        IStructuredSelection selection = (IStructuredSelection)e.getSelection();
        this.selectedNode = (IPageDataNode)selection.getFirstElement();
        this.treeItemSelected();
    }

    void treeDoubleClicked(DoubleClickEvent e) {
        IStructuredSelection selection = (IStructuredSelection)e.getSelection();
        this.selectedNode = (IPageDataNode)selection.getFirstElement();
        this.treeItemSelected();
        this.okPressed();
    }

    private void treeItemSelected() {
        Object adapter = null;
        if (this.selectedNode != null) {
            adapter = this.selectedNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        }
        if (adapter != null && adapter instanceof IBindingAttribute) {
            IBindingAttribute binding = (IBindingAttribute)adapter;
            if (binding == null) {
                PageDataViewPlugin.getDefault().write("Binding attribute on " + this.selectedNode.toString() + " is null");
            }
            this.propertyName = binding.getName(this.selectedNode);
            this.propertyNameText.setText(this.getPropertyName());
            this.propertyType = binding.getTypeAsString(this.selectedNode);
            this.propertyTypeText.setText(this.getPropertyType() == null ? "" : this.propertyType);
            this.runtimeType = binding.getRuntimeType(this.selectedNode);
            this.runtimeTypeText.setText(this.getRuntimeType() == null ? "" : this.runtimeType);
            if (this.bindingPreviewer != null) {
                this.referenceString = this.bindingPreviewer.getBindingPreview(this.selectedNode);
                if (this.referenceString == null || "".equals(this.referenceString)) {
                    this.referenceString = binding.getReferenceString(this.selectedNode);
                }
            } else {
                this.referenceString = binding.getReferenceString(this.selectedNode);
            }
            if (this.bindToList && this.referenceString != null && this.referenceString.endsWith("[0]")) {
                this.referenceString = this.referenceString.substring(0, this.referenceString.lastIndexOf("[0]"));
            }
            if (this.referenceString != null && !this.referenceString.equals("")) {
                this.referenceString = String.valueOf(this.getELValuePrefix()) + this.referenceString + this.getELValueSuffix();
            }
            this.referenceStringText.setText(this.getReferenceString());
        } else {
            this.propertyName = null;
            this.propertyNameText.setText(this.propertyName == null ? "" : this.propertyName);
            this.propertyType = null;
            this.propertyTypeText.setText(this.propertyType == null ? "" : this.propertyType);
            this.runtimeType = null;
            this.runtimeTypeText.setText(this.runtimeType == null ? "" : this.runtimeType);
            this.referenceString = null;
            this.referenceStringText.setText(this.referenceString == null ? "" : this.referenceString);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.referenceStringText) {
            this.handleReferenceStringModified();
        }
    }

    protected void handleReferenceStringModified() {
        this.referenceString = this.referenceStringText.getText();
        String nullRef = String.valueOf(this.getELValuePrefix()) + null + this.getELValueSuffix();
        if (this.selectedNode == null) {
            this.errorMessage.setText(this.emptyListMessage);
            this.getButton(0).setEnabled(false);
        } else if (this.referenceString == null || this.referenceString.equals("") || this.referenceString.equals(nullRef)) {
            this.errorMessage.setText(ResourceHandler._E_RefNull);
            this.getButton(0).setEnabled(false);
        } else {
            this.errorMessage.setText("");
            this.getButton(0).setEnabled(true);
        }
    }

    private void refreshTree(String[] dataCategories) {
        this.bps.setDataCategories(dataCategories);
        this.bps.refreshTree();
        this.handleReferenceStringModified();
    }

    protected void okPressed() {
        if (this.showTabs) {
            this.elEditorResult = this.elControl.getExpression();
            this.selectedTab = this.folder.getSelectionIndex();
            this.stringResourceId = this.stringControl.getSelectedId();
        }
        super.okPressed();
    }

    public boolean close() {
        if (this.model != null && this.bps != null) {
            this.model.getPageDataNotifier().removePageDataChangedListener((IPageDataChangeListener)this.bps);
        }
        if (this.elControl != null) {
            this.elControl.dispose();
        }
        if (this.stringControl != null) {
            this.stringControl.dispose();
        }
        return super.close();
    }

    private void refreshButtonBar() {
        int n = this.selectedTab = this.folder.getSelectionIndex() < 0 || this.folder.getSelectionIndex() > 2 ? 0 : this.folder.getSelectionIndex();
        if (this.stack == null) {
            return;
        }
        this.stack.topControl = this.folder.getSelectionIndex() == 2 ? this.leftParent : null;
        this.stackableParent.layout();
    }

    private void setDefaultSelection() {
        if (this.showTabs && this.currentValue.indexOf(" lt ") != -1 || this.currentValue.indexOf(" < ") != -1 || this.currentValue.indexOf(" le ") != -1 || this.currentValue.indexOf(" <= ") != -1 || this.currentValue.indexOf(" not ") != -1 || this.currentValue.indexOf(" !") != -1 || this.currentValue.indexOf(" eq ") != -1 || this.currentValue.indexOf(" == ") != -1 || this.currentValue.indexOf(" ne ") != -1 || this.currentValue.indexOf(" != ") != -1 || this.currentValue.indexOf(" div ") != -1 || this.currentValue.indexOf(" / ") != -1 || this.currentValue.indexOf(" or ") != -1 || this.currentValue.indexOf(" || ") != -1 || this.currentValue.indexOf(" and ") != -1 || this.currentValue.indexOf(" && ") != -1 || this.currentValue.indexOf(" gt ") != -1 || this.currentValue.indexOf(" > ") != -1 || this.currentValue.indexOf(" ge ") != -1 || this.currentValue.indexOf(" >= ") != -1 || this.currentValue.indexOf(" mod ") != -1 || this.currentValue.indexOf(" % ") != -1 || this.currentValue.indexOf(" empty ") != -1 || this.currentValue.indexOf(" empty ") != -1) {
            this.folder.setSelection(1);
            if (this.elControl != null) {
                this.elControl.setElExpression(this.currentValue);
            }
        } else {
            String propertiesFileName = this.getStringResourceFileName(this.currentValue);
            if (propertiesFileName != null && this.showTabs) {
                this.folder.setSelection(2);
                int start = this.currentValue.lastIndexOf(46);
                int end = this.currentValue.length();
                if (start != -1 && end != -1) {
                    String propId = this.currentValue.substring(start + 1, end - 1);
                    this.stringControl.setSelection(propertiesFileName, propId);
                }
            } else {
                EList componentChildren = this.model.getRoot().getChildren();
                String deVBLCurrentValue = this.currentValue;
                int start = deVBLCurrentValue.indexOf(this.fELValuePrefix);
                int end = deVBLCurrentValue.indexOf(this.fELValueSuffix);
                if (start != -1 && end != -1) {
                    deVBLCurrentValue = deVBLCurrentValue.substring(start + this.fELValuePrefix.length(), end + this.fELValueSuffix.length() - 1);
                }
                if (deVBLCurrentValue != null && !deVBLCurrentValue.equals("")) {
                    this.findAndSelectPageDataNode(deVBLCurrentValue, (List)componentChildren);
                }
            }
        }
    }

    private void findAndSelectPageDataNode(String deVBLCurrentValue, List componentChildren) {
        ArrayList queue = new ArrayList();
        queue.add(componentChildren);
        boolean found = false;
        block0: while (!found && !queue.isEmpty()) {
            List children = (List)queue.remove(0);
            for (Object object : children) {
                EList grandChildren;
                IPageDataNode pdnToSelect = (IPageDataNode)object;
                String bindingString = this.generateBindingString(pdnToSelect);
                int parentCount = 0;
                IPageDataNode parentPDN = pdnToSelect.getParent();
                IPageDataNode componentNode = pdnToSelect;
                while (parentPDN != null && !(parentPDN instanceof RootPageDataNode)) {
                    ++parentCount;
                    componentNode = parentPDN;
                    parentPDN = parentPDN.getParent();
                }
                if (parentCount > 10) {
                    found = true;
                    continue block0;
                }
                if (bindingString == null) continue;
                if (bindingString.equals(deVBLCurrentValue)) {
                    this.bps.getTreeViewer().expandToLevel((Object)componentNode, parentCount);
                    this.bps.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)pdnToSelect), true);
                    found = true;
                    continue block0;
                }
                String firstSegment = bindingString;
                int bindingStringFirstSegmentEnd = bindingString.indexOf(".");
                if (bindingStringFirstSegmentEnd != -1) {
                    firstSegment = bindingString.substring(0, bindingStringFirstSegmentEnd);
                }
                if (!deVBLCurrentValue.contains(firstSegment) || (grandChildren = pdnToSelect.getChildren()) == null || grandChildren.isEmpty()) continue;
                queue.add(grandChildren);
            }
        }
    }

    private String generateBindingString(IPageDataNode pdnToSelect) {
        String bindingString = null;
        IBindingAttribute binding = (IBindingAttribute)pdnToSelect.getAdapter(IBindingAttribute.class);
        if (binding != null) {
            bindingString = binding.getReferenceString(pdnToSelect);
        }
        return bindingString;
    }

    private String getStringResourceFileName(String val) {
        PropertiesFileReader reader;
        HashMap files;
        String fileName = null;
        if (this.stringControl != null && this.stringControl.getPropsReader() != null && (files = (reader = this.stringControl.getPropsReader()).getPropertiesFiles(false)) != null) {
            for (String name : files.keySet()) {
                String var = reader.getVar(name);
                if (name == null || var == null || !this.currentValue.startsWith(String.valueOf(this.fELValuePrefix) + var)) continue;
                fileName = name;
                break;
            }
        }
        return fileName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getReferenceString() {
        return this.referenceString;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public IPageDataNode getSelectedNode() {
        return this.selectedNode;
    }

    private String getELValueSuffix() {
        return this.fELValueSuffix;
    }

    public String getELValuePrefix() {
        return this.fELValuePrefix;
    }

    public void setELValuePrefix(String valuePrefix) {
        this.fELValuePrefix = valuePrefix;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getEmptyListMessage() {
        return this.emptyListMessage;
    }

    public void setEmptyListMessage(String emptyListMessage) {
        this.emptyListMessage = emptyListMessage;
    }

    public void setBindToList(boolean bindToList) {
        this.bindToList = bindToList;
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public String getElEditorResult() {
        return this.elEditorResult;
    }

    public void setElEditorResult(String elEditorResult) {
        this.elEditorResult = elEditorResult;
    }

    public String getStringResourceId() {
        return this.stringResourceId;
    }

    protected StringResourceControl getStringResourceControl(Composite parent) {
        return new StringResourceControl(parent);
    }

    public void setBindingPreviewer(IBindingPreviewer bindingPreviewer) {
        this.bindingPreviewer = bindingPreviewer;
    }
}

