/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryDefinition;
import com.ibm.etools.webtools.pagedataview.ui.categories.internal.CategoryRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewSorter;
import com.ibm.etools.webtools.pagedataview.ui.internal.SingleObjectStructuredSelection;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewPageDataDialog
extends SelectionDialog {
    private String title = ResourceHandler.UI_Dlg_NewData;
    private String message = ResourceHandler.UI_Dlg_NewData_Msg;
    private HashMap actions = new HashMap();
    private TreeViewer treeViewer;
    private IPageDataNode selectionHint;

    public NewPageDataDialog(Shell parentShell, List visibleActions) {
        super(parentShell);
        this.parseVisibleActions(visibleActions);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        area.setLayout((Layout)layout);
        Label label1 = new Label(area, 0);
        label1.setText(this.message);
        this.treeViewer = new TreeViewer(area, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new NewPageDataContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new NewPageDataLabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new PageDataViewSorter());
        this.treeViewer.setInput((Object)this.actions);
        this.treeViewer.expandToLevel(2);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewPageDataDialog.this.treeItemSelected(event);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewPageDataDialog.this.treeDoubleClicked(event);
            }
        });
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.getShell().setText(this.title);
        NewPageDataDialog.applyDialogFont((Control)area);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)area, "com.ibm.etools.webtools.pagedataview.NewPageDataDialog");
        return area;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.selectionHint != null) {
            this.processInitialSelection();
        }
        return contents;
    }

    private void processInitialSelection() {
        String categoryToSelect = this.selectionHint.getCategory();
        if (categoryToSelect != null) {
            boolean selectionMade = false;
            Iterator categoryIDs = this.actions.keySet().iterator();
            while (categoryIDs.hasNext()) {
                CategoryDefinition cd = CategoryRegistryReader.getSingleton().getCategory((String)categoryIDs.next());
                if (!categoryToSelect.equals(cd.getCategoryID())) continue;
                String contextNodeName = this.selectionHint.getClass().getName();
                List actionElements = (List)this.actions.get(cd.getCategoryID());
                int i = 0;
                while (i < actionElements.size()) {
                    String nodeName = ((IConfigurationElement)actionElements.get(i)).getAttribute("contextNode");
                    if (nodeName != null && nodeName.equals(contextNodeName)) {
                        this.treeViewer.setSelection((ISelection)new SingleObjectStructuredSelection(actionElements.get(i)));
                        selectionMade = true;
                        break;
                    }
                    ++i;
                }
                if (selectionMade) continue;
                this.treeViewer.setSelection((ISelection)new SingleObjectStructuredSelection(cd));
            }
        }
    }

    public void setSelectionHint(IPageDataNode selectionHint) {
        this.selectionHint = selectionHint;
    }

    protected void treeDoubleClicked(DoubleClickEvent event) {
        Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selectedObject instanceof IConfigurationElement) {
            this.okPressed();
        }
    }

    protected void treeItemSelected(SelectionChangedEvent event) {
        Object selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selectedObject instanceof CategoryDefinition) {
            this.getOkButton().setEnabled(false);
        } else if (selectedObject instanceof IConfigurationElement) {
            this.getOkButton().setEnabled(true);
        }
    }

    protected void okPressed() {
        this.setResult(((IStructuredSelection)this.treeViewer.getSelection()).toList());
        super.okPressed();
    }

    private void parseVisibleActions(List visibleActions) {
        int i = 0;
        while (i < visibleActions.size()) {
            IConfigurationElement actionElement = (IConfigurationElement)visibleActions.get(i);
            String category = actionElement.getAttribute("category");
            if (category == null || category.equals("")) {
                category = "Other";
            }
            if (this.actions.get(category) == null) {
                ArrayList<IConfigurationElement> catList = new ArrayList<IConfigurationElement>();
                catList.add(actionElement);
                this.actions.put(category, catList);
            } else {
                ((List)this.actions.get(category)).add(actionElement);
            }
            ++i;
        }
    }

    private class NewPageDataContentProvider
    implements ITreeContentProvider {
        private NewPageDataContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IConfigurationElement) {
                return null;
            }
            if (parentElement instanceof CategoryDefinition) {
                CategoryDefinition cd = (CategoryDefinition)parentElement;
                List actions = this.findActionsInCategory(cd);
                if (actions != null) {
                    return actions.toArray();
                }
                return null;
            }
            return null;
        }

        private List findActionsInCategory(CategoryDefinition category) {
            List<CategoryDefinition> subCategories;
            ArrayList allActions = new ArrayList();
            List actionElements = (List)NewPageDataDialog.this.actions.get(category.getCategoryID());
            if (actionElements != null) {
                allActions.addAll(actionElements);
            }
            if ((subCategories = category.getChildren()) != null) {
                for (CategoryDefinition subCat : subCategories) {
                    allActions.addAll(this.findActionsInCategory(subCat));
                }
            }
            return allActions;
        }

        public Object getParent(Object element) {
            if (element instanceof CategoryDefinition) {
                return null;
            }
            if (element instanceof IConfigurationElement) {
                String category = ((IConfigurationElement)element).getAttribute("category");
                if (category == null) {
                    category = "Other";
                }
                return CategoryRegistryReader.getSingleton().getCategory(category);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof CategoryDefinition;
        }

        public Object[] getElements(Object inputElement) {
            Iterator categoryIDs = NewPageDataDialog.this.actions.keySet().iterator();
            ArrayList<CategoryDefinition> categories = new ArrayList<CategoryDefinition>();
            while (categoryIDs.hasNext()) {
                CategoryDefinition cd = CategoryRegistryReader.getSingleton().getCategory((String)categoryIDs.next());
                if (cd.getParentID() == null) {
                    categories.add(cd);
                    continue;
                }
                boolean foundRoot = false;
                CategoryDefinition root = CategoryRegistryReader.getSingleton().getCategory(cd.getParentID());
                while (!foundRoot) {
                    if (root.getParentID() == null) {
                        foundRoot = true;
                        if (categories.contains(root)) continue;
                        categories.add(root);
                        continue;
                    }
                    root = CategoryRegistryReader.getSingleton().getCategory(root.getParentID());
                }
            }
            return categories.toArray();
        }

        public void dispose() {
            NewPageDataDialog.this.actions = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class NewPageDataLabelProvider
    extends LabelProvider {
        private Map images = new HashMap();

        private NewPageDataLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CategoryDefinition) {
                CategoryDefinition cd = (CategoryDefinition)element;
                Image categoryImage = (Image)this.images.get(cd.getIconFilePath());
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)cd.getExtendingPluginID(), (String)cd.getIconFilePath());
                if (categoryImage == null) {
                    try {
                        if (imageDescriptor == null && cd.getIconFilePath() != null && cd.getIconFilePath() != "") {
                            throw new Exception("Icon: " + cd.getIconFilePath() + " not found.");
                        }
                        if (cd.getIconFilePath().equals("") || cd.getIconFilePath() == null) {
                            categoryImage = PageDataViewPlugin.getDefault().getImage("full/obj16/fldr_obj");
                        } else {
                            categoryImage = imageDescriptor.createImage();
                            this.images.put(cd.getIconFilePath(), categoryImage);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return categoryImage;
            }
            if (element instanceof IConfigurationElement) {
                IConfigurationElement actionElement = (IConfigurationElement)element;
                String iconName = actionElement.getAttribute("icon");
                try {
                    if (iconName == null) {
                        throw new Exception("Icon for " + actionElement.getAttribute("id") + " not specified.");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                IExtension extension = actionElement.getDeclaringExtension();
                String extendingPluginId = extension.getNamespaceIdentifier();
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconName);
                try {
                    if (imageDescriptor == null) {
                        throw new Exception("Icon: " + iconName + " not found.");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                Image actionImage = imageDescriptor.createImage();
                this.images.put(iconName, actionImage);
                return actionImage;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CategoryDefinition) {
                CategoryDefinition cd = (CategoryDefinition)element;
                return cd.getName();
            }
            if (element instanceof IConfigurationElement) {
                return ((IConfigurationElement)element).getAttribute("label");
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            Collection collection = this.images.values();
            if (collection != null) {
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    ((Image)iter.next()).dispose();
                }
            }
            this.images = null;
        }
    }
}

