/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedataview.data.IBindingPreviewer;
import com.ibm.etools.webtools.pagedataview.ui.AddConditionDialog;
import com.ibm.etools.webtools.pagedataview.ui.AddEitherOrDialog;
import com.ibm.etools.webtools.pagedataview.ui.AddVariableDialog;
import com.ibm.etools.webtools.pagedataview.ui.nls.ResourceHandler;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ELEditorControl {
    private Composite thisControl = null;
    private IPageDataModel model = null;
    private Text expression = null;
    private static final int VAR = 0;
    private static final int CON = 1;
    private static final int EOR = 2;
    private boolean isXML = true;
    private Button okButton = null;
    private IBindingPreviewer bindingPreviewer = null;

    public ELEditorControl(Composite parent, IPageDataModel model) {
        this.model = model;
        this.createContents(parent);
    }

    public ELEditorControl(Composite parent, IPageDataModel model, IBindingPreviewer bindingPreviewer) {
        this.model = model;
        this.bindingPreviewer = bindingPreviewer;
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.thisControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.thisControl.setLayout((Layout)layout);
        this.thisControl.setLayoutData((Object)data);
        Label expressionLabel = new Label(this.thisControl, 0);
        expressionLabel.setText(ResourceHandler.ELEditorControl_0);
        this.expression = new Text(this.thisControl, 2626);
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ELEditorControl.this.enableOkButton();
            }
        });
        GridData expressionGridData = new GridData();
        expressionGridData.horizontalAlignment = 4;
        expressionGridData.grabExcessHorizontalSpace = true;
        expressionGridData.heightHint = 70;
        this.expression.setLayoutData((Object)expressionGridData);
        Composite buttonsParent = new Composite(this.thisControl, 0);
        GridLayout threeCols = new GridLayout();
        threeCols.numColumns = 3;
        threeCols.makeColumnsEqualWidth = true;
        GridData threeColsData = new GridData();
        threeColsData.grabExcessHorizontalSpace = true;
        threeColsData.horizontalAlignment = 4;
        buttonsParent.setLayout((Layout)threeCols);
        buttonsParent.setLayoutData((Object)threeColsData);
        String[] buttonLabels = new String[]{ResourceHandler.ELEditorControl_1, ResourceHandler.ELEditorControl_2, ResourceHandler.ELEditorControl_3};
        Display display = this.thisControl.getDisplay();
        Font font = this.thisControl.getFont();
        GC gc = new GC((Drawable)display);
        gc.setFont(font);
        int len = 0;
        int i = 0;
        while (i < buttonLabels.length) {
            Point p = gc.textExtent(buttonLabels[i]);
            len = len < p.x ? p.x : len;
            ++i;
        }
        gc.dispose();
        Button addVar = new Button(buttonsParent, 8);
        addVar.setText(ResourceHandler.ELEditorControl_1);
        addVar.setLayoutData((Object)this.createButtonData(len += 20));
        addVar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.launchDialog(0);
            }
        });
        Button addCondition = new Button(buttonsParent, 8);
        addCondition.setText(ResourceHandler.ELEditorControl_2);
        addCondition.setLayoutData((Object)this.createButtonData(len));
        addCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.launchDialog(1);
            }
        });
        Button addExp = new Button(buttonsParent, 8);
        addExp.setText(ResourceHandler.ELEditorControl_3);
        addExp.setLayoutData((Object)this.createButtonData(len));
        addExp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.launchDialog(2);
            }
        });
        Label separator = new Label(this.thisControl, 258);
        separator.setLayoutData((Object)new GridData(768));
        Composite fiveCols = new Composite(this.thisControl, 0);
        GridLayout fiveColsLayout = new GridLayout();
        fiveColsLayout.numColumns = 5;
        fiveColsLayout.horizontalSpacing = 8;
        fiveCols.setLayout((Layout)fiveColsLayout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 1;
        fiveCols.setLayoutData((Object)gd);
        Label operators = new Label(fiveCols, 0);
        operators.setText(ResourceHandler.ELEditorControl_7);
        Composite twoButtons1 = new Composite(fiveCols, 0);
        GridLayout twoB1Layout = new GridLayout();
        twoB1Layout.numColumns = 2;
        twoB1Layout.marginWidth = 0;
        twoB1Layout.horizontalSpacing = 2;
        twoButtons1.setLayout((Layout)twoB1Layout);
        twoButtons1.setLayoutData((Object)this.createGridData());
        Button and = new Button(twoButtons1, 8);
        Button or = new Button(twoButtons1, 8);
        and.setText(ResourceHandler.ELEditorControl_8);
        and.setLayoutData((Object)this.createButtonData(29));
        and.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " && " : " and ");
            }
        });
        and.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_28;
                }
            }
        });
        or.setText(ResourceHandler.ELEditorControl_9);
        or.setLayoutData((Object)this.createButtonData(29));
        or.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " || " : " or ");
            }
        });
        or.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_29;
                }
            }
        });
        Composite twoButtons2 = new Composite(fiveCols, 0);
        GridLayout twoB2Layout = new GridLayout();
        twoB2Layout.numColumns = 2;
        twoB2Layout.horizontalSpacing = 2;
        twoB2Layout.marginWidth = 0;
        twoButtons2.setLayout((Layout)twoB2Layout);
        twoButtons2.setLayoutData((Object)this.createGridData());
        Button not = new Button(twoButtons2, 8);
        Button emp = new Button(twoButtons2, 8);
        not.setText(ResourceHandler.ELEditorControl_10);
        not.setLayoutData((Object)this.createButtonData(29));
        not.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " !" : " not ");
            }
        });
        not.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_30;
                }
            }
        });
        emp.setText(ResourceHandler.ELEditorControl_11);
        emp.setLayoutData((Object)this.createButtonData(29));
        emp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " empty " : " empty ");
            }
        });
        emp.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_31;
                }
            }
        });
        Composite sixButtons1 = new Composite(fiveCols, 0);
        GridLayout sixB1Layout = new GridLayout();
        sixB1Layout.numColumns = 6;
        sixB1Layout.horizontalSpacing = 2;
        sixB1Layout.marginWidth = 0;
        sixButtons1.setLayout((Layout)sixB1Layout);
        sixButtons1.setLayoutData((Object)this.createGridData());
        Button equal = new Button(sixButtons1, 8);
        Button notEqual = new Button(sixButtons1, 8);
        Button lt = new Button(sixButtons1, 8);
        Button lteq = new Button(sixButtons1, 8);
        Button gt = new Button(sixButtons1, 8);
        Button gteq = new Button(sixButtons1, 8);
        equal.setText(ResourceHandler.ELEditorControl_12);
        equal.setLayoutData((Object)this.createButtonData(29));
        equal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " == " : " eq ");
            }
        });
        equal.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.AddEitherOrDialog_5;
                }
            }
        });
        notEqual.setText(ResourceHandler.ELEditorControl_13);
        notEqual.setLayoutData((Object)this.createButtonData(29));
        notEqual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " != " : " ne ");
            }
        });
        notEqual.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.AddEitherOrDialog_7;
                }
            }
        });
        lt.setText(ResourceHandler.ELEditorControl_14);
        lt.setLayoutData((Object)this.createButtonData(29));
        lt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " < " : " lt ");
            }
        });
        lt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.AddEitherOrDialog_13;
                }
            }
        });
        lteq.setText(ResourceHandler.ELEditorControl_15);
        lteq.setLayoutData((Object)this.createButtonData(29));
        lteq.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " <= " : " le ");
            }
        });
        lteq.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.AddEitherOrDialog_15;
                }
            }
        });
        gt.setText(ResourceHandler.ELEditorControl_16);
        gt.setLayoutData((Object)this.createButtonData(29));
        gt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " > " : " gt ");
            }
        });
        gt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.AddEitherOrDialog_9;
                }
            }
        });
        gteq.setText(ResourceHandler.ELEditorControl_17);
        gteq.setLayoutData((Object)this.createButtonData(29));
        gteq.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(ELEditorControl.this.isXML ? " ge " : " >= ");
            }
        });
        gteq.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.AddEitherOrDialog_11;
                }
            }
        });
        Composite fiveButtons = new Composite(fiveCols, 0);
        GridLayout fiveBLayout = new GridLayout();
        fiveBLayout.numColumns = 5;
        fiveBLayout.horizontalSpacing = 2;
        fiveBLayout.marginWidth = 0;
        fiveButtons.setLayout((Layout)fiveBLayout);
        fiveButtons.setLayoutData((Object)this.createGridData());
        Button plus = new Button(fiveButtons, 8);
        Button minus = new Button(fiveButtons, 8);
        Button mult = new Button(fiveButtons, 8);
        Button div = new Button(fiveButtons, 8);
        Button mod = new Button(fiveButtons, 8);
        plus.setText(ResourceHandler.ELEditorControl_18);
        plus.setLayoutData((Object)this.createButtonData(29));
        plus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(" + ");
            }
        });
        plus.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_32;
                }
            }
        });
        minus.setText(ResourceHandler.ELEditorControl_19);
        minus.setLayoutData((Object)this.createButtonData(29));
        minus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(" - ");
            }
        });
        minus.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_33;
                }
            }
        });
        mult.setText(ResourceHandler.ELEditorControl_20);
        mult.setLayoutData((Object)this.createButtonData(29));
        mult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(" * ");
            }
        });
        mult.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_34;
                }
            }
        });
        div.setText(ResourceHandler.ELEditorControl_21);
        div.setLayoutData((Object)this.createButtonData(29));
        div.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " / " : " div ");
            }
        });
        div.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_35;
                }
            }
        });
        mod.setText(ResourceHandler.ELEditorControl_23);
        mod.setLayoutData((Object)this.createButtonData(29));
        mod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELEditorControl.this.editExpression(!ELEditorControl.this.isXML ? " % " : " mod ");
            }
        });
        mod.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = ResourceHandler.ELEditorControl_36;
                }
            }
        });
        Label syntaxLabel = new Label(fiveCols, 0);
        syntaxLabel.setText(ResourceHandler.ELEditorControl_24);
        Composite radioParent = new Composite(fiveCols, 0);
        GridLayout radioLayout = new GridLayout();
        radioLayout.horizontalSpacing = 4;
        radioLayout.makeColumnsEqualWidth = false;
        radioLayout.marginHeight = 0;
        radioLayout.marginWidth = 0;
        radioLayout.numColumns = 2;
        GridData radioData = new GridData();
        radioData.horizontalSpan = 4;
        radioData.horizontalAlignment = 32;
        radioParent.setLayout((Layout)radioLayout);
        radioParent.setLayoutData((Object)radioData);
        Button textual = new Button(radioParent, 16);
        textual.setText(ResourceHandler.ELEditorControl_26);
        textual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                if (b.getSelection()) {
                    ELEditorControl.this.xmlExpression(true);
                }
            }
        });
        Button symbolic = new Button(radioParent, 16);
        symbolic.setText(ResourceHandler.ELEditorControl_25);
        symbolic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                if (b.getSelection()) {
                    ELEditorControl.this.xmlExpression(false);
                }
            }
        });
        symbolic.setSelection(false);
        textual.setSelection(true);
    }

    private void launchDialog(int dlg) {
        int pos = this.expression.getCaretPosition();
        switch (dlg) {
            case 0: {
                AddVariableDialog addVar = new AddVariableDialog(this.expression.getParent().getShell(), this.model, this.bindingPreviewer);
                if (addVar.open() == 0) {
                    String ret = addVar.getVariable();
                    if (ret == null || ret.length() <= 0) break;
                    this.editExpression(ret);
                    break;
                }
                this.expression.setFocus();
                this.expression.setSelection(pos);
                break;
            }
            case 1: {
                AddConditionDialog addCon = new AddConditionDialog(this.expression.getParent().getShell(), this.model, this.isXML, this.bindingPreviewer);
                if (addCon.open() == 0) {
                    String ret = addCon.getCondition();
                    if (ret == null || ret.length() <= 0) break;
                    ret = "(" + ret + ")";
                    this.editExpression(ret);
                    break;
                }
                this.expression.setFocus();
                this.expression.setSelection(pos);
                break;
            }
            case 2: {
                AddEitherOrDialog addEOr = new AddEitherOrDialog(this.expression.getParent().getShell(), this.model, this.isXML, this.bindingPreviewer);
                if (addEOr.open() == 0) {
                    String ret = addEOr.getEitherOr();
                    if (ret == null || ret.length() <= 0) break;
                    ret = "(" + ret + ")";
                    this.editExpression(ret);
                    break;
                }
                this.expression.setFocus();
                this.expression.setSelection(pos);
            }
        }
    }

    private void editExpression(String newToken) {
        int index = this.expression.getCaretPosition();
        StringBuffer buffer = new StringBuffer(this.expression.getText());
        buffer.insert(index, newToken);
        String vbl = buffer.toString().trim();
        int extraChars = vbl.length() - this.expression.getText().length();
        boolean convertedToVbl = false;
        if (!ELEditorControl.isVblExpression(vbl)) {
            vbl = ELEditorControl.makeVbl(vbl);
            convertedToVbl = true;
        }
        this.expression.setText(vbl);
        this.expression.setFocus();
        index = convertedToVbl ? index + 2 : index;
        this.expression.setSelection(index + extraChars);
    }

    private GridData createButtonData(int maxLen) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.widthHint = maxLen;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    private GridData createGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        return gridData;
    }

    public Composite getComposite() {
        return this.thisControl;
    }

    public static String makeVbl(String reference) {
        if (reference == null) {
            return null;
        }
        if (ELEditorControl.isVblExpression(reference)) {
            return reference;
        }
        return "#{" + reference + "}";
    }

    public static boolean isVblExpression(String reference) {
        if (reference == null) {
            return false;
        }
        return reference.indexOf("#{") != -1 && reference.indexOf("#{") < reference.indexOf(125);
    }

    private void xmlExpression(boolean makeXML) {
        this.isXML = makeXML;
        String exp = this.expression.getText();
        exp = makeXML ? this.convertToXML(exp) : this.convertFromXML(exp);
        this.expression.setText(exp);
    }

    private String convertToXML(String symbolic) {
        String exp = symbolic;
        exp = exp.replaceAll("==", " eq ");
        exp = exp.replaceAll("!=", " ne ");
        exp = exp.replaceAll("<=", " le ");
        exp = exp.replaceAll(">=", " ge ");
        exp = exp.replaceAll("<", " lt ");
        exp = exp.replaceAll(">", " gt ");
        exp = exp.replaceAll("&&", " and ");
        exp = exp.replaceAll("\\|\\|", " or ");
        exp = exp.replaceAll("!", " not ");
        exp = exp.replaceAll("/", " div ");
        exp = exp.replaceAll("%", " mod ");
        exp = exp.replaceAll("  ", " ").replaceAll("  ", " ");
        return exp.trim();
    }

    private String convertFromXML(String textual) {
        String exp = textual;
        exp = exp.replaceAll(" lt ", " < ");
        exp = exp.replaceAll(" le ", " <= ");
        exp = exp.replaceAll(" not ", " !");
        exp = exp.replaceAll(" eq ", " == ");
        exp = exp.replaceAll(" ne ", " != ");
        exp = exp.replaceAll(" div ", " / ");
        exp = exp.replaceAll(" or ", " || ");
        exp = exp.replaceAll(" and ", " && ");
        exp = exp.replaceAll(" gt ", " > ");
        exp = exp.replaceAll(" ge ", " >= ");
        exp = exp.replaceAll(" mod ", " % ");
        return exp.trim();
    }

    public String getExpression() {
        return this.isXML ? this.convertToXML(this.expression.getText()) : this.convertFromXML(this.expression.getText());
    }

    public void dispose() {
        this.dispose((Widget)this.thisControl);
        this.dispose((Widget)this.expression);
        this.dispose((Widget)this.okButton);
        this.model = null;
    }

    private void dispose(Widget w) {
        if (w != null && !w.isDisposed()) {
            w.dispose();
        }
        w = null;
    }

    private void enableOkButton() {
        if (this.okButton != null) {
            if (this.expression.getText() != null && this.expression.getText().length() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    public void setOkButton(Button okButton) {
        this.okButton = okButton;
    }

    public void setElExpression(String elExpression) {
        if (this.expression != null && elExpression != null) {
            this.expression.setText(elExpression);
        }
    }
}

