/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.ui;

import com.ibm.etools.webtools.pagedataview.ui.internal.ICategoryChangeListener;
import java.util.ArrayList;
import java.util.List;

public class CategoryChangeNotifier {
    private List listeners = new ArrayList(5);
    private static CategoryChangeNotifier singleton;

    public static CategoryChangeNotifier getSingleton() {
        if (singleton == null) {
            singleton = new CategoryChangeNotifier();
        }
        return singleton;
    }

    public void addCategoryChangedListener(ICategoryChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePageDataChangedListener(ICategoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireCategoryChanged(String categoryID) {
        if (this.listeners.size() > 0) {
            int size = this.listeners.size();
            int i = size - 1;
            while (i >= 0) {
                try {
                    ((ICategoryChangeListener)this.listeners.get(i)).categoryChanged(categoryID, false);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                --i;
            }
        }
    }

    public void fireCategoryChanged(String categoryID, boolean expandCategory) {
        if (this.listeners.size() > 0) {
            int size = this.listeners.size();
            int i = size - 1;
            while (i >= 0) {
                try {
                    ((ICategoryChangeListener)this.listeners.get(i)).categoryChanged(categoryID, expandCategory);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                --i;
            }
        }
    }
}

