/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.commands;

import com.ibm.etools.webedit.commands.CommandLabel;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.InsertNodeCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertNodeAsChildCommand
extends InsertNodeCommand {
    public InsertNodeAsChildCommand(NodeFactory factory) {
        super(factory);
    }

    protected Range doInsert(Document document, Range range, NodeFactory factory) {
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)document);
        if (query == null) {
            return null;
        }
        Range textTargetRange = ((DocumentRange)((Object)document)).createRange();
        Node node = factory.createNode(document, textTargetRange);
        if (node == null || node.getNodeType() != 1) {
            return null;
        }
        Range nr = this.getNormalizedRange(range);
        if (nr == null) {
            return null;
        }
        Node target = nr.getStartContainer();
        Node parent = target.getParentNode();
        int offset = nr.getStartOffset();
        if (target.getNodeType() == 3) {
            Text textTarget = (Text)target;
            if (offset == 0) {
                parent.insertBefore(node, textTarget);
            } else if (offset == ((Text)target).getLength()) {
                parent.insertBefore(node, textTarget.getNextSibling());
            } else {
                Text lastText = textTarget.splitText(offset);
                parent.insertBefore(node, lastText);
            }
        } else if (query.isEmptyNode(target) && !query.canContainText(target)) {
            parent.insertBefore(node, target.getNextSibling());
        } else if (target.hasChildNodes()) {
            Node before = target.getChildNodes().item(offset);
            target.insertBefore(node, before);
        } else {
            target.appendChild(node);
        }
        range.setStart(node, 0);
        range.setEnd(node, 0);
        this.setRange(range);
        this.setLabel(CommandLabel.LABEL_INSERT_A_TAG);
        return range;
    }

    public HTMLCommand.Condition getFreeLayoutSupport() {
        return FLM_ADD_CELL;
    }
}

