/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.api;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapterFactory;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNodeAdapterFactory;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataView;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageDataViewPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class PageDataViewInputManager {
    private static PageDataViewInputManager inputManager;

    public static PageDataViewInputManager getInstance() {
        if (inputManager == null) {
            inputManager = new PageDataViewInputManager();
        }
        return inputManager;
    }

    public void setInput(HTMLEditDomain editDomain) {
        this.cleanUp();
        IDOMDocument doc = editDomain.getActiveModel().getDocument();
        PageDataModelAdapter adapter = (PageDataModelAdapter)doc.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        if (adapter == null) {
            this.initializePageDataModelAdapters((IStructuredModel)editDomain.getActiveModel());
            adapter = (PageDataModelAdapter)doc.getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        }
        IPageDataModel pdm = adapter.getPageDataModel();
        PageDataViewPage currentPage = PageDataView.getCurrentPageDataViewPage();
        PageDataView.getViewInstance().setCurrentPage(currentPage);
        currentPage.setPageDataModel(pdm);
    }

    public void cleanUp() {
        PageDataViewPage page = PageDataView.getCurrentPageDataViewPage();
        if (page != null) {
            page.editorDisposed();
        }
    }

    private void initializePageDataModelAdapters(IStructuredModel structuredModel) {
        this.processDefinitions(structuredModel);
        this.addContentBasedFactories(structuredModel);
        this.addPropagatingAdapters(structuredModel);
    }

    private void processDefinitions(IStructuredModel model) {
        IExtensionPoint extPt = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.etools.webtools.pagedatamodel.pageDataAdapterFactoryDescription");
        IConfigurationElement[] elements = extPt.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("adapterFactoryDescription")) {
                try {
                    AdapterFactoryProvider adapterFactoryProvider = (AdapterFactoryProvider)element.createExecutableExtension("class");
                    if (adapterFactoryProvider != null && adapterFactoryProvider.isFor((IDocumentTypeHandler)model.getModelHandler())) {
                        adapterFactoryProvider.addAdapterFactories(model);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void addContentBasedFactories(IStructuredModel structuredModel) {
        FactoryRegistry factoryRegistry = structuredModel.getFactoryRegistry();
        Assert.isNotNull((Object)factoryRegistry, (String)"Program Error: client caller must ensure model has factory registry");
        INodeAdapterFactory factory = null;
        factory = factoryRegistry.getFactoryFor((Object)PageDataModelAdapter.ADAPTER_KEY);
        if (factory == null) {
            factory = new PageDataModelAdapterFactory();
            factoryRegistry.addFactory(factory);
        }
    }

    private void addPropagatingAdapters(IStructuredModel structuredModel) {
        IDOMModel xmlModel = (IDOMModel)structuredModel;
        IDOMDocument document = xmlModel.getDocument();
        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)document.getAdapterFor(PropagatingAdapter.class);
        if (propagatingAdapter != null) {
            PageDataNodeAdapterFactory factory = new PageDataNodeAdapterFactory();
            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)factory);
            propagatingAdapter.initializeForFactory((INodeAdapterFactory)factory, (INodeNotifier)document);
        }
    }
}

