/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview;

import com.ibm.etools.webtools.pagedatamodel.PageDataModelPlugin;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedataview.PageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.ui.ConfigureDialogFactory;
import com.ibm.etools.webtools.pagedataview.ui.dnd.internal.DropActionMediatorElement;
import com.ibm.etools.webtools.pagedataview.ui.internal.VisibilityRule;
import com.ibm.etools.webtools.pagedataview.ui.internal.VisibilityRulesUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.sse.ui.internal.util.RegistryReader;
import org.osgi.framework.Bundle;

public class PageDataViewRegistryReader
extends RegistryReader {
    private static PageDataViewRegistryReader singleton;
    public static final String XFER_EXTPNT_ID = "dragTransfers";
    public static final String XFER_ELMNT_NAME = "transfer";
    public static final String ATTR_METHOD = "method";
    public static final String ATTR_SINGLETON = "singleton";
    public static final String TRUE = "true";
    public static final String Mediators_EXTPNT_ID = "dropActionMediators";
    public static final String Mediators_ELMNT_NAME = "mediator";
    public static final String ATTR_SMRTG = "smartGrouping";
    public static final String CFG_DLG_ELMNT = "configureDialogFactory";
    public static final String CFG_ACTN_ELMNT = "configureAction";
    public static final String ATTR_TGTOBJ = "targetObjectClass";
    public static final String ATTR_ID = "id";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_PRIORITY = "priority";
    public static final String ATTR_LABLE = "label";
    public static final String ATTR_PT = "pageType";
    public static final String ELEM_FACET = "facet";
    public static final String ATT_FACET_EXISTS = "exists";
    public static final String ATT_FACET_VERSION = "version";
    public static final String ELEM_OR = "or";
    private Map transferTypes = new HashMap(3);
    private boolean xferTypesParsed = false;
    private Map transferTypeClasses = new HashMap(3);
    private List dropActionMediators = new ArrayList(2);
    private boolean mediatorsParsed = false;
    private Map configureDialogs = new HashMap(2);
    private boolean providersParsed = false;

    protected PageDataViewRegistryReader() {
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(XFER_ELMNT_NAME)) {
            return this.parseTransferElement(element);
        }
        if (element.getName().equalsIgnoreCase(Mediators_ELMNT_NAME)) {
            return this.parseMediatorElement(element);
        }
        if (element.getName().equalsIgnoreCase("provider")) {
            IConfigurationElement[] dialogChildren = element.getChildren(CFG_DLG_ELMNT);
            int i = 0;
            while (dialogChildren != null && i < dialogChildren.length) {
                this.parseConfigureDialogElement(dialogChildren[i]);
                ++i;
            }
            return true;
        }
        return element.getName().equalsIgnoreCase("category");
    }

    private boolean parseMediatorElement(IConfigurationElement element) {
        String pageType;
        String classAttribute = element.getAttribute(ATTR_CLASS);
        if (classAttribute == null) {
            return false;
        }
        DropActionMediatorElement mediator = new DropActionMediatorElement();
        mediator.configurationElement = element;
        String priority = element.getAttribute(ATTR_PRIORITY);
        mediator.priority = priority != null && !priority.equals("") ? Short.parseShort(priority) : (short)50;
        String grouping = element.getAttribute(ATTR_SMRTG);
        if (grouping != null && !grouping.equals("")) {
            mediator.smartGrouping = Boolean.getBoolean(grouping);
        }
        if ((pageType = element.getAttribute(ATTR_PT)) != null && !"".equals(pageType)) {
            mediator.pageType = pageType;
        }
        IConfigurationElement[] facets = element.getChildren(ELEM_FACET);
        int i = 0;
        while (i < facets.length) {
            VisibilityRule rule = new VisibilityRule();
            rule.setFacetID(facets[i].getAttribute(ATTR_ID));
            rule.setFacetVersion(facets[i].getAttribute(ATT_FACET_VERSION));
            if (facets[i].getAttribute(ATT_FACET_EXISTS) == null) {
                rule.setShouldExist(true);
            } else {
                rule.setShouldExist(Boolean.valueOf(facets[i].getAttribute(ATT_FACET_EXISTS)));
            }
            mediator.visibilityRules.add(rule);
            ++i;
        }
        IConfigurationElement[] orGroups = element.getChildren(ELEM_OR);
        if (orGroups != null && orGroups.length > 0) {
            VisibilityRulesUtil.addOrGroups(mediator.visibilityRules, orGroups);
        }
        this.dropActionMediators.add(mediator);
        return true;
    }

    private boolean parseTransferElement(IConfigurationElement element) {
        String id = element.getAttribute(ATTR_ID);
        if (id == null) {
            return false;
        }
        String classAttribute = element.getAttribute(ATTR_CLASS);
        if (classAttribute == null) {
            return false;
        }
        this.transferTypes.put(id, element);
        return true;
    }

    private boolean parseConfigureDialogElement(IConfigurationElement element) {
        ArrayList<ConfigureDialogElement> factories;
        String classAttribute = element.getAttribute(ATTR_CLASS);
        if (classAttribute == null) {
            return false;
        }
        String pageType = element.getAttribute(ATTR_PT);
        if (pageType == null) {
            return false;
        }
        String targetObject = element.getAttribute(ATTR_TGTOBJ);
        if (targetObject == null) {
            return false;
        }
        ConfigureDialogElement newElement = new ConfigureDialogElement();
        newElement.element = element;
        HashMap innerMap = (HashMap)this.configureDialogs.get(targetObject);
        if (innerMap == null) {
            innerMap = new HashMap(1);
        }
        if ((factories = (ArrayList<ConfigureDialogElement>)innerMap.get(pageType)) == null) {
            factories = new ArrayList<ConfigureDialogElement>(1);
        }
        if (!factories.contains(newElement)) {
            factories.add(newElement);
        }
        innerMap.put(pageType, factories);
        this.configureDialogs.put(targetObject, innerMap);
        return true;
    }

    protected void createClass(final IConfigurationElement element, final Object[] ret) {
        Bundle plugin = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
        String classAttribute = element.getAttribute(ATTR_CLASS);
        if (plugin.getState() == 32) {
            try {
                ret[0] = this.createExecutableExtension(element);
            }
            catch (CoreException coreException) {
                this.logError(element, NLS.bind((String)ResourceHandler._EXC_LDClass, (Object[])new String[]{classAttribute}));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            final CoreException[] exc = new CoreException[1];
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ret[0] = PageDataViewRegistryReader.this.createExecutableExtension(element);
                    }
                    catch (CoreException e) {
                        exc[0] = e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            if (exc[0] != null) {
                this.logError(element, NLS.bind((String)ResourceHandler._EXC_LDClass, (Object[])new String[]{classAttribute}));
            }
        }
    }

    Object createExecutableExtension(IConfigurationElement element) throws CoreException {
        String singleton = element.getAttribute(ATTR_SINGLETON);
        String method = element.getAttribute(ATTR_METHOD);
        if (TRUE.equalsIgnoreCase(singleton) && method != null) {
            try {
                String name = element.getAttribute(ATTR_CLASS);
                Bundle plugin = Platform.getBundle((String)element.getDeclaringExtension().getNamespace());
                Class cls = plugin.loadClass(name);
                Method mtd = cls.getMethod(method, new Class[0]);
                return mtd.invoke(null, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }
        return element.createExecutableExtension(ATTR_CLASS);
    }

    private void parseXfers() {
        this.readRegistry(Platform.getExtensionRegistry(), PageDataViewPlugin.getDefault().getBundle().getSymbolicName(), XFER_EXTPNT_ID);
    }

    private void parseMediators() {
        this.readRegistry(Platform.getExtensionRegistry(), PageDataViewPlugin.getDefault().getBundle().getSymbolicName(), Mediators_EXTPNT_ID);
    }

    private void parseProviders() {
        this.readRegistry(Platform.getExtensionRegistry(), PageDataModelPlugin.getDefault().getBundle().getSymbolicName(), "pageDataNodeProviders");
    }

    public static Map getDragTransferTypes() {
        PageDataViewRegistryReader singleton = PageDataViewRegistryReader.getSingleton();
        if (!singleton.xferTypesParsed) {
            singleton.parseXfers();
            singleton.xferTypesParsed = true;
        }
        return singleton.transferTypes;
    }

    public static Object getDragTransferTypeClass(String id) {
        PageDataViewRegistryReader singleton = PageDataViewRegistryReader.getSingleton();
        if (!singleton.xferTypesParsed) {
            singleton.parseXfers();
            singleton.xferTypesParsed = true;
        }
        if (singleton.transferTypeClasses.containsKey(id)) {
            return singleton.transferTypeClasses.get(id);
        }
        Object[] ret = new Object[1];
        IConfigurationElement element = (IConfigurationElement)singleton.transferTypes.get(id);
        if (element != null) {
            singleton.createClass(element, ret);
            singleton.transferTypeClasses.put(id, ret[0]);
            return ret[0];
        }
        return null;
    }

    public static List getDropActionMediators() {
        PageDataViewRegistryReader singleton = PageDataViewRegistryReader.getSingleton();
        if (!singleton.mediatorsParsed) {
            singleton.parseMediators();
            singleton.mediatorsParsed = true;
        }
        ArrayList<DropActionMediatorElement> allMediators = new ArrayList<DropActionMediatorElement>();
        int i = 0;
        while (i < singleton.dropActionMediators.size()) {
            DropActionMediatorElement mediator = (DropActionMediatorElement)singleton.dropActionMediators.get(i);
            if (mediator.mediator == null) {
                Object[] ret = new Object[1];
                singleton.createClass(mediator.configurationElement, ret);
                mediator.mediator = ret[0];
            }
            allMediators.add(mediator);
            ++i;
        }
        return allMediators;
    }

    public static List getDropActionMediators(IProject proj) {
        PageDataViewRegistryReader singleton = PageDataViewRegistryReader.getSingleton();
        if (!singleton.mediatorsParsed) {
            singleton.parseMediators();
            singleton.mediatorsParsed = true;
        }
        if (proj == null) {
            return PageDataViewRegistryReader.getDropActionMediators();
        }
        ArrayList<DropActionMediatorElement> mediatorsForThisProject = new ArrayList<DropActionMediatorElement>();
        int i = 0;
        while (i < singleton.dropActionMediators.size()) {
            DropActionMediatorElement mediator = (DropActionMediatorElement)singleton.dropActionMediators.get(i);
            if (mediator.mediator != null) {
                mediatorsForThisProject.add(mediator);
            } else {
                List visibilityRules = mediator.visibilityRules;
                boolean runMediator = true;
                int j = 0;
                while (j < visibilityRules.size()) {
                    List orList;
                    boolean orListSatisfied;
                    Object next = visibilityRules.get(j);
                    if (next instanceof VisibilityRule) {
                        VisibilityRule rule = (VisibilityRule)next;
                        boolean shouldExist = rule.isShouldExist();
                        String facetID = rule.getFacetID();
                        String facetVersion = rule.getFacetVersion();
                        if (facetVersion == "") {
                            facetVersion = null;
                        }
                        if (VisibilityRulesUtil.projectHasFacet(proj, facetID, facetVersion) != shouldExist) {
                            runMediator = false;
                            break;
                        }
                    } else if (next instanceof List && !(orListSatisfied = VisibilityRulesUtil.processOrList(orList = (List)next, proj))) {
                        runMediator = false;
                        break;
                    }
                    ++j;
                }
                if (runMediator) {
                    Object[] ret = new Object[1];
                    singleton.createClass(mediator.configurationElement, ret);
                    mediator.mediator = ret[0];
                    mediatorsForThisProject.add(mediator);
                }
            }
            ++i;
        }
        return mediatorsForThisProject;
    }

    private static PageDataViewRegistryReader getSingleton() {
        if (singleton == null) {
            singleton = new PageDataViewRegistryReader();
        }
        return singleton;
    }

    public static String getPageTypeOfMediator(Object mediator) {
        PageDataViewRegistryReader singleton = PageDataViewRegistryReader.getSingleton();
        List list = singleton.dropActionMediators;
        int i = 0;
        while (i < list.size()) {
            DropActionMediatorElement element = (DropActionMediatorElement)list.get(i);
            if (element.mediator == mediator) {
                return element.pageType;
            }
            ++i;
        }
        return null;
    }

    public static List getConfigureDialogFactoryFor(IPageDataNode node, String pageType) {
        PageDataViewRegistryReader singleton = PageDataViewRegistryReader.getSingleton();
        if (!singleton.providersParsed) {
            singleton.parseProviders();
            singleton.providersParsed = true;
        }
        ArrayList classes = new ArrayList(1);
        Class<?> clazz = node.getClass();
        while (clazz != null) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        int i = 0;
        while (i < classes.size()) {
            Class oneClass = (Class)classes.get(i);
            List factories = null;
            Map innerMap = (Map)singleton.configureDialogs.get(oneClass.getName());
            if (innerMap != null) {
                factories = (List)innerMap.get(pageType);
            }
            if (factories != null) {
                ArrayList<ConfigureDialogFactory> ret = new ArrayList<ConfigureDialogFactory>(factories.size());
                int j = 0;
                while (j < factories.size()) {
                    ret.add(((ConfigureDialogElement)factories.get(j)).getDialogFactory());
                    ++j;
                }
                return ret;
            }
            ++i;
        }
        return null;
    }

    public class ConfigureDialogElement {
        public IConfigurationElement element;
        private ConfigureDialogFactory factory;

        public ConfigureDialogFactory getDialogFactory() {
            if (this.factory == null) {
                try {
                    this.factory = (ConfigureDialogFactory)this.element.createExecutableExtension(PageDataViewRegistryReader.ATTR_CLASS);
                }
                catch (CoreException coreException) {
                    PageDataViewRegistryReader.this.logError(this.element, NLS.bind((String)ResourceHandler._EXC_LDClass, (Object[])new String[]{this.element.getAttribute(PageDataViewRegistryReader.ATTR_CLASS)}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.factory;
        }
    }
}

