/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.sdo.ui;

import com.ibm.etools.common.ui.presentation.FilteredFileSelectionDialog;
import com.ibm.etools.sdo.ui.provisional.datahandlers.MediatorException;
import com.ibm.etools.sdo.ui.provisional.datahandlers.SDOToolsFactory;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.RootPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.DataObjectPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.EClassPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.ISDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.SDOPageDataNode;
import com.ibm.etools.webtools.pagedataview.sdo.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.sdo.plugin.SDOPageDataViewPlugin;
import com.ibm.etools.webtools.pagedataview.sdo.ui.SDORecordSelection;
import com.ibm.etools.webtools.pagedataview.sdo.util.PageDataNodeUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ExistingSDOConfigureDialog
extends TitleAreaDialog
implements ISelectionChangedListener,
Listener {
    public static final String[] VALID_SCOPES = new String[]{"session", "request", "application"};
    private String name;
    private String scope;
    private String key;
    private String path;
    private String metadataFilePath;
    private SDOPageDataNode nodeToConfigure;
    private Combo scopeCombo;
    private Text keyText;
    protected Text metadataFileText;
    private Button browse;
    private SDORecordSelection sdoTree;
    private SDOPageDataNode input;

    public ExistingSDOConfigureDialog(String name, SDOPageDataNode nodeToConfigure, Shell parentShell) {
        super(parentShell);
        this.name = name;
        this.nodeToConfigure = nodeToConfigure;
    }

    public String getPath() {
        return this.path;
    }

    public String getMetadataFilePath() {
        return this.metadataFilePath;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public SDOPageDataNode getNodeToConfigure() {
        return this.nodeToConfigure;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite area = new Composite(composite, 0);
        GridLayout layout = new GridLayout(3, false);
        area.setLayout((Layout)layout);
        GridData ldata = new GridData(1808);
        area.setLayoutData((Object)ldata);
        Label nameLabel = new Label(area, 0);
        nameLabel.setText(ResourceHandler.ExistingSDOConfigureDialog_0);
        Label nameText = new Label(area, 0);
        ldata = new GridData(768);
        ldata.horizontalSpan = 2;
        nameText.setLayoutData((Object)ldata);
        nameText.setText(this.name);
        Label keyLabel = new Label(area, 0);
        keyLabel.setText(ResourceHandler.ExistingSDOConfigureDialog_1);
        this.keyText = new Text(area, 2048);
        ldata = new GridData(768);
        ldata.horizontalSpan = 2;
        this.keyText.setLayoutData((Object)ldata);
        this.keyText.addListener(24, (Listener)this);
        Label scopeLabel = new Label(area, 0);
        scopeLabel.setText(ResourceHandler.ExistingSDOConfigureDialog_2);
        this.scopeCombo = new Combo(area, 0);
        ldata = new GridData(768);
        ldata.horizontalSpan = 2;
        this.scopeCombo.setLayoutData((Object)ldata);
        this.scopeCombo.setItems(VALID_SCOPES);
        this.scopeCombo.addListener(13, (Listener)this);
        this.scopeCombo.addListener(24, (Listener)this);
        Label fileLabel = new Label(area, 0);
        fileLabel.setText(ResourceHandler.ExistingSDOConfigureDialog_3);
        this.metadataFileText = new Text(area, 2048);
        ldata = new GridData(768);
        ldata.widthHint = 300;
        this.metadataFileText.setLayoutData((Object)ldata);
        this.metadataFileText.setEditable(false);
        this.metadataFileText.addListener(24, (Listener)this);
        this.browse = new Button(area, 8);
        this.browse.setText(ResourceHandler.ExistingSDOConfigureDialog_4);
        ldata = new GridData(768);
        this.browse.setLayoutData((Object)ldata);
        this.browse.addListener(13, (Listener)this);
        Label pathLabel = new Label(area, 0);
        ldata = new GridData(768);
        ldata.horizontalSpan = 3;
        pathLabel.setLayoutData((Object)ldata);
        pathLabel.setText(ResourceHandler.ExistingSDOConfigureDialog_5);
        ArrayList<SDOPageDataNode> list = new ArrayList<SDOPageDataNode>(1);
        SDOToolsFactory factory = null;
        try {
            factory = (SDOToolsFactory)this.nodeToConfigure.getSDODataFactory().getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        factory.setDataType("DataObject");
        factory.setMetadataFileName(this.nodeToConfigure.getSDODataFactory().getMetadataFileName());
        factory.setProject(this.nodeToConfigure.getPageDataModel().getResource().getProject());
        this.input = new DataObjectPageDataNode(factory, (IPageDataNode)new RootPageDataNode(null, null));
        this.input.setName(this.name);
        list.add(this.input);
        this.sdoTree = new SDORecordSelection(area, list);
        GridData compositeData = new GridData(1808);
        compositeData.horizontalSpan = 3;
        compositeData.heightHint = 120;
        compositeData.widthHint = 350;
        this.sdoTree.getTree().setLayoutData((Object)compositeData);
        this.sdoTree.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.initializeTitleAndMessage();
        return composite;
    }

    protected void initializeTitleAndMessage() {
        this.setTitleImage(SDOPageDataViewPlugin.getDefault().getImage("wizban/createdataobject_wiz"));
        this.setTitle(ResourceHandler.ExistingSDOConfigureDialog_title);
        this.setMessage(ResourceHandler.ExistingSDOConfigureDialog_message);
        this.getShell().setText(ResourceHandler.ExistingSDOConfigureDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.sdoTree.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            ISDOPageDataNode pdNode;
            StringBuffer buf = new StringBuffer("");
            ISDOPageDataNode currentNode = pdNode = (ISDOPageDataNode)((StructuredSelection)event.getSelection()).getFirstElement();
            while (currentNode != null && currentNode instanceof EClassPageDataNode) {
                String segment = null;
                segment = currentNode == this.input ? ((EClassPageDataNode)((Object)currentNode)).getEClass().getName() : ((EClassPageDataNode)((Object)currentNode)).getName();
                buf.insert(0, "/" + segment);
                currentNode = currentNode.getParent();
            }
            if (buf.length() > 1 && buf.charAt(0) == '/') {
                buf = new StringBuffer(buf.substring(1));
            }
            this.path = buf.toString();
        }
        this.validatePage();
    }

    protected void okPressed() {
        this.key = this.keyText.getText();
        this.scope = this.scopeCombo.getText();
        super.okPressed();
    }

    protected void validatePage() {
        boolean complete = true;
        if (this.keyText.getText() == null || this.keyText.getText().equals("")) {
            complete = false;
        }
        if (complete && (this.scopeCombo.getText() == null || this.scopeCombo.getText().equals(""))) {
            complete = false;
        }
        if (complete && this.sdoTree.getTreeViewer().getSelection().isEmpty()) {
            complete = false;
        }
        Button ok = this.getButton(0);
        if (complete && ok != null) {
            ok.setEnabled(true);
        } else if (!complete && ok != null) {
            ok.setEnabled(false);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.browse) {
            this.handleFileBrowse();
        } else if (event.widget == this.metadataFileText) {
            this.metadataFilePath = this.metadataFileText.getText();
        }
        this.validatePage();
    }

    protected void handleFileBrowse() {
        Object[] o;
        FilteredFileSelectionDialog dialog = new FilteredFileSelectionDialog(this.getShell(), ResourceHandler.ExistingSDOConfigureDialog_6, ResourceHandler.ExistingSDOConfigureDialog_7, new String[]{"xml"}, false);
        IProject project = this.nodeToConfigure.getPageDataModel().getResource().getProject();
        dialog.setInput((Object)project);
        IVirtualComponent comp = ComponentUtilities.findComponent((IResource)this.nodeToConfigure.getPageDataModel().getResource());
        IFolder selection = null;
        if (comp != null) {
            IContainer folder = comp.getRootFolder().getUnderlyingFolder();
            String wdoFolderName = "wdo";
            if (folder.exists() && folder.getFolder((IPath)new Path(wdoFolderName)).exists()) {
                IFolder wdoFolder;
                selection = wdoFolder = folder.getFolder((IPath)new Path(wdoFolderName));
                try {
                    if (wdoFolder.members().length > 0) {
                        selection = wdoFolder.members()[0];
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        dialog.setInitialSelection(selection);
        if (dialog.open() == 0 && (o = dialog.getResult()) != null) {
            IFile inputFile = (IFile)o[0];
            this.metadataFilePath = PageDataNodeUtil.getWebAppRelativePath(inputFile, project).toString();
            this.metadataFileText.setText(this.metadataFilePath);
            this.input.getSDODataFactory().setMetadataFileName(this.metadataFilePath);
            this.input.setMetaDataModel(null);
            try {
                this.input.changedMetaDataModel();
            }
            catch (MediatorException e) {
                e.printStackTrace();
            }
            ArrayList<SDOPageDataNode> list = new ArrayList<SDOPageDataNode>(1);
            list.add(this.input);
            this.sdoTree.getTreeViewer().setInput(list);
            this.sdoTree.getTreeViewer().refresh();
        }
    }
}

