/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.sdo.plugin;

import com.ibm.etools.webtools.pagedataview.sdo.plugin.SDOPageDataViewPlugin;
import com.ibm.icu.util.StringTokenizer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;

public class Logger {
    public static final int OK_DEBUG = 0;
    public static final int INFO_DEBUG = 1;
    public static final int WARNING_DEBUG = 2;
    public static final int ERROR_DEBUG = 3;
    public static final int OK_ALWAYS = 4;
    public static final int INFO_ALWAYS = 5;
    public static final int WARNING_ALWAYS = 6;
    public static final int ERROR_ALWAYS = 7;
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;

    public static void trace(String message) {
        if (!SDOPageDataViewPlugin.getDefault().isDebugging()) {
            return;
        }
        if (message == null) {
            return;
        }
        String pluginID = SDOPageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        String option = String.valueOf(pluginID) + "/debug/tracefilter";
        String traceFilter = Platform.getDebugOption((String)option);
        if (traceFilter != null && traceFilter.length() != 0) {
            return;
        }
        System.out.println(message);
    }

    public static void trace(String message, String category) {
        if (!SDOPageDataViewPlugin.getDefault().isDebugging()) {
            return;
        }
        if (message == null) {
            return;
        }
        String pluginID = SDOPageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        String option = String.valueOf(pluginID) + "/debug/tracefilter";
        String traceFilter = Platform.getDebugOption((String)option);
        if (traceFilter == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(traceFilter, ", ");
        while (tokens.hasMoreTokens()) {
            String filter = tokens.nextToken();
            if (!category.equals(filter)) continue;
            System.out.println(message);
            break;
        }
    }

    public static void log(int level, String message) {
        Logger.log(level, message, null);
    }

    public static void log(int level, String message, Throwable exception) {
        if (message == null) {
            return;
        }
        if (!(level != 0 && level != 1 && level != 2 && level != 3 || SDOPageDataViewPlugin.getDefault().isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 5: {
                severity = 1;
                break;
            }
            case 2: 
            case 6: {
                severity = 2;
                break;
            }
            case 3: 
            case 7: {
                severity = 4;
            }
        }
        String pluginID = SDOPageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        Status StatusObj = new Status(severity, pluginID, severity, message, exception);
        SDOPageDataViewPlugin.getDefault().getLog().log((IStatus)StatusObj);
    }

    public static void logException(String message, Throwable exception) {
        Logger.log(7, message, exception);
    }

    public static void logException(Throwable exception) {
        Logger.log(7, exception.getMessage(), exception);
    }

    public static void alert(int level, String message, String reason, String details) {
        if (message == null) {
            return;
        }
        if (!(level != 0 && level != 1 && level != 2 && level != 3 || SDOPageDataViewPlugin.getDefault().isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 5: {
                severity = 1;
                break;
            }
            case 2: 
            case 6: {
                severity = 2;
                break;
            }
            case 3: 
            case 7: {
                severity = 4;
            }
        }
        String pluginID = SDOPageDataViewPlugin.getDefault().getBundle().getSymbolicName();
        MultiStatus multiStatus = new MultiStatus(pluginID, severity, reason, null);
        if (details != null) {
            Status StatusObj = new Status(severity, pluginID, severity, details, null);
            multiStatus.add((IStatus)StatusObj);
        }
        ErrorDialog.openError(null, (String)SDOPageDataViewPlugin.getDefault().getBundle().getSymbolicName(), (String)message, (IStatus)multiStatus);
    }

    public static String getObjectContents(Object object) {
        if (object == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            buffer.append("{");
            while (clazz != null) {
                Field[] fields = clazz.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Field field = fields[i];
                    if (!Modifier.isStatic(field.getModifiers())) {
                        if (buffer.length() > 1) {
                            buffer.append(",");
                        }
                        field.setAccessible(true);
                        buffer.append(field.getName());
                        buffer.append("=");
                        try {
                            Object value = field.get(object);
                            if (value != null) {
                                if (value.getClass().isArray()) {
                                    buffer.append(Logger.getArrayContents(value));
                                } else {
                                    buffer.append(value);
                                }
                            } else {
                                buffer.append("null");
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
            buffer.append("}");
        } else {
            buffer.append(Logger.getArrayContents(object));
        }
        return buffer.toString();
    }

    public static String getArrayContents(Object array) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        int i = 0;
        while (i < Array.getLength(array)) {
            if (i > 0) {
                buffer.append(",");
            }
            Object value = Array.get(array, i);
            buffer.append(Logger.getObjectContents(value));
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }
}

