/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.util;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.javabean.ContainedTypePageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.util.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaBeanPersistenceManager
extends PersistenceManager {
    public JavaBeanPersistenceManager() {
    }

    public JavaBeanPersistenceManager(List toNotify) {
        super(toNotify);
    }

    public static JavaBeanPersistenceManager getJBInstance() {
        fPersistenceManager = fPersistenceManager != null ? new JavaBeanPersistenceManager(fPersistenceManager.getToNotify()) : new JavaBeanPersistenceManager();
        return (JavaBeanPersistenceManager)fPersistenceManager;
    }

    private static Element getBeanDataElement(Document doc) {
        Element ret = null;
        NodeList elementList = null;
        if (doc != null) {
            elementList = doc.getElementsByTagName("beanData");
        }
        if (elementList != null && elementList.getLength() == 1) {
            ret = (Element)elementList.item(0);
        }
        return ret;
    }

    private static Element addBeanType(Element beanRootElement, String beanType, String filename) {
        Element ret = null;
        if (beanRootElement != null) {
            Element beanElement = beanRootElement.getOwnerDocument().createElement("bean");
            beanElement.setAttribute("type", beanType);
            beanElement.setAttribute("id", filename);
            beanRootElement.appendChild(beanElement);
            ret = beanElement;
        }
        return ret;
    }

    public static Element addCollectionProperty(Document doc, String beanType, String filename, String propertyName) {
        Element beanRootElement = null;
        Element beanEntry = null;
        Element propertyElement = null;
        Element ret = null;
        beanRootElement = JavaBeanPersistenceManager.getBeanDataElement(doc);
        if (beanRootElement != null) {
            beanEntry = JavaBeanPersistenceManager.findBeanEntry(doc, beanType, filename);
            if (beanEntry == null) {
                beanEntry = JavaBeanPersistenceManager.addBeanType(beanRootElement, beanType, filename);
            }
            if ((propertyElement = JavaBeanPersistenceManager.findPropertyElement(beanEntry, propertyName)) == null) {
                propertyElement = doc.createElement("collectionProperty");
                propertyElement.setAttribute("name", propertyName);
                beanEntry.appendChild(propertyElement);
                ret = propertyElement;
            }
        }
        return ret;
    }

    public static void addContainsNodesToPropertyElement(IProject project, String beanType, String filename, String propertyName, String containsType) {
        Document doc = JavaBeanPersistenceManager.getPersistenceDocument((IProject)project, (boolean)true);
        Element propertyElement = JavaBeanPersistenceManager.findPropertyElement(doc, beanType, filename, propertyName);
        if (propertyElement == null) {
            propertyElement = JavaBeanPersistenceManager.addCollectionProperty(doc, beanType, filename, propertyName);
        }
        if (propertyElement != null && containsType != null && doc != null) {
            Element parentElement;
            Element deepestElement = parentElement = propertyElement;
            NodeList children = deepestElement.getElementsByTagName("contains");
            while (children != null && children.getLength() > 0) {
                deepestElement = (Element)children.item(0);
                children = deepestElement.getElementsByTagName("contains");
            }
            Element newElement = doc.createElement("contains");
            newElement.setAttribute("type", containsType);
            deepestElement.appendChild(newElement);
            JavaBeanPersistenceManager.writePersistenceDocument((IProject)project, (Document)doc);
        }
    }

    public static Element findBeanEntry(Document doc, String beanType, String filename) {
        NodeList nodes;
        Element beanRootElement = null;
        if (doc != null) {
            beanRootElement = JavaBeanPersistenceManager.getBeanDataElement(doc);
        }
        if (beanRootElement != null && (nodes = beanRootElement.getElementsByTagName("bean")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Element currentElement = (Element)nodes.item(i);
                if (currentElement.getAttribute("type").equals(beanType) && currentElement.getAttribute("id").equals(filename)) {
                    return currentElement;
                }
                ++i;
            }
        }
        return null;
    }

    public static List findBeanEntries(Document doc, String beanType) {
        NodeList nodes;
        ArrayList<Element> beanEntries = new ArrayList<Element>(1);
        Element beanRootElement = null;
        beanRootElement = JavaBeanPersistenceManager.getBeanDataElement(doc);
        if (beanRootElement != null && (nodes = beanRootElement.getElementsByTagName("bean")) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Element currentElement = (Element)nodes.item(i);
                if (currentElement.getAttribute("type").equals(beanType)) {
                    beanEntries.add(currentElement);
                }
                ++i;
            }
        }
        return beanEntries;
    }

    public static Element findPropertyElement(Element beanEntry, String propertyName) {
        Element ret = null;
        if (beanEntry != null) {
            ret = JavaBeanPersistenceManager.findChildElement((Element)beanEntry, (String)"collectionProperty", (String)"name", (String)propertyName);
        }
        return ret;
    }

    public static Element findPropertyElement(Document doc, String beanType, String filename, String propertyName) {
        Element beanEntry = JavaBeanPersistenceManager.findBeanEntry(doc, beanType, filename);
        return JavaBeanPersistenceManager.findPropertyElement(beanEntry, propertyName);
    }

    public static String getNodeContainedType(IProject project, String beanType, String propertyName, String filename, int index) {
        Element containsElement = JavaBeanPersistenceManager.getContainsElement(project, beanType, propertyName, filename, index);
        if (containsElement != null) {
            return containsElement.getAttribute("type");
        }
        return null;
    }

    private static Element getContainsElement(IProject project, String beanType, String propertyName, String filename, int index) {
        Element collectionPropertyElement;
        Element ret = null;
        Document doc = JavaBeanPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false);
        Element beanEntry = JavaBeanPersistenceManager.findBeanEntry(doc, beanType, filename);
        if (beanEntry != null && (collectionPropertyElement = JavaBeanPersistenceManager.findChildElement((Element)beanEntry, (String)"collectionProperty", (String)"name", (String)propertyName)) != null) {
            ret = JavaBeanPersistenceManager.getContainsElement((Element)collectionPropertyElement, (int)index);
        }
        return ret;
    }

    public static void removeBeanType(IProject project, String beanType, String filename) {
        Element parentElement;
        Document doc = JavaBeanPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false);
        Element beanTypeElement = JavaBeanPersistenceManager.findBeanEntry(doc, beanType, filename);
        if (beanTypeElement != null && (parentElement = (Element)beanTypeElement.getParentNode()) != null) {
            parentElement.removeChild(beanTypeElement);
            JavaBeanPersistenceManager.writePersistenceDocument((IProject)project, (Document)doc);
        }
    }

    public static void removeCollectionProperty(IProject project, String beanType, String filename, String propertyName) {
        Element propertyElement;
        Document doc = JavaBeanPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false);
        Element beanTypeElement = JavaBeanPersistenceManager.findBeanEntry(doc, beanType, filename);
        if (beanTypeElement != null && (propertyElement = JavaBeanPersistenceManager.findChildElement((Element)beanTypeElement, (String)"collectionProperty", (String)"name", (String)propertyName)) != null) {
            beanTypeElement.removeChild(propertyElement);
            JavaBeanPersistenceManager.writePersistenceDocument((IProject)project, (Document)doc);
        }
    }

    public String processPersistenceInfo(IPageDataNode cPdn, String param1, int action) {
        List beanEntries;
        Element beanEntryElement;
        String ret = null;
        int depth = 1;
        IPageDataNode parent = cPdn.getParent();
        IFile file = parent.getPageDataModel().getResource();
        String filename = file.getFullPath().toString();
        IProject project = file.getProject();
        IPageDataNode componentNode = parent;
        while (!PageDataModelUtil.isComponentNode((IPageDataNode)componentNode)) {
            componentNode = componentNode.getParent();
        }
        String beanType = ((JavaBeanPageDataNode)componentNode).getClassName();
        while (parent instanceof ContainedTypePageDataNode) {
            parent = parent.getParent();
            ++depth;
        }
        IPageDataNode temp = parent;
        while (!(temp instanceof ContainedTypePageDataNode) && !PageDataModelUtil.isComponentNode((IPageDataNode)temp)) {
            temp = temp.getParent();
        }
        if (temp instanceof ContainedTypePageDataNode) {
            beanType = ((JavaBeanPageDataNode)temp).getClassName();
        }
        if ((beanEntryElement = JavaBeanPersistenceManager.findBeanEntry(JavaBeanPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false), beanType, filename)) == null && (beanEntries = JavaBeanPersistenceManager.findBeanEntries(JavaBeanPersistenceManager.getPersistenceDocument((IProject)project, (boolean)false), beanType)) != null && beanEntries.size() > 0) {
            beanEntryElement = (Element)beanEntries.get(0);
        }
        String propertyName = ((JavaBeanPageDataNode)parent).getInstanceID();
        if (action == 1 && param1 != null) {
            JavaBeanPersistenceManager.addContainsNodesToPropertyElement(project, beanType, filename, propertyName, param1);
        } else if (action == 2) {
            JavaBeanPersistenceManager.removeNodeContainedType((IProject)project, (Element)beanEntryElement, (String)propertyName, (int)depth);
        } else if (action == 3 && param1 != null) {
            ret = JavaBeanPersistenceManager.getNodeContainedType(project, beanType, propertyName, filename, depth);
        } else if (action == 3 && param1 == null) {
            ret = this.getContainedType(beanEntryElement, propertyName, depth);
        } else if (action == 4) {
            JavaBeanPersistenceManager.removeNodeContainedType((IProject)project, (Element)beanEntryElement, (String)propertyName, (int)depth);
            JavaBeanPersistenceManager.addContainsNodesToPropertyElement(project, beanType, filename, propertyName, param1);
        }
        return ret;
    }
}

