/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.ui.internal;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JavaModelSynchronizer
implements IResourceChangeListener {
    private static JavaModelSynchronizer singleton;
    private List notifyList;

    private JavaModelSynchronizer() {
    }

    private IProject getJavaProjectForDataModel(IPageDataModel model) {
        IProject jProject;
        if (model == null) {
            return null;
        }
        IFile jspFile = model.getResource();
        if (jspFile != null && (jProject = ProjectUtilities.getProject((Object)jspFile.getProject())) != null) {
            return jProject;
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null && singleton != null && JavaModelSynchronizer.singleton.notifyList != null && JavaModelSynchronizer.singleton.notifyList.size() > 0) {
            ArrayList queue = new ArrayList();
            queue.addAll(JavaModelSynchronizer.singleton.notifyList);
            while (!queue.isEmpty()) {
                boolean didRefresh;
                IPageDataNode jbNode = (IPageDataNode)queue.remove(0);
                if (!(jbNode instanceof JavaBeanPageDataNode) || this.getJavaProjectForDataModel(jbNode.getPageDataModel()) == null || (didRefresh = this.processDeltaForJavaBeanNode(delta, (JavaBeanPageDataNode)jbNode)) || !((JavaBeanPageDataNode)jbNode).isChildrenPopulated()) continue;
                EList children = jbNode.getChildren();
                for (Object ob : children) {
                    queue.add(ob);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processDeltaForJavaBeanNode(IResourceDelta delta, JavaBeanPageDataNode node) {
        if (node.getClassName() == null) {
            return false;
        }
        ArrayList<IResourceDelta> queue = new ArrayList<IResourceDelta>(1);
        queue.add(delta);
        while (!queue.isEmpty()) {
            IResourceDelta[] children;
            IResourceDelta d;
            block11: {
                IResource resource;
                block12: {
                    d = (IResourceDelta)queue.remove(0);
                    resource = d.getResource();
                    if (resource.getType() != 1) break block12;
                    IJavaElement javaElement = JavaCore.create((IFile)((IFile)resource));
                    if (javaElement != null && javaElement.getElementType() == 6) {
                        IClassFile cu = (IClassFile)javaElement;
                        try {
                            IType type = cu.getType();
                            if (type != null) {
                                String typeClassName;
                                String nodeClassName = node.getClassName();
                                int dot = nodeClassName.lastIndexOf(46);
                                if (dot != -1) {
                                    nodeClassName = nodeClassName.substring(dot + 1);
                                }
                                if (nodeClassName.equals(typeClassName = type.getFullyQualifiedName())) {
                                    IPageDataNode copy = node.copy();
                                    IDOMNode domNode = null;
                                    if (node instanceof ISSEPageDataNode) {
                                        domNode = ((ISSEPageDataNode)node).getDOMNode();
                                    }
                                    if (node.refresh(domNode, null, null, null)) {
                                        node.getPageDataModel().getPageDataNotifier().firePageNodeChanged(copy, (IPageDataNode)node);
                                        return true;
                                    }
                                    return false;
                                }
                            }
                            break block11;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break block11;
                }
                resource.getType();
            }
            if ((children = d.getAffectedChildren()) == null || children.length <= 0) continue;
            IResourceDelta[] iResourceDeltaArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta element = iResourceDeltaArray[n2];
                queue.add(element);
                ++n2;
            }
        }
        return false;
    }

    public void install() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
    }

    public void uninstall() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public static void connect(IJavaBeanPageDataNode notifiee) {
        if (notifiee == null) {
            return;
        }
        if (singleton == null) {
            singleton = new JavaModelSynchronizer();
            singleton.install();
        }
        if (JavaModelSynchronizer.singleton.notifyList == null) {
            JavaModelSynchronizer.singleton.notifyList = new ArrayList(1);
        }
        if (!JavaModelSynchronizer.singleton.notifyList.contains(notifiee)) {
            JavaModelSynchronizer.singleton.notifyList.add(notifiee);
        }
    }

    public static void disconnect(IJavaBeanPageDataNode notifiee) {
        if (notifiee == null) {
            return;
        }
        if (singleton == null) {
            return;
        }
        JavaModelSynchronizer.singleton.notifyList.remove(notifiee);
        if (JavaModelSynchronizer.singleton.notifyList.isEmpty()) {
            JavaModelSynchronizer.singleton.notifyList = null;
            singleton.uninstall();
            singleton = null;
        }
    }
}

