/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean.ui.internal;

import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanMethodPDN;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPlugin;
import com.ibm.etools.webtools.pagedataview.javabean.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class JavaBeanMethodSelection {
    protected IJavaBeanPageDataNode bean;
    private List beanMethodChildren;
    private Composite base;
    private Tree beanMethodTree;
    protected TreeViewer beanMethodTreeViewer;
    private boolean showActions;
    private boolean showInheritedMethods = false;

    public JavaBeanMethodSelection(Composite base, IJavaBeanPageDataNode bean, boolean showActions) {
        this.base = base;
        this.bean = bean;
        this.showActions = showActions;
        this.beanMethodChildren = bean.getMethodChildren();
        this.createTreeViewer();
        this.createInput();
    }

    protected void createTreeViewer() {
        this.beanMethodTree = new Tree(this.base, 2052);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.beanMethodTree.setLayoutData((Object)data);
        this.beanMethodTreeViewer = new TreeViewer(this.beanMethodTree);
        this.beanMethodTreeViewer.setAutoExpandLevel(2);
    }

    protected void createInput() {
        this.beanMethodTreeViewer.setContentProvider((IContentProvider)new JavaBeanMethodTreeContentProvider());
        this.beanMethodTreeViewer.setLabelProvider((IBaseLabelProvider)new JavaBeanMethodTreeLabelProvider());
        this.beanMethodTreeViewer.setInput((Object)this.bean);
    }

    public Tree getTree() {
        return this.beanMethodTree;
    }

    public TreeViewer getTreeViewer() {
        return this.beanMethodTreeViewer;
    }

    public void setShowInheritedMethods(boolean showInheritedMethods) {
        this.showInheritedMethods = showInheritedMethods;
        this.beanMethodTreeViewer.setInput((Object)this.bean);
    }

    public boolean isShowActions() {
        return this.showActions;
    }

    public JavaHelpers getJavaClass(String rtType, IProject project) {
        JavaHelpers[] jclass = new JavaHelpers[1];
        JavaHelpers javaClass = null;
        try {
            JavaBeanMethodSelection.internalLoadJavaClass(rtType, jclass, project, (IProgressMonitor)new NullProgressMonitor());
            javaClass = jclass[0];
            if (javaClass != null && javaClass instanceof JavaClass && !((JavaClass)javaClass).isExistingType()) {
                throw new ClassNotFoundException(NLS.bind((String)ResourceHandler.UI_TYPE_NOT_FOUND, (Object[])new String[]{rtType}));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return javaClass;
    }

    static void internalLoadJavaClass(String rtType, JavaHelpers[] javaClass, IProject project, IProgressMonitor monitor) throws CoreException {
        if (rtType == null || rtType.length() == 0) {
            return;
        }
        monitor.beginTask(NLS.bind((String)"Introspecting", (Object[])new String[]{rtType}), 10);
        monitor.worked(1);
        BeaninfoNature nature = BeaninfoNature.getRuntime((IProject)project);
        ResourceSet rset = nature.getResourceSet();
        monitor.worked(3);
        String partialURI = null;
        int i = rtType.lastIndexOf(46);
        if (i > -1) {
            char[] chars = rtType.toCharArray();
            chars[i] = 35;
            partialURI = new String(chars);
        } else {
            partialURI = "#" + rtType;
        }
        monitor.worked(1);
        URI uri = URI.createURI((String)("java:/" + partialURI));
        javaClass[0] = (JavaHelpers)rset.getEObject(uri, true);
        monitor.done();
    }

    public final class ClassNode {
        public static final int ROOT_CLASS = 0;
        public static final int INHERITED_CLASS = 1;
        public JavaClass containingClass;
        public int classType;
    }

    public class JavaBeanMethodTreeContentProvider
    implements ITreeContentProvider {
        List<String> cachedMethodSigs = null;

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ClassNode) {
                List classMethods = ((ClassNode)parentElement).containingClass.getPublicMethods();
                ArrayList<MethodNode> methodsToShow = new ArrayList<MethodNode>();
                int i = 0;
                while (i < classMethods.size()) {
                    Method m = (Method)classMethods.get(i);
                    if (this.shouldShowMethod(m, (ClassNode)parentElement)) {
                        MethodNode mn = new MethodNode();
                        mn.methodType = 1;
                        mn.method = m;
                        methodsToShow.add(mn);
                        if (this.cachedMethodSigs != null) {
                            this.cachedMethodSigs.add(mn.method.getMethodElementSignature());
                        }
                    }
                    ++i;
                }
                Object[] methodNodeArray = methodsToShow.toArray(new MethodNode[methodsToShow.size()]);
                this.sort((MethodNode[])methodNodeArray);
                return methodNodeArray;
            }
            return null;
        }

        protected void sort(MethodNode[] methodNodes) {
            if (methodNodes != null && methodNodes.length > 1) {
                Arrays.sort(methodNodes, new Comparator(){

                    public int compare(Object a, Object b) {
                        return this.getName(a).compareToIgnoreCase(this.getName(b));
                    }

                    private String getName(Object methodNode) {
                        return ((MethodNode)methodNode).method.getName();
                    }
                });
            }
        }

        public boolean hasChildren(Object element) {
            if (element instanceof MethodNode) {
                return false;
            }
            return element instanceof ClassNode;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (JavaBeanMethodSelection.this.bean.getType() != null) {
                String className = JavaBeanMethodSelection.this.bean.getClassName();
                String sig = Signature.createTypeSignature((String)className, (boolean)true);
                String classNameErasure = Signature.toString((String)Signature.getTypeErasure((String)sig));
                JavaClass jClass = (JavaClass)JavaBeanMethodSelection.this.getJavaClass(classNameErasure, JavaBeanMethodSelection.this.bean.getPageDataModel().getResource().getProject());
                ArrayList<ClassNode> inheritedClassList = new ArrayList<ClassNode>();
                ClassNode baseClass = new ClassNode();
                baseClass.classType = 0;
                baseClass.containingClass = jClass;
                inheritedClassList.add(baseClass);
                if (JavaBeanMethodSelection.this.showInheritedMethods) {
                    List<JavaClass> interfaces;
                    JavaClass superType = jClass.getSupertype();
                    while (superType != null) {
                        if (superType.getPublicMethods().size() > 0) {
                            ClassNode node = new ClassNode();
                            node.containingClass = superType;
                            node.classType = 1;
                            inheritedClassList.add(node);
                        }
                        superType = superType.getSupertype();
                    }
                    if (jClass.isInterface() && (interfaces = this.getAllImplementedInterfaces(jClass)) != null) {
                        int i = 0;
                        while (i < interfaces.size()) {
                            if (interfaces.get(i).getPublicMethods().size() > 0) {
                                ClassNode node = new ClassNode();
                                node.containingClass = interfaces.get(i);
                                node.classType = 1;
                                inheritedClassList.add(node);
                            }
                            ++i;
                        }
                    }
                    this.cachedMethodSigs = new ArrayList<String>();
                }
                return inheritedClassList.toArray();
            }
            return null;
        }

        private List<JavaClass> getAllImplementedInterfaces(JavaClass classToWalk) {
            EList interfaces;
            ArrayList<JavaClass> allInterfaces = new ArrayList<JavaClass>();
            if (classToWalk != null && (interfaces = classToWalk.getImplementsInterfaces()) != null) {
                int i = 0;
                while (i < interfaces.size()) {
                    JavaClass anInterfaceToAdd = (JavaClass)interfaces.get(i);
                    allInterfaces.add(anInterfaceToAdd);
                    allInterfaces.addAll(this.getAllImplementedInterfaces(anInterfaceToAdd));
                    ++i;
                }
            }
            return allInterfaces;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        protected boolean shouldShowMethod(Method m) {
            return this.shouldShowMethod(m, null);
        }

        protected boolean shouldShowMethod(Method m, ClassNode classNode) {
            if (classNode != null && classNode.classType == 1 && this.cachedMethodSigs.contains(m.getMethodElementSignature())) {
                return false;
            }
            String sig = m.getMethodElementSignature();
            int i = 0;
            while (i < JavaBeanMethodSelection.this.beanMethodChildren.size()) {
                String childMethodSig = ((IJavaBeanMethodPDN)JavaBeanMethodSelection.this.beanMethodChildren.get(i)).getMethodSignature();
                if (sig.equals(childMethodSig)) {
                    return false;
                }
                ++i;
            }
            return !sig.equals("clone()") && !sig.equals("finalize()") && !sig.equals("hashCode()") && !sig.equals("notify()") && !sig.equals("notifyAll()") && !sig.equals("wait()") && !sig.equals("wait(long)") && !sig.equals("wait(long,int)") && !m.isConstructor();
        }
    }

    public class JavaBeanMethodTreeLabelProvider
    implements ILabelProvider {
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof MethodNode) {
                MethodNode methNode = (MethodNode)element;
                String text = String.valueOf(methNode.method.getMethodElementSignature()) + " (" + methNode.method.getReturnType().getName() + ")";
                if (methNode.methodType == 1) {
                    text = String.valueOf(text) + " - " + methNode.method.getContainingJavaClass().getJavaName();
                }
                return text;
            }
            if (element instanceof ClassNode) {
                return ((ClassNode)element).containingClass.getJavaName();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof MethodNode) {
                return JavaBeanPlugin.getDefault().getImage("full/obj16/jbmethod");
            }
            if (element instanceof ClassNode) {
                return JavaBeanPlugin.getDefault().getImage("full/obj16/jbroot");
            }
            return null;
        }

        public void dispose() {
        }
    }

    public final class MethodNode {
        public static final int METHOD = 0;
        public static final int INHERITED_METHOD = 1;
        public static final int ACTION = 2;
        public Method method;
        public int methodType;
    }
}

