/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.ICodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.javabean.ContainedTypePageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.FieldDefinition;
import com.ibm.etools.webtools.pagedataview.javabean.FieldFilter;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanMethodPDN;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanParamPDN;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanResultPDN;
import com.ibm.etools.webtools.pagedataview.javabean.JBActionDelegateAdapter;
import com.ibm.etools.webtools.pagedataview.javabean.JBBindingAttribute;
import com.ibm.etools.webtools.pagedataview.javabean.JBCodeGenModelFactory;
import com.ibm.etools.webtools.pagedataview.javabean.internal.introspection.IntrospectionHelper;
import com.ibm.etools.webtools.pagedataview.javabean.jbdata.JBAttributesFilter;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JavaBeanNodeViewAdapter;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JavaBeanPropertyViewAdapter;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.ParamBeanNodeViewAdapter;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.ResultBeanNodeViewAdapter;
import com.ibm.etools.webtools.pagedataview.javabean.util.JavaBeanPersistenceManager;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import com.ibm.etools.webtools.pagedataview.ui.internal.IActionDelegateAdapter;
import com.ibm.etools.webtools.pagedataview.util.PersistenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.java.Method;

public class JavaBeanPageDataNode
extends PageDataNode
implements IJavaBeanPageDataNode {
    public static final String RT_TYPE_METHOD = "java.lang.reflect.Method";
    private static JBCodeGenModelFactory fCodeGenModelFactory;
    private String className;
    private String instanceID;
    protected ArrayList methodChildren;
    protected ArrayList nonMethodChildren;
    protected boolean populatedChildren = false;
    protected IType type;
    protected boolean isCollection = false;
    protected int groupingType = -1;
    protected List filters;
    protected List<FieldFilter> fieldFilters;
    private static final List<String> typesWithNoChildren;
    private ILock lock;

    static {
        typesWithNoChildren = Arrays.asList("java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String");
    }

    public JavaBeanPageDataNode(IPageDataModel model, IPageDataNode parent) {
        super(model, parent);
        this.addDefaultFieldFilters();
    }

    public JavaBeanPageDataNode(IPageDataModel model, String clazzName, String instanceid) {
        this(model, model.getRoot());
        if (clazzName != null) {
            IFile currentFile = model.getResource();
            if (currentFile != null && currentFile.exists() && !IntrospectionHelper.isPrimitive(clazzName)) {
                this.initializeType(clazzName, instanceid);
            }
            this.className = clazzName;
            this.instanceID = instanceid;
        }
        this.addDefaultFieldFilters();
    }

    public JavaBeanPageDataNode(IPageDataModel model, String clazzName, String instanceid, boolean forceInit) {
        this(model, model.getRoot());
        IFile currentFile;
        if (forceInit && clazzName != null && (currentFile = model.getResource()) != null && currentFile.exists() && !IntrospectionHelper.isPrimitive(clazzName)) {
            this.initializeType(clazzName, instanceid);
        }
        this.className = clazzName;
        this.instanceID = instanceid;
        this.addDefaultFieldFilters();
    }

    protected IProject getProject() {
        return this.getPageDataModel().getResource().getProject();
    }

    @Deprecated
    protected void initializeJavaBeanPageDataNode(String className, JavaBeanPageDataNode node, String instanceId) {
        this.initializeType(className, instanceId);
    }

    protected void initializeType(String name, String id) {
        IType itype = null;
        try {
            itype = JavaCore.create((IProject)this.getProject()).findType(name);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.setType(itype);
        this.setGroupingType(IntrospectionHelper.getGroupingType(itype));
        this.setClassName(name);
        this.setInstanceID(id);
    }

    protected IBindingAttribute getBinding() {
        return JBBindingAttribute.getInstance();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPageDataNodeUIAttribute.ADAPTER_KEY)) {
            if (this instanceof IJavaBeanResultPDN) {
                return ResultBeanNodeViewAdapter.getInstance();
            }
            if (this instanceof IJavaBeanParamPDN) {
                return ParamBeanNodeViewAdapter.getInstance();
            }
            if (PageDataModelUtil.isComponentNode((IPageDataNode)this)) {
                return JavaBeanNodeViewAdapter.getInstance();
            }
            return JavaBeanPropertyViewAdapter.getInstance();
        }
        if (key.equals(IBindingAttribute.ADAPTER_KEY)) {
            return this.getBinding();
        }
        if (key.equals(IActionDelegateAdapter.class)) {
            return new JBActionDelegateAdapter();
        }
        return super.getAdapter(key);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    protected JavaBeanPageDataNode createChildNode(IPageDataModel pdModel, IPageDataNode parent) {
        return new JavaBeanPageDataNode(pdModel, parent);
    }

    protected ContainedTypePageDataNode createContainedTypePageDataNode(String parametizedType) {
        ContainedTypePageDataNode ctPDN = new ContainedTypePageDataNode(this.getPageDataModel(), this, parametizedType);
        return ctPDN;
    }

    protected boolean shouldPopulateChildren() {
        return super.getChildren() == null || !this.populatedChildren || this.getInstanceID() == null;
    }

    protected void initializeType() {
        String className = this.getClassName();
        if (className != null && !className.equals("")) {
            String typeSignature = null;
            try {
                typeSignature = Signature.getElementType((String)Signature.createTypeSignature((String)this.getClassName(), (boolean)true));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setType(null);
                return;
            }
            if (Signature.getTypeArguments((String)typeSignature).length > 0) {
                typeSignature = Signature.getTypeErasure((String)typeSignature);
            }
            IType itype = null;
            try {
                itype = JavaCore.create((IProject)this.getProject()).findType(Signature.toString((String)typeSignature));
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            this.setType(itype);
            this.setGroupingType(IntrospectionHelper.getGroupingType(itype));
        }
    }

    protected void populateChildren() {
        if (this.type == null) {
            this.initializeType();
        }
        if (this.type != null) {
            this.setGroupingType(IntrospectionHelper.getGroupingType(this.type));
            ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
            try {
                IType[] typePlusSuperTypes;
                ITypeHierarchy typeHierarchy = this.type.newSupertypeHierarchy(null);
                IType[] iTypeArray = typePlusSuperTypes = typeHierarchy.getAllTypes();
                int n = typePlusSuperTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    if (!t.getFullyQualifiedName().equals("java.lang.Object")) {
                        IMethod[] methods;
                        IMethod[] iMethodArray = methods = t.getMethods();
                        int n3 = methods.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMethod element = iMethodArray[n4];
                            allMethods.add(element);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            List<FieldDefinition> fieldDefinitions = this.findFields(allMethods);
            for (FieldDefinition f : fieldDefinitions) {
                JavaBeanPageDataNode child = this.createChildNode(this.getPageDataModel(), this);
                child.setInstanceID(f.name);
                child.setClassName(f.fullyQualifiedType);
                this.addChildWithoutNotification(child);
            }
            if (IntrospectionHelper.isCollectionType(this.type)) {
                this.isCollection = true;
                String parametizedType = IntrospectionHelper.getContainedType(this.getClassName());
                ContainedTypePageDataNode ctPDN = this.createContainedTypePageDataNode(parametizedType);
                this.addChildWithoutNotification(ctPDN);
            }
        } else {
            this.setGroupingType(0);
        }
    }

    private List<FieldDefinition> findFields(List<IMethod> allMethods) {
        ArrayList<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        while (!allMethods.isEmpty()) {
            String methodName;
            String fieldName;
            IMethod method = allMethods.remove(0);
            String returnType = IntrospectionHelper.getFullyQualifiedType(method);
            if (returnType == null || this.fieldAlreadyFound(fields, fieldName = IntrospectionHelper.decapitalizePropertyMethod(methodName = method.getElementName()), returnType) || this.isJunkProperty(fieldName)) continue;
            FieldDefinition def = new FieldDefinition(fieldName, returnType);
            fields.add(def);
        }
        List<FieldFilter> filters = this.getFieldFilters();
        if (filters != null) {
            int i = 0;
            while (i < filters.size()) {
                fields.removeAll(filters.get(i).filter(fields));
                ++i;
            }
        }
        return fields;
    }

    private boolean isJunkProperty(String fieldName) {
        boolean isJunk = false;
        if (this.className != null && fieldName != null && ((this.className.equals("java.lang.String") || this.className.equals("java.lang.String[]")) && fieldName.equals("bytes") || this.className.contains("java.") && fieldName.equals("empty"))) {
            isJunk = true;
        }
        return isJunk;
    }

    private boolean fieldAlreadyFound(List<FieldDefinition> fields, String name, String fullyQualifiedType) {
        for (FieldDefinition f : fields) {
            if (!f.name.equals(name) || !f.fullyQualifiedType.equals(fullyQualifiedType)) continue;
            return true;
        }
        return false;
    }

    public final EList getChildren() {
        EList children = super.getChildren();
        if (this.shouldPopulateChildren()) {
            try {
                try {
                    this.getLock().acquire();
                    if (!this.populatedChildren) {
                        this.populateChildren();
                        this.populatedChildren = true;
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.getLock().release();
                }
            }
            finally {
                this.getLock().release();
            }
        }
        return children;
    }

    @Override
    public String getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(String instanceID) {
        this.instanceID = instanceID;
    }

    public boolean hasChildren() {
        return !JavaTypeUtil.isPrimitive((String)this.getClassName()) && !typesWithNoChildren.contains(this.getClassName());
    }

    public IPageDataNode copy() {
        int i;
        JavaBeanPageDataNode ret = new JavaBeanPageDataNode(this.getPageDataModel(), this.getParent());
        if (this.getCategory() != null) {
            ret.setCategory(this.getCategory());
        }
        if (this.getClassName() != null) {
            ret.setClassName(this.getClassName());
        }
        if (this.getInstanceID() != null) {
            ret.setInstanceID(this.getInstanceID());
        }
        if (this.getType() != null) {
            ret.setType(this.getType());
        }
        if (this.filters != null) {
            i = 0;
            while (i < this.filters.size()) {
                ret.addFilter((JBAttributesFilter)this.filters.get(i));
                ++i;
            }
        }
        if (this.fieldFilters != null) {
            i = 0;
            while (i < this.fieldFilters.size()) {
                ret.addFieldFilter(this.fieldFilters.get(i));
                ++i;
            }
        }
        return ret;
    }

    public List getFilters() {
        return this.filters;
    }

    public void addFilter(JBAttributesFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList(3);
        }
        this.filters.add(filter);
    }

    public void addFieldFilter(FieldFilter filter) {
        if (this.fieldFilters == null) {
            this.fieldFilters = new ArrayList<FieldFilter>(3);
        }
        this.fieldFilters.add(filter);
    }

    protected void addDefaultFilters(JavaBeanPageDataNode pdNode) {
    }

    protected void addDefaultFieldFilters() {
    }

    public ICodeGenModelFactory getCodeGenModelFactory() {
        if (fCodeGenModelFactory == null) {
            fCodeGenModelFactory = new JBCodeGenModelFactory();
        }
        return fCodeGenModelFactory;
    }

    protected PersistenceManager getPersistenceManager() {
        return JavaBeanPersistenceManager.getJBInstance();
    }

    @Override
    public List getMethodChildren() {
        this.sortChildren();
        return this.methodChildren;
    }

    @Override
    public List getNonMethodChildren() {
        this.sortChildren();
        return this.nonMethodChildren;
    }

    private void sortChildren() {
        if (this.methodChildren == null || this.nonMethodChildren == null || this.getChildren().size() != this.methodChildren.size() + this.nonMethodChildren.size()) {
            this.methodChildren = new ArrayList();
            this.nonMethodChildren = new ArrayList();
            EList children = this.getChildren();
            for (IPageDataNode child : children) {
                if (child instanceof IJavaBeanMethodPDN) {
                    this.methodChildren.add(child);
                    continue;
                }
                if (child instanceof PageActionNode) continue;
                this.nonMethodChildren.add(child);
            }
        }
    }

    @Override
    public void addJavaBeanMethod(Method method) {
    }

    public boolean isChildrenPopulated() {
        return this.populatedChildren;
    }

    public boolean refresh(Object associatedNode, Object changedFeature, Object oldValue, Object newValue) {
        this.initializeType(this.getClassName(), this.getInstanceID());
        this.getChildren().clear();
        this.nonMethodChildren = null;
        this.populatedChildren = false;
        this.childrenPopulated = false;
        return true;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    public void setType(IType type) {
        this.type = type;
    }

    public int getGroupingType() {
        if (this.groupingType == -1) {
            this.initializeType();
        }
        return this.groupingType;
    }

    public void setGroupingType(int groupingType) {
        this.groupingType = groupingType;
    }

    private ILock getLock() {
        if (this.lock == null) {
            this.lock = Job.getJobManager().newLock();
        }
        return this.lock;
    }

    public List<FieldFilter> getFieldFilters() {
        return this.fieldFilters;
    }
}

