/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedataview.javabean;

import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedataview.javabean.ContainedTypeBindingAttribute;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanMethodPDN;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanParamPDN;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanResultPDN;
import com.ibm.etools.webtools.pagedataview.javabean.JavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.nls.ResourceHandler;
import com.ibm.etools.webtools.pagedataview.javabean.util.JavaBeanModelUtil;
import java.util.ArrayList;
import org.eclipse.jdt.core.Signature;

public class JBBindingAttribute
implements IBindingAttribute {
    private static JBBindingAttribute singleton;

    public static IBindingAttribute getInstance() {
        if (singleton == null) {
            singleton = new JBBindingAttribute();
        }
        return singleton;
    }

    public String getName(IPageDataNode object) {
        String ret = null;
        if (object instanceof JavaBeanPageDataNode) {
            ret = ((JavaBeanPageDataNode)object).getInstanceID();
        }
        return ret;
    }

    public String getReferenceString(IPageDataNode object) {
        if (object == null || object.getParent() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<IPageDataNode> nodes = new ArrayList<IPageDataNode>();
        IBindingAttribute binding = null;
        while (object.getParent() != null) {
            nodes.add(0, object);
            object = object.getParent();
        }
        int i = 0;
        while (i < nodes.size()) {
            IPageDataNode child = (IPageDataNode)nodes.get(i);
            if (!(child instanceof IJavaBeanMethodPDN)) {
                if (child instanceof IJavaBeanParamPDN || child instanceof IJavaBeanResultPDN) {
                    sb.delete(0, sb.length());
                }
                if ((binding = (IBindingAttribute)child.getAdapter(IBindingAttribute.ADAPTER_KEY)) instanceof ContainedTypeBindingAttribute) {
                    sb.deleteCharAt(sb.length() - 1);
                } else {
                    sb.append(binding.getName(child));
                }
                if (JavaBeanModelUtil.isCollection(binding.getCollectionType(child)) || binding.isArrayType(child)) {
                    sb.append("[0]");
                }
                if (i < nodes.size() - 1) {
                    sb.append(".");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String getRuntimeType(IPageDataNode object) {
        JavaBeanPageDataNode pdNode = (JavaBeanPageDataNode)object;
        return pdNode.getClassName();
    }

    public String getTypeAsString(IPageDataNode object) {
        return ResourceHandler.UI_BeanObj;
    }

    public String getRelativeReferenceString(IPageDataNode refNode, IPageDataNode object) {
        String fullRef = this.getReferenceString(object);
        if (refNode == null) {
            return fullRef;
        }
        String startRef = this.getReferenceString(refNode);
        if (fullRef.equals(startRef)) {
            return "";
        }
        if (fullRef.startsWith(String.valueOf(startRef) + ".")) {
            return fullRef.substring(startRef.length() + 1);
        }
        return fullRef;
    }

    public boolean isArrayType(IPageDataNode object) {
        String typeSignature;
        JavaBeanPageDataNode jbNode = (JavaBeanPageDataNode)object;
        boolean isResolved = false;
        if (jbNode.getType() != null && jbNode.getType().isResolved()) {
            isResolved = true;
        }
        return Signature.getArrayCount((String)(typeSignature = Signature.createTypeSignature((String)jbNode.getClassName(), (boolean)isResolved))) > 0;
    }

    public int getCollectionType(IPageDataNode object) {
        JavaBeanPageDataNode jbPDNode = (JavaBeanPageDataNode)object;
        return jbPDNode.getGroupingType();
    }
}

