/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wdotags.actions;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.codebehind.api.CodeBehindLanguageRegistry;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.api.ICBLanguageFactory;
import com.ibm.etools.webtools.codebehind.api.ILocationGenerator;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.internal.ui.PageCodeConfirmation;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.JSFJavaBeanDataModel;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.PublicMonitorWizardDialog;
import com.ibm.etools.webtools.codebehind.jsf.wizards.internal.JSFManagedBeanWizard;
import com.ibm.etools.webtools.codebehind.jsf.wizards.internal.JSFPageCodeBeanWizard;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.api.WebModel;
import com.ibm.etools.webtools.model.util.ModelUtil;
import com.ibm.etools.webtools.pagedataview.javabean.codebehind.wizard.AbstractJavaJSFDropCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSFJavaBeanDropCommand
extends AbstractJavaJSFDropCommand {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private boolean isManagedBean = false;

    public JSFJavaBeanDropCommand(HTMLEditDomain editDomain, String codeGenModelId) {
        super(editDomain, codeGenModelId);
    }

    public JSFJavaBeanDropCommand(HTMLEditDomain editDomain, String codeGenModelId, boolean isManagedBean) {
        super(editDomain, codeGenModelId);
        this.isManagedBean = isManagedBean;
    }

    @Override
    protected void handleDrop() {
        IDOMModel activeModel = this.fEditDomain.getActiveModel();
        IFile file = ModelUtil.getFileFor((IDOMModel)activeModel);
        JSP jsp = null;
        try {
            WebModel webModel = ModelUtil.getModel((IResource)file);
            jsp = webModel.getJSP(file);
        }
        catch (WebModelCreationException ex) {
            ex.printStackTrace();
        }
        JSFJavaBeanDataModel dataModel = new JSFJavaBeanDataModel(jsp);
        dataModel.setManagedBean(this.isManagedBean);
        Object wizard = null;
        wizard = this.isManagedBean ? new JSFManagedBeanWizard(this.fIsDisplayUI, dataModel) : new JSFPageCodeBeanWizard(this.fIsDisplayUI, dataModel);
        PublicMonitorWizardDialog dialog = new PublicMonitorWizardDialog(this.fEditDomain.getDialogParent(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), dialog.getShell().getSize().y);
        dialog.open();
    }

    @Override
    public void execute() {
        if (this.isManagedBean) {
            this.handleDrop();
        } else {
            IDOMDocument doc = null;
            IDOMModel model = this.fEditDomain.getActiveModel();
            if (model != null) {
                doc = model.getDocument();
            }
            if (PageCodeConfirmation.isPageCodeOK((Shell)this.getShell(), (IDOMDocument)doc)) {
                if (PageCodeConfirmation.getLanguage((IDOMDocument)doc).equals("none")) {
                    ICBLanguage cbAdapter = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)doc);
                    ICBLanguageFactory javaFactory = CodeBehindLanguageRegistry.getRegistry().getCodeBehindLanguageFactory("java");
                    ILocationGenerator locGen = javaFactory.getLocationGenerator();
                    IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)doc);
                    IPath newPath = locGen.getLocationForJSP(jspFile);
                    cbAdapter.switchLanguage("java", newPath, false);
                }
                this.handleDrop();
            }
        }
    }
}

