/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.managedbean.pagedata;

import com.ibm.etools.jsf.facesconfig.util.FacesResourceChangeListener;
import com.ibm.etools.jsf.facesconfig.util.IFacesConfigChangeEvent;
import com.ibm.etools.jsf.facesconfig.util.IFacesConfigChangeListener;
import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import com.ibm.etools.jsf.util.IFacesConfigResourceCollection;
import com.ibm.etools.jsf.util.IFacesConfigResourceCollectionListener;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfFacesConfigUtil;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.internal.CBLanguageAdapter;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.IManagedBeanPageDataNode;
import com.ibm.etools.webtools.codebehind.pdm.data.nodes.ManagedBeanPageDataNode;
import com.ibm.etools.webtools.managedbean.pagedata.IManagedBeanNodeProvider;
import com.ibm.etools.webtools.managedbean.pagedata.ManagedBeanNodeProviderDefinition;
import com.ibm.etools.webtools.managedbean.pagedata.ManagedBeanNodeProviderRegistryReader;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.IJavaBeanPageDataNode;
import com.ibm.etools.webtools.pagedataview.javabean.ui.internal.JavaModelSynchronizer;
import com.ibm.etools.webtools.pagedataview.ui.CategoryChangeNotifier;
import com.ibm.etools.webtools.referencedbean.pagedata.ReferencedBeanPageDataNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class ManagedBeanPDMListener
implements IPageDataModelLifeCycleListener,
IFacesConfigChangeListener,
IFacesConfigResourceCollectionListener {
    private List pageDataRootNodes = new ArrayList();
    private boolean listenerAdded = false;
    private static final String MANAGED_BEAN_CATEGORY_ID = "FacesManagedBean";
    private static final String REFERENCED_BEAN_CATEGORY_ID = "FacesReferencedBean";

    public void pageDataModelInitialized(final IPageDataModel pmodel) {
        IDOMDocument doc;
        IDOMModel model = ((PageDataModel)pmodel).getIDOMModel();
        if (model.getContentTypeIdentifier().equals(ContentTypeIdForJSP.ContentTypeID_JSP) && JsfComponentUtil.isJsfPage((Document)(doc = model.getDocument()))) {
            CBLanguageAdapter cbAdapter = (CBLanguageAdapter)doc.getAdapterFor(ICBLanguage.class);
            CBLanguageInfo cbInfo = null;
            if (cbAdapter != null) {
                cbInfo = cbAdapter.getCBInfo();
            }
            if (cbInfo == null || cbInfo.language.equalsIgnoreCase("java") || cbInfo.language.equalsIgnoreCase("none")) {
                this.pageDataRootNodes.add(pmodel.getRoot());
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ManagedBeanPDMListener.this.refreshBeans(pmodel.getRoot());
                        IFacesConfigResourceCollection collection = JsfFacesConfigUtil.getResourceCollection((IProject)pmodel.getResource().getProject());
                        ManagedBeanPDMListener.this.refreshJarredBeans(collection, pmodel.getRoot());
                    }
                });
                if (!this.listenerAdded) {
                    FacesResourceChangeListener.getFacesResourceChangeListener().addFacesConfigChangeListener((IFacesConfigChangeListener)this);
                    JsfFacesConfigUtil.addCollectionChangedListener((IFacesConfigResourceCollectionListener)this);
                    this.listenerAdded = true;
                }
            }
        }
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        int i = 0;
        while (i < this.pageDataRootNodes.size()) {
            IPageDataNode root = (IPageDataNode)this.pageDataRootNodes.get(i);
            if (root.getPageDataModel() == model) {
                this.pageDataRootNodes.remove(i);
                break;
            }
            ++i;
        }
        if (this.pageDataRootNodes.isEmpty()) {
            FacesResourceChangeListener.getFacesResourceChangeListener().removeFacesConfigChangeListener((IFacesConfigChangeListener)this);
            JsfFacesConfigUtil.removeCollectionChangedListener((IFacesConfigResourceCollectionListener)this);
            this.listenerAdded = false;
        }
    }

    public void resourceChanged(IFacesConfigChangeEvent event) {
        if (event.isManagedBeanChanged()) {
            int i = 0;
            while (i < this.pageDataRootNodes.size()) {
                final IPageDataNode root = (IPageDataNode)this.pageDataRootNodes.get(i);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ManagedBeanPDMListener.this.refreshBeans(root);
                    }
                });
                ++i;
            }
        }
    }

    public void collectionChanged(IProject changedProject) {
        ArrayList<IPageDataNode> rootsToRefresh = new ArrayList<IPageDataNode>();
        int i = 0;
        while (i < this.pageDataRootNodes.size()) {
            IPageDataNode root = (IPageDataNode)this.pageDataRootNodes.get(i);
            if (root.getPageDataModel().getResource().getProject() == changedProject) {
                rootsToRefresh.add(root);
            }
            ++i;
        }
        IFacesConfigResourceCollection newCollection = JsfFacesConfigUtil.getResourceCollection((IProject)changedProject);
        int i2 = 0;
        while (i2 < rootsToRefresh.size()) {
            this.refreshJarredBeans(newCollection, (IPageDataNode)rootsToRefresh.get(i2));
            ++i2;
        }
        CategoryChangeNotifier.getSingleton().fireCategoryChanged(MANAGED_BEAN_CATEGORY_ID, false);
    }

    public void collectionRemoved(IProject changedProject) {
        ArrayList<IPageDataNode> rootsToRefresh = new ArrayList<IPageDataNode>();
        int i = 0;
        while (i < this.pageDataRootNodes.size()) {
            IPageDataNode root = (IPageDataNode)this.pageDataRootNodes.get(i);
            if (root.getPageDataModel().getResource().getProject() == changedProject) {
                rootsToRefresh.add(root);
            }
            ++i;
        }
        i = 0;
        while (i < rootsToRefresh.size()) {
            this.removeAllJarredBeans((IPageDataNode)rootsToRefresh.get(i));
            ++i;
        }
        CategoryChangeNotifier.getSingleton().fireCategoryChanged(MANAGED_BEAN_CATEGORY_ID, false);
    }

    protected void refreshBeans(IPageDataNode root) {
        IFile jsfPage = root.getPageDataModel().getResource();
        IVirtualComponent component = ComponentUtilities.findComponent((IResource)jsfPage);
        if (component == null) {
            return;
        }
        ArrayList<String> updatedCategories = new ArrayList<String>(1);
        EList allChildren = root.getChildren();
        ArrayList<String> managedBeanNames = new ArrayList<String>();
        ArrayList<String> managedBeanTypes = new ArrayList<String>();
        int size = allChildren.size();
        int i = size - 1;
        while (i >= 0) {
            IPageDataNode node = (IPageDataNode)allChildren.get(i);
            if ((MANAGED_BEAN_CATEGORY_ID.equals(node.getCategory()) || REFERENCED_BEAN_CATEGORY_ID.equals(node.getCategory()) || node instanceof IManagedBeanPageDataNode) && !this.isManagedBeanFromJar(node)) {
                String category;
                String name = ((IManagedBeanPageDataNode)node).getInstanceID();
                String type = ((IManagedBeanPageDataNode)node).getClassName();
                if (node instanceof IManagedBeanPageDataNode) {
                    managedBeanNames.add(name);
                    managedBeanTypes.add(type);
                }
                if ((category = node.getCategory()) != null && !updatedCategories.contains(category)) {
                    updatedCategories.add(category);
                }
                ((PageDataNode)root).removeChildWithoutNotification(node);
                JavaModelSynchronizer.disconnect((IJavaBeanPageDataNode)((IManagedBeanPageDataNode)node));
            }
            --i;
        }
        this.refreshManagedBeans(root, jsfPage.getProject(), updatedCategories);
        this.refreshReferencedBeans(root, jsfPage.getProject());
    }

    private void refreshReferencedBeans(IPageDataNode root, IProject project) {
        String[] configFilePaths;
        FacesConfigArtifactEdit edit = null;
        String[] stringArray = configFilePaths = JSFFacesConfigUtil.getFacesConfigPaths((IProject)project);
        int n = configFilePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            try {
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)element);
                if (edit != null && edit.getFacesConfig() != null) {
                    EList refBeans = edit.getFacesConfig().getReferencedBean();
                    int j = 0;
                    while (j < refBeans.size()) {
                        ReferencedBeanType refBean = (ReferencedBeanType)refBeans.get(j);
                        String sName = refBean.getReferencedBeanName() != null ? refBean.getReferencedBeanName().getTextContent() : null;
                        String sType = refBean.getReferencedBeanClass() != null ? refBean.getReferencedBeanClass().getTextContent() : null;
                        ReferencedBeanPageDataNode rbPDN = new ReferencedBeanPageDataNode(root.getPageDataModel(), sType, sName);
                        ((PageDataNode)root).addChildWithoutNotification((IPageDataNode)rbPDN);
                        JavaModelSynchronizer.connect((IJavaBeanPageDataNode)rbPDN);
                        ++j;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
            ++n2;
        }
        CategoryChangeNotifier.getSingleton().fireCategoryChanged(REFERENCED_BEAN_CATEGORY_ID);
    }

    private void refreshManagedBeans(IPageDataNode root, IProject project, List<String> updatedCategories) {
        String[] configFilePaths;
        String[] stringArray = configFilePaths = JSFFacesConfigUtil.getFacesConfigPaths((IProject)project);
        int n = configFilePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            FacesConfigArtifactEdit edit = null;
            try {
                EList managedBeans;
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)element);
                if (edit != null && edit.getFacesConfig() != null && (managedBeans = edit.getFacesConfig().getManagedBean()).size() > 0) {
                    List<ManagedBeanNodeProviderDefinition> list = ManagedBeanNodeProviderRegistryReader.getRegistry().getNodeProviders(project);
                    int j = 0;
                    while (j < managedBeans.size()) {
                        ManagedBeanPageDataNode managedBeanNode = null;
                        ManagedBeanType managedBean = (ManagedBeanType)managedBeans.get(j);
                        String sName = managedBean.getManagedBeanName() != null ? managedBean.getManagedBeanName().getTextContent() : null;
                        String sType = managedBean.getManagedBeanClass() != null ? managedBean.getManagedBeanClass().getTextContent() : null;
                        boolean provide = false;
                        for (ManagedBeanNodeProviderDefinition definition : list) {
                            IManagedBeanNodeProvider provider = definition.getProvider();
                            if (provider == null) continue;
                            try {
                                String category;
                                provide = provider.shouldProvide(root.getPageDataModel(), sName, sType);
                                if (!provide) continue;
                                managedBeanNode = provider.createPageDataNode(root.getPageDataModel(), sName, sType);
                                if (managedBeanNode == null || (category = managedBeanNode.getCategory()) == null || updatedCategories.contains(category)) break;
                                updatedCategories.add(category);
                                break;
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!provide) {
                            managedBeanNode = this.createDefaultManagedBeanNode(root, sName, sType);
                            if (!updatedCategories.contains(MANAGED_BEAN_CATEGORY_ID)) {
                                updatedCategories.add(MANAGED_BEAN_CATEGORY_ID);
                            }
                        }
                        if (managedBeanNode != null && managedBeanNode.getType() != null) {
                            ((PageDataNode)root).addChildWithoutNotification((IPageDataNode)managedBeanNode);
                            JavaModelSynchronizer.connect((IJavaBeanPageDataNode)managedBeanNode);
                        }
                        ++j;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
            ++n2;
        }
        for (String category : updatedCategories) {
            CategoryChangeNotifier.getSingleton().fireCategoryChanged(category, false);
        }
    }

    private ManagedBeanPageDataNode createDefaultManagedBeanNode(IPageDataNode root, String sName, String sType) {
        ManagedBeanPageDataNode mbPDN = new ManagedBeanPageDataNode(root.getPageDataModel(), sType, sName);
        mbPDN.setClassName(sType);
        mbPDN.setInstanceID(sName);
        return mbPDN;
    }

    protected void refreshJarredBeans(IFacesConfigResourceCollection collection, IPageDataNode root) {
        FacesConfigType[] staticConfigs;
        int numRemoved = this.removeAllJarredBeans(root);
        int numAdded = 0;
        FacesConfigType[] facesConfigTypeArray = staticConfigs = collection.getModels(3);
        int n = staticConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            FacesConfigType type = facesConfigTypeArray[n2];
            EList managedBeans = type.getManagedBean();
            int j = 0;
            while (j < managedBeans.size()) {
                String sName = ((ManagedBeanType)managedBeans.get(j)).getManagedBeanName() != null ? ((ManagedBeanType)managedBeans.get(j)).getManagedBeanName().getTextContent() : null;
                String sType = ((ManagedBeanType)managedBeans.get(j)).getManagedBeanClass() != null ? ((ManagedBeanType)managedBeans.get(j)).getManagedBeanClass().getTextContent() : null;
                ManagedBeanPageDataNode mbPDN = new ManagedBeanPageDataNode(root.getPageDataModel(), sType, sName);
                mbPDN.setFromJar(true);
                ((PageDataNode)root).addChildWithoutNotification((IPageDataNode)mbPDN);
                ++numAdded;
                ++j;
            }
            ++n2;
        }
        if (numRemoved != 0 || numAdded != 0) {
            CategoryChangeNotifier.getSingleton().fireCategoryChanged(MANAGED_BEAN_CATEGORY_ID);
        }
    }

    private int removeAllJarredBeans(IPageDataNode root) {
        EList allChildren = root.getChildren();
        int numRemoved = 0;
        int size = allChildren.size();
        int i = size - 1;
        while (i >= 0) {
            IPageDataNode node = (IPageDataNode)allChildren.get(i);
            if (MANAGED_BEAN_CATEGORY_ID.equals(node.getCategory()) && this.isManagedBeanFromJar(node)) {
                ((PageDataNode)root).removeChildWithoutNotification(node);
                ++numRemoved;
            }
            --i;
        }
        return numRemoved;
    }

    private boolean isManagedBeanFromJar(IPageDataNode node) {
        return node instanceof IManagedBeanPageDataNode && ((IManagedBeanPageDataNode)node).isFromJar();
    }

    public void pageDataModelToBeInitialized(IPageDataModel model) {
    }

    public void pageDataModelReleased() {
    }
}

