/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.managedbean.pagedata;

import com.ibm.etools.webtools.managedbean.pagedata.ManagedBeanNodeProviderDefinition;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ManagedBeanNodeProviderRegistryReader {
    private static String EXT_PT_ID_NODEPROVIDER = "com.ibm.etools.webtools.pagedataview.javabean.codebehind.IManagedBeanNodeProvider";
    private List<ManagedBeanNodeProviderDefinition> nodeProviders;
    private static ManagedBeanNodeProviderRegistryReader theInstance;

    private ManagedBeanNodeProviderRegistryReader() {
    }

    public static ManagedBeanNodeProviderRegistryReader getRegistry() {
        if (theInstance == null) {
            theInstance = new ManagedBeanNodeProviderRegistryReader();
        }
        return theInstance;
    }

    public void processDefinitions() {
        IExtensionRegistry pluginRegistry;
        IExtensionPoint updaters;
        if (this.nodeProviders == null) {
            this.nodeProviders = new ArrayList<ManagedBeanNodeProviderDefinition>(2);
        }
        if ((updaters = (pluginRegistry = Platform.getExtensionRegistry()).getExtensionPoint(EXT_PT_ID_NODEPROVIDER)) != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = updaters.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equalsIgnoreCase("nodeprovider")) {
                    ManagedBeanNodeProviderDefinition langDef = new ManagedBeanNodeProviderDefinition(element);
                    this.nodeProviders.add(langDef);
                }
                ++n2;
            }
        }
    }

    public List<ManagedBeanNodeProviderDefinition> getNodeProviders(IProject project) {
        if (this.nodeProviders == null) {
            this.processDefinitions();
        }
        ArrayList<ManagedBeanNodeProviderDefinition> validProviders = new ArrayList<ManagedBeanNodeProviderDefinition>(1);
        for (ManagedBeanNodeProviderDefinition def : this.nodeProviders) {
            boolean hasAllRequiredFacets = this.hasAllRequiredFacets(project, def);
            if (!hasAllRequiredFacets) continue;
            validProviders.add(def);
        }
        return validProviders;
    }

    private boolean hasAllRequiredFacets(IProject project, ManagedBeanNodeProviderDefinition def) {
        boolean hasAllRequiredFacets = true;
        IFacetedProject facetedProject = null;
        if (def.getRequiredFacets() != null) {
            if (facetedProject == null && project != null) {
                try {
                    facetedProject = ProjectFacetsManager.create((IProject)project);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (facetedProject != null) {
                StringTokenizer values = new StringTokenizer(def.getRequiredFacets(), ",");
                while (hasAllRequiredFacets && values.hasMoreTokens()) {
                    String facetID = values.nextToken().trim();
                    IProjectFacet requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID);
                    if (requiredFacet == null || facetedProject.hasProjectFacet(requiredFacet)) continue;
                    hasAllRequiredFacets = false;
                }
            }
        }
        return hasAllRequiredFacets;
    }
}

