/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.managedbean.pagedata;

import com.ibm.etools.webtools.codebehind.pdm.data.nodes.ManagedBeanPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class FacesManagedBeanFilter
extends ViewerFilter {
    private String[] configFilePaths;
    private IProject project;
    private List beansToShow = new ArrayList();

    public FacesManagedBeanFilter(String[] paths, IProject proj) {
        this.configFilePaths = paths;
        this.project = proj;
        this.determineBeansToShow();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String beanIdentifier;
        if (!(element instanceof ManagedBeanPageDataNode)) {
            return true;
        }
        ManagedBeanPageDataNode mbpdn = (ManagedBeanPageDataNode)element;
        return !PageDataModelUtil.isComponentNode((IPageDataNode)mbpdn) || this.beansToShow.contains(beanIdentifier = mbpdn.getInstanceID()) || mbpdn.isFromJar();
    }

    public void setConfigFilePaths(String[] paths) {
        this.configFilePaths = paths;
    }

    public String[] getConfigFilePaths() {
        return this.configFilePaths;
    }

    private void determineBeansToShow() {
        int i = 0;
        while (i < this.configFilePaths.length) {
            FacesConfigArtifactEdit edit = null;
            try {
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)this.project, (String)this.configFilePaths[i]);
                FacesConfigType facesConfig = edit.getFacesConfig();
                if (facesConfig != null) {
                    EList managedBeans = facesConfig.getManagedBean();
                    int j = 0;
                    while (j < managedBeans.size()) {
                        ManagedBeanType managedBean = (ManagedBeanType)managedBeans.get(j);
                        String sName = managedBean.getManagedBeanName() != null ? managedBean.getManagedBeanName().getTextContent() : null;
                        this.beansToShow.add(sName);
                        ++j;
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
            ++i;
        }
    }
}

