/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards.internal;

import com.ibm.etools.webtools.pagedatamodel.wizards.internal.MultiEditorTableViewer;
import com.ibm.etools.webtools.pagedatamodel.wizards.internal.SnappyCombo;
import java.text.MessageFormat;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SnappyComboCellEditor
extends CellEditor {
    private String[] fItems;
    private int fSelection;
    private SnappyCombo fComboBox;

    public SnappyComboCellEditor(int style) {
        this.setStyle(style);
    }

    public String[] getItems() {
        return this.fItems;
    }

    public void setItems(String[] items, boolean showButton, boolean canHaveEmbeddedForm) {
        Assert.isNotNull((Object)items);
        this.fItems = items;
        if (this.fComboBox != null && this.fItems != null) {
            this.fComboBox.removeAll();
            this.fComboBox.setItems(this.fItems, showButton, canHaveEmbeddedForm);
            this.setValueValid(true);
            this.fSelection = 0;
        }
    }

    protected Control createControl(Composite parent) {
        this.fComboBox = new SnappyCombo(parent, this.getStyle());
        this.fComboBox.setFont(parent.getFont());
        this.fComboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SnappyComboCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.fComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MultiEditorTableViewer.IS_GTK) {
                    if (SnappyComboCellEditor.this.isActivated()) {
                        SnappyComboCellEditor.this.applyEditorValueAndDeactivate();
                    }
                } else {
                    TableItem item = ((TableEditor)SnappyComboCellEditor.this.fComboBox.getData()).getItem();
                    ((MultiEditorTableViewer)((Object)item.getData("viewer"))).saveEditorValue(SnappyComboCellEditor.this, (Item)item);
                }
                SnappyComboCellEditor.this.fComboBox.updateButtonState();
            }
        });
        this.fComboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.fComboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SnappyComboCellEditor.this.focusLost();
            }

            public void focusGained(FocusEvent e) {
                SnappyComboCellEditor.this.focusGained();
            }
        });
        return this.fComboBox;
    }

    public void deactivate() {
        if (MultiEditorTableViewer.IS_GTK) {
            super.deactivate();
        }
    }

    protected Object doGetValue() {
        return new Integer(this.fSelection);
    }

    protected void doSetFocus() {
        this.fComboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.fComboBox == null || this.fComboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.fComboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.fComboBox != null && value instanceof Integer ? 1 : 0) != 0);
        this.fSelection = (Integer)value;
        this.fComboBox.select(this.fSelection);
    }

    protected void applyEditorValueAndDeactivate() {
        this.fSelection = this.fComboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.fItems[this.fSelection]));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
    }

    protected void focusGained() {
        if (!MultiEditorTableViewer.IS_GTK) {
            TableEditor tEditor = (TableEditor)this.fComboBox.getData();
            Table table = tEditor.getItem().getParent();
            table.setSelection(table.indexOf(tEditor.getItem()));
            table.notifyListeners(13, new Event());
            this.doSetFocus();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }
}

