/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.pagedatamodel.wizards.internal;

import com.ibm.etools.webtools.flatui.SnappyCheckboxTableViewer;
import com.ibm.etools.webtools.flatui.TableViewerImpl;
import com.ibm.etools.webtools.pagedatamodel.wizards.internal.FocusTextCellEditor;
import com.ibm.etools.webtools.pagedatamodel.wizards.internal.LabelCellEditor;
import com.ibm.etools.webtools.pagedatamodel.wizards.internal.SnappyComboCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MultiEditorTableViewer
extends SnappyCheckboxTableViewer {
    public static final int NULL = 0;
    public static final int TEXT = 1;
    public static final int COMBO = 2;
    public static final int LABEL = 3;
    public static boolean IS_GTK = SWT.getPlatform().equalsIgnoreCase("gtk");
    private TableItem fSelectedItem = null;
    private Color fColorSelectedActiveBackground = Display.getDefault().getSystemColor(26);
    private Color fColorSelectedActiveForeground = Display.getDefault().getSystemColor(27);
    private Color fColorSelectedInActiveBackground = Display.getDefault().getSystemColor(19);
    private Color fColorSelectedInActiveForeground = Display.getDefault().getSystemColor(24);
    private Color fColorDefaultBackground = Display.getDefault().getSystemColor(25);
    private Color fColorDefaultForeground = Display.getDefault().getSystemColor(24);

    public MultiEditorTableViewer(Table table) {
        super(table);
    }

    protected void initTableViewerImpl() {
        this.fTableViewerImpl = new MultiEditorTableViewerImpl(){

            protected Rectangle getBounds(Item item, int columnNumber) {
                return ((TableItem)item).getBounds(columnNumber);
            }

            protected int getColumnCount() {
                return MultiEditorTableViewer.this.getTable().getColumnCount();
            }

            protected Item[] getSelection() {
                return MultiEditorTableViewer.this.getTable().getSelection();
            }

            protected void setEditor(Control w, Item item, int columnNumber) {
                MultiEditorTableViewer.this.fTableEditor.setEditor(w, (TableItem)item, columnNumber);
            }

            protected void setSelection(StructuredSelection selection, boolean b) {
                MultiEditorTableViewer.this.setSelection((ISelection)selection, b);
            }

            protected void showSelection() {
                MultiEditorTableViewer.this.getTable().showSelection();
            }

            protected void setLayoutData(CellEditor.LayoutData layoutData) {
                MultiEditorTableViewer.this.fTableEditor.grabHorizontal = true;
                MultiEditorTableViewer.this.fTableEditor.horizontalAlignment = layoutData.horizontalAlignment;
                MultiEditorTableViewer.this.fTableEditor.minimumWidth = layoutData.minimumWidth;
            }
        };
    }

    public final void saveEditorValue(CellEditor cellEditor, Item tableItem) {
        if (!IS_GTK) {
            ((MultiEditorTableViewerImpl)this.fTableViewerImpl).saveEditorValue(cellEditor, tableItem);
            this.updateEditors();
        }
    }

    public final void setMultiCellEditors(int[] styles) {
        if (!IS_GTK) {
            CellEditor[][] cellEditors = ((MultiEditorTableViewerImpl)this.fTableViewerImpl).getMultiCellEditors();
            if (cellEditors != null) {
                int i = 0;
                while (i < cellEditors.length) {
                    if (cellEditors[i] != null) {
                        int j = 0;
                        while (j < cellEditors[i].length) {
                            if (cellEditors[i][j] != null) {
                                cellEditors[i][j].dispose();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                cellEditors = null;
            }
            cellEditors = new CellEditor[styles.length][];
            int itemCount = this.fTable.getItemCount();
            int i = 0;
            while (i < styles.length) {
                int j;
                Object[] editors;
                if (styles[i] == 0) {
                    cellEditors[i] = null;
                } else if (styles[i] == 1) {
                    editors = new FocusTextCellEditor[itemCount];
                    j = 0;
                    while (j < editors.length) {
                        editors[j] = new FocusTextCellEditor((Composite)this.fTable);
                        this.initCellEditor((CellEditor)editors[j], j, i);
                        ++j;
                    }
                    cellEditors[i] = editors;
                } else if (styles[i] == 2) {
                    editors = new SnappyComboCellEditor[itemCount];
                    j = 0;
                    while (j < editors.length) {
                        editors[j] = new SnappyComboCellEditor(8);
                        editors[j].create((Composite)this.fTable);
                        editors[j].getControl().setBackground(this.fColorDefaultBackground);
                        this.initCellEditor((CellEditor)editors[j], j, i);
                        ++j;
                    }
                    cellEditors[i] = editors;
                } else if (styles[i] == 3) {
                    editors = new LabelCellEditor[itemCount];
                    j = 0;
                    while (j < editors.length) {
                        editors[j] = new LabelCellEditor((Composite)this.fTable);
                        editors[j].getControl().setBackground(this.fColorDefaultBackground);
                        this.initCellEditor((CellEditor)editors[j], j, i);
                        ++j;
                    }
                    cellEditors[i] = editors;
                }
                ++i;
            }
            ((MultiEditorTableViewerImpl)this.fTableViewerImpl).setMultiCellEditors(cellEditors);
        } else {
            CellEditor[] gtkCellEditors = new CellEditor[styles.length];
            int i = 0;
            while (i < gtkCellEditors.length) {
                if (styles[i] == 1) {
                    gtkCellEditors[i] = new FocusTextCellEditor((Composite)this.fTable);
                } else if (styles[i] == 2) {
                    gtkCellEditors[i] = new SnappyComboCellEditor(8);
                    gtkCellEditors[i].create((Composite)this.fTable);
                } else {
                    gtkCellEditors[i] = null;
                }
                ++i;
            }
            this.setCellEditors(gtkCellEditors);
        }
    }

    private void initCellEditor(CellEditor cellEditor, int rowIndex, int columnIndex) {
        TableEditor tableEditor = new TableEditor(this.fTable);
        tableEditor.grabHorizontal = true;
        TableItem item = this.fTable.getItem(rowIndex);
        item.setData("cellEditor", (Object)cellEditor);
        item.setData("viewer", (Object)this);
        tableEditor.setEditor(cellEditor.getControl(), item, columnIndex);
        cellEditor.getControl().setData((Object)tableEditor);
        ((MultiEditorTableViewerImpl)this.fTableViewerImpl).activateCellEditor(cellEditor, item, columnIndex);
    }

    public final void update(int index) {
        if (!IS_GTK) {
            CellEditor[][] multiCellEditors = ((MultiEditorTableViewerImpl)this.fTableViewerImpl).getMultiCellEditors();
            int i = 0;
            while (i < multiCellEditors.length) {
                if (multiCellEditors[i] != null) {
                    ((MultiEditorTableViewerImpl)this.fTableViewerImpl).activateCellEditor(multiCellEditors[i][index], this.fTable.getItem(index), i);
                }
                ++i;
            }
        }
    }

    public final void updateAll() {
        if (!IS_GTK) {
            int count = this.fTable.getItemCount();
            int i = 0;
            while (i < count) {
                this.update(i);
                ++i;
            }
            this.updateEditors();
        }
    }

    public final void reflowTableEditors() {
        if (!IS_GTK) {
            CellEditor[][] multiCellEditors = ((MultiEditorTableViewerImpl)this.fTableViewerImpl).getMultiCellEditors();
            int i = 0;
            while (i < multiCellEditors.length) {
                if (multiCellEditors[i] != null) {
                    int j = 0;
                    while (j < multiCellEditors[i].length) {
                        ((TableEditor)multiCellEditors[i][j].getControl().getData()).layout();
                        ++j;
                    }
                }
                ++i;
            }
            this.updateEditors();
        }
    }

    public void handleSelect(SelectionEvent e) {
        super.handleSelect(e);
        if (!IS_GTK) {
            CellEditor[][] editors = ((MultiEditorTableViewerImpl)this.fTableViewerImpl).getMultiCellEditors();
            if (editors != null && editors[1][0].getControl().getBounds().y != this.fTable.getItem((int)0).getBounds((int)1).y) {
                this.reflowTableEditors();
            }
            this.updateEditors();
        }
    }

    public void updateEditors() {
        if (!IS_GTK) {
            int oldIndex;
            int index = this.fTable.getSelectionIndex();
            int n = oldIndex = this.fSelectedItem != null ? this.fTable.indexOf(this.fSelectedItem) : -1;
            if (index > -1) {
                CellEditor[][] editors = ((MultiEditorTableViewerImpl)this.fTableViewerImpl).getMultiCellEditors();
                if (editors != null) {
                    boolean oneSelected;
                    Control control0 = editors[0][index].getControl();
                    Control control1 = editors[1][index].getControl();
                    Control control2 = editors[2][index].getControl();
                    boolean bl = oneSelected = control1.isFocusControl() || control2.isFocusControl();
                    if (!oneSelected) {
                        oneSelected = !control0.isFocusControl() && !control0.getParent().isFocusControl() && !this.fTable.isFocusControl();
                    }
                    Color backGround = oneSelected ? this.fColorSelectedInActiveBackground : this.fColorSelectedActiveBackground;
                    Color foreGround = oneSelected ? this.fColorSelectedInActiveForeground : this.fColorSelectedActiveForeground;
                    control0.setBackground(backGround);
                    control0.setForeground(foreGround);
                    if (!control1.isFocusControl()) {
                        control1.setBackground(backGround);
                        control1.setForeground(foreGround);
                    } else {
                        control1.setBackground(this.fColorDefaultBackground);
                        control1.setForeground(this.fColorDefaultForeground);
                    }
                    if (!control2.isFocusControl()) {
                        control2.setBackground(backGround);
                        control2.setForeground(foreGround);
                    } else {
                        control2.setBackground(this.fColorDefaultBackground);
                        control2.setForeground(this.fColorDefaultForeground);
                    }
                    if (oldIndex > -1 && oldIndex != index) {
                        Control control = editors[0][oldIndex].getControl();
                        control.setBackground(this.fColorDefaultBackground);
                        control.setForeground(this.fColorDefaultForeground);
                        control = editors[1][oldIndex].getControl();
                        control.setBackground(this.fColorDefaultBackground);
                        control.setForeground(this.fColorDefaultForeground);
                        control = editors[2][oldIndex].getControl();
                        control.setBackground(this.fColorDefaultBackground);
                        control.setForeground(this.fColorDefaultForeground);
                    }
                }
                this.fSelectedItem = this.fTable.getSelection()[0];
            }
        }
    }

    abstract class MultiEditorTableViewerImpl
    extends TableViewerImpl {
        private CellEditor[][] fMultiCellEditors;

        MultiEditorTableViewerImpl() {
        }

        public void setMultiCellEditors(CellEditor[][] editors) {
            this.fMultiCellEditors = editors;
        }

        public CellEditor[][] getMultiCellEditors() {
            return this.fMultiCellEditors;
        }

        protected final void activateCellEditor() {
            if (IS_GTK) {
                super.activateCellEditor();
                if (this.fCellEditor != null) {
                    this.fCellEditor.getControl().setData("node", this.fTableItem.getData());
                }
            } else {
                String property;
                Object element = this.fTableItem.getData();
                if (this.fCellModifier.canModify(element, property = this.fColumnProperties[this.fColumnNumber])) {
                    this.fCellEditor = (CellEditor)this.fTableItem.getData("cellEditor");
                    this.fCellEditor.addListener(this.fCellEditorListener);
                    Object value = this.fCellModifier.getValue((Object)this.fTableItem, property);
                    this.fCellEditor.setValue(value);
                    Control control = this.fCellEditor.getControl();
                    this.fCellEditor.activate();
                    if (control != null) {
                        this.setLayoutData(this.fCellEditor.getLayoutData());
                        this.setEditor(control, this.fTableItem, this.fColumnNumber);
                        this.fCellEditor.setFocus();
                    }
                }
            }
        }

        public void applyEditorValue() {
            if (IS_GTK) {
                super.applyEditorValue();
            } else {
                CellEditor c = this.fCellEditor;
                if (c != null) {
                    this.fCellEditor = null;
                    Item t = this.fTableItem;
                    if (t != null && !t.isDisposed()) {
                        this.saveEditorValue(c, t);
                    }
                    this.setEditor(null, null, 0);
                    c.removeListener(this.fCellEditorListener);
                }
            }
        }

        protected final void activateCellEditor(CellEditor cellEditor, TableItem item, int columnNumber) {
            String property = this.fColumnProperties[columnNumber];
            Object value = this.fCellModifier.getValue((Object)item, property);
            cellEditor.setValue(value);
            Control control = cellEditor.getControl();
            if (control != null) {
                this.setLayoutData(cellEditor.getLayoutData());
            }
        }

        protected void saveEditorValue(CellEditor cellEditor, Item tableItem) {
            if (IS_GTK) {
                super.saveEditorValue(cellEditor, tableItem);
            } else if (this.fCellModifier != null) {
                cellEditor.isValueValid();
                String property = null;
                this.fColumnNumber = ((TableEditor)cellEditor.getControl().getData()).getColumn();
                if (this.fColumnProperties != null && this.fColumnNumber < this.fColumnProperties.length) {
                    property = this.fColumnProperties[this.fColumnNumber];
                }
                this.fCellModifier.modify((Object)tableItem, property, cellEditor.getValue());
            }
        }
    }
}

